package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceFilterName {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName
}
object ServiceFilterName {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName
  ): io.github.vigoo.zioaws.servicediscovery.model.ServiceFilterName =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName.NAMESPACE_ID =>
        val r = NAMESPACE_ID
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName =
      software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object NAMESPACE_ID
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName =
      software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName.NAMESPACE_ID
  }
}
