package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceType {
  def unwrap: software.amazon.awssdk.services.servicediscovery.model.ServiceType
}
object ServiceType {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.ServiceType
  ): io.github.vigoo.zioaws.servicediscovery.model.ServiceType = value match {
    case software.amazon.awssdk.services.servicediscovery.model.ServiceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicediscovery.model.ServiceType.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.servicediscovery.model.ServiceType.DNS_HTTP =>
      val r = DNS_HTTP
      r
    case software.amazon.awssdk.services.servicediscovery.model.ServiceType.DNS =>
      val r = DNS
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceType =
      software.amazon.awssdk.services.servicediscovery.model.ServiceType.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceType =
      software.amazon.awssdk.services.servicediscovery.model.ServiceType.HTTP
  }
  case object DNS_HTTP
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceType =
      software.amazon.awssdk.services.servicediscovery.model.ServiceType.DNS_HTTP
  }
  case object DNS
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceType {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceType =
      software.amazon.awssdk.services.servicediscovery.model.ServiceType.DNS
  }
}
