package io.github.vigoo.zioaws.servicediscovery.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceTypeOption {
  def unwrap
      : software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption
}
object ServiceTypeOption {
  def wrap(
      value: software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption
  ): io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption =
    value match {
      case software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption.HTTP =>
        val r = HTTP
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption =
      software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP
      extends io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption {
    override def unwrap
        : software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption =
      software.amazon.awssdk.services.servicediscovery.model.ServiceTypeOption.HTTP
  }
}
