package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  TagKey,
  AmazonResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceARN: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest
      .builder()
      .resourceARN(resourceARN: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UntagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UntagResourceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .UntagResourceRequest(resourceARNValue, tagKeysValue)
    def resourceARNValue: AmazonResourceName
    def tagKeysValue: List[TagKey]
    def resourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARNValue)
    def tagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UntagResourceRequest.ReadOnly {
    override def resourceARNValue: AmazonResourceName =
      impl.resourceARN(): AmazonResourceName
    override def tagKeysValue: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: TagKey
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
