package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateHttpNamespaceRequest(
    id: ResourceId,
    updaterRequestId: Option[ResourceId] = None,
    namespace: io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest = {
    import UpdateHttpNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(updaterRequestId.map(value => value: java.lang.String))(
        _.updaterRequestId
      )
      .namespace(namespace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceRequest
      .wrap(buildAwsValue())
}
object UpdateHttpNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceRequest =
      io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceRequest(
        idValue,
        updaterRequestIdValue.map(value => value),
        namespaceValue.editable
      )
    def idValue: ResourceId
    def updaterRequestIdValue: Option[ResourceId]
    def namespaceValue
        : io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange.ReadOnly
    def id: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(idValue)
    def updaterRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("updaterRequestId", updaterRequestIdValue)
    def namespace: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange.ReadOnly
    ] = ZIO.succeed(namespaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceRequest.ReadOnly {
    override def idValue: ResourceId = impl.id(): ResourceId
    override def updaterRequestIdValue: Option[ResourceId] =
      scala.Option(impl.updaterRequestId()).map(value => value: ResourceId)
    override def namespaceValue
        : io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange.ReadOnly =
      io.github.vigoo.zioaws.servicediscovery.model.HttpNamespaceChange
        .wrap(impl.namespace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
