package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateHttpNamespaceResponse(
    operationId: Option[OperationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceResponse = {
    import UpdateHttpNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceResponse
      .builder()
      .optionallyWith(operationId.map(value => value: java.lang.String))(
        _.operationId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse
      .wrap(buildAwsValue())
}
object UpdateHttpNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .UpdateHttpNamespaceResponse(operationIdValue.map(value => value))
    def operationIdValue: Option[OperationId]
    def operationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly {
    override def operationIdValue: Option[OperationId] =
      scala.Option(impl.operationId()).map(value => value: OperationId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
