package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateInstanceCustomHealthStatusRequest(
    serviceId: ResourceId,
    instanceId: ResourceId,
    status: io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest = {
    import UpdateInstanceCustomHealthStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest
      .builder()
      .serviceId(serviceId: java.lang.String)
      .instanceId(instanceId: java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest
      .wrap(buildAwsValue())
}
object UpdateInstanceCustomHealthStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .UpdateInstanceCustomHealthStatusRequest(
          serviceIdValue,
          instanceIdValue,
          statusValue
        )
    def serviceIdValue: ResourceId
    def instanceIdValue: ResourceId
    def statusValue
        : io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus
    def serviceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(serviceIdValue)
    def instanceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(instanceIdValue)
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus
    ] = ZIO.succeed(statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest.ReadOnly {
    override def serviceIdValue: ResourceId = impl.serviceId(): ResourceId
    override def instanceIdValue: ResourceId = impl.instanceId(): ResourceId
    override def statusValue
        : io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus =
      io.github.vigoo.zioaws.servicediscovery.model.CustomHealthStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest.ReadOnly =
    new Wrapper(impl)
}
