package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdatePrivateDnsNamespaceRequest(
    id: ResourceId,
    updaterRequestId: Option[ResourceId] = None,
    namespace: io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest = {
    import UpdatePrivateDnsNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(updaterRequestId.map(value => value: java.lang.String))(
        _.updaterRequestId
      )
      .namespace(namespace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceRequest
      .wrap(buildAwsValue())
}
object UpdatePrivateDnsNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .UpdatePrivateDnsNamespaceRequest(
          idValue,
          updaterRequestIdValue.map(value => value),
          namespaceValue.editable
        )
    def idValue: ResourceId
    def updaterRequestIdValue: Option[ResourceId]
    def namespaceValue
        : io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange.ReadOnly
    def id: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(idValue)
    def updaterRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("updaterRequestId", updaterRequestIdValue)
    def namespace: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange.ReadOnly
    ] = ZIO.succeed(namespaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceRequest.ReadOnly {
    override def idValue: ResourceId = impl.id(): ResourceId
    override def updaterRequestIdValue: Option[ResourceId] =
      scala.Option(impl.updaterRequestId()).map(value => value: ResourceId)
    override def namespaceValue
        : io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange.ReadOnly =
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceChange
        .wrap(impl.namespace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
