package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdatePrivateDnsNamespaceResponse(
    operationId: Option[OperationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse = {
    import UpdatePrivateDnsNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse
      .builder()
      .optionallyWith(operationId.map(value => value: java.lang.String))(
        _.operationId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse
      .wrap(buildAwsValue())
}
object UpdatePrivateDnsNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .UpdatePrivateDnsNamespaceResponse(operationIdValue.map(value => value))
    def operationIdValue: Option[OperationId]
    def operationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly {
    override def operationIdValue: Option[OperationId] =
      scala.Option(impl.operationId()).map(value => value: OperationId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
