package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdatePublicDnsNamespaceResponse(
    operationId: Option[OperationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse = {
    import UpdatePublicDnsNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse
      .builder()
      .optionallyWith(operationId.map(value => value: java.lang.String))(
        _.operationId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse
      .wrap(buildAwsValue())
}
object UpdatePublicDnsNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .UpdatePublicDnsNamespaceResponse(operationIdValue.map(value => value))
    def operationIdValue: Option[OperationId]
    def operationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly {
    override def operationIdValue: Option[OperationId] =
      scala.Option(impl.operationId()).map(value => value: OperationId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
