package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceRequest(
    id: ResourceId,
    service: io.github.vigoo.zioaws.servicediscovery.model.ServiceChange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest
      .builder()
      .id(id: java.lang.String)
      .service(service.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceRequest
      .wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .UpdateServiceRequest(idValue, serviceValue.editable)
    def idValue: ResourceId
    def serviceValue
        : io.github.vigoo.zioaws.servicediscovery.model.ServiceChange.ReadOnly
    def id: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(idValue)
    def service: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.servicediscovery.model.ServiceChange.ReadOnly
    ] = ZIO.succeed(serviceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceRequest.ReadOnly {
    override def idValue: ResourceId = impl.id(): ResourceId
    override def serviceValue
        : io.github.vigoo.zioaws.servicediscovery.model.ServiceChange.ReadOnly =
      io.github.vigoo.zioaws.servicediscovery.model.ServiceChange
        .wrap(impl.service())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceRequest.ReadOnly =
    new Wrapper(impl)
}
