package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateServiceResponse(
    operationId: Option[OperationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse = {
    import UpdateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse
      .builder()
      .optionallyWith(operationId.map(value => value: java.lang.String))(
        _.operationId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse
      .wrap(buildAwsValue())
}
object UpdateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .UpdateServiceResponse(operationIdValue.map(value => value))
    def operationIdValue: Option[OperationId]
    def operationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly {
    override def operationIdValue: Option[OperationId] =
      scala.Option(impl.operationId()).map(value => value: OperationId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly =
    new Wrapper(impl)
}
