package io.github.vigoo.zioaws.servicediscovery
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  AttrKey,
  AttrValue,
  FilterValue,
  ResourceId,
  TagKey
}
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    type AmazonResourceName = String
    type Arn = String
    type AttrKey = String
    type AttrValue = String
    type Code = String
    type DiscoverMaxResults = Int
    type FailureThreshold = Int
    type FilterValue = String
    type InstanceId = String
    type MaxResults = Int
    type Message = String
    type NamespaceName = String
    type NamespaceNameHttp = String
    type NamespaceNamePrivate = String
    type NamespaceNamePublic = String
    type NextToken = String
    type OperationId = String
    type RecordTTL = Long
    type ResourceCount = Int
    type ResourceDescription = String
    type ResourceId = String
    type ResourcePath = String
    type ServiceName = String
    type TagKey = String
    type TagValue = String
    type Timestamp = Instant
  }
  type Attributes = Map[AttrKey, AttrValue]
  type DnsRecordList =
    List[io.github.vigoo.zioaws.servicediscovery.model.DnsRecord]
  type FilterValues = List[FilterValue]
  type HttpInstanceSummaryList =
    List[io.github.vigoo.zioaws.servicediscovery.model.HttpInstanceSummary]
  type InstanceHealthStatusMap =
    Map[ResourceId, io.github.vigoo.zioaws.servicediscovery.model.HealthStatus]
  type InstanceIdList = List[ResourceId]
  type InstanceSummaryList =
    List[io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary]
  type NamespaceFilters =
    List[io.github.vigoo.zioaws.servicediscovery.model.NamespaceFilter]
  type NamespaceSummariesList =
    List[io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary]
  type OperationFilters =
    List[io.github.vigoo.zioaws.servicediscovery.model.OperationFilter]
  type OperationSummaryList =
    List[io.github.vigoo.zioaws.servicediscovery.model.OperationSummary]
  type OperationTargetsMap = Map[
    io.github.vigoo.zioaws.servicediscovery.model.OperationTargetType,
    ResourceId
  ]
  type ServiceFilters =
    List[io.github.vigoo.zioaws.servicediscovery.model.ServiceFilter]
  type ServiceSummariesList =
    List[io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary]
  type TagKeyList = List[TagKey]
  type TagList = List[io.github.vigoo.zioaws.servicediscovery.model.Tag]
}
