package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.servicediscovery.ServiceDiscovery
import io.github.vigoo.zioaws.servicediscovery.model.{
  CreateHttpNamespaceRequest,
  CreatePrivateDnsNamespaceRequest,
  GetInstancesHealthStatusRequest,
  DeleteServiceRequest,
  GetInstanceRequest,
  ListNamespacesRequest,
  GetOperationRequest,
  ListInstancesRequest,
  UpdatePrivateDnsNamespaceRequest,
  UpdateHttpNamespaceRequest,
  ListTagsForResourceRequest,
  DeleteNamespaceRequest,
  DeregisterInstanceRequest,
  UpdateInstanceCustomHealthStatusRequest,
  HealthStatus,
  DiscoverInstancesRequest,
  CreateServiceRequest,
  CreatePublicDnsNamespaceRequest,
  UpdatePublicDnsNamespaceRequest,
  RegisterInstanceRequest,
  GetServiceRequest,
  UntagResourceRequest,
  ListServicesRequest,
  UpdateServiceRequest,
  ListOperationsRequest,
  TagResourceRequest,
  GetNamespaceRequest
}
import io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse.ReadOnly
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.servicediscovery.model.{
  InstanceSummary,
  DiscoverInstancesResponse,
  NamespaceSummary,
  ListInstancesResponse,
  GetServiceResponse,
  GetInstancesHealthStatusResponse,
  GetInstanceResponse,
  ListNamespacesResponse,
  ServiceSummary,
  UpdateServiceResponse,
  CreateServiceResponse,
  DeleteServiceResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateHttpNamespaceResponse,
  CreatePublicDnsNamespaceResponse,
  GetOperationResponse,
  ListOperationsResponse,
  DeregisterInstanceResponse,
  CreatePrivateDnsNamespaceResponse,
  RegisterInstanceResponse,
  OperationSummary,
  DeleteNamespaceResponse,
  UpdatePrivateDnsNamespaceResponse,
  UpdateHttpNamespaceResponse,
  UpdatePublicDnsNamespaceResponse,
  UpdateInstanceCustomHealthStatusResponse,
  TagResourceResponse,
  GetNamespaceResponse,
  ListServicesResponse
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.servicediscovery.{
  ServiceDiscoveryAsyncClientBuilder,
  ServiceDiscoveryAsyncClient
}
import zio.stream.ZStream
import io.github.vigoo.zioaws.servicediscovery.model.primitives.ResourceId
import zio.test.mock.{Proxy, Mock}
package object servicediscovery {
  import scala.jdk.CollectionConverters.*
  type ServiceDiscovery = Has[ServiceDiscovery.Service]
  object ServiceDiscovery {
    trait Service extends AspectSupport[Service] {
      val api: ServiceDiscoveryAsyncClient
      def createPrivateDnsNamespace(
          request: CreatePrivateDnsNamespaceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceResponse.ReadOnly
      ]
      def createHttpNamespace(request: CreateHttpNamespaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly
      ]
      def updateHttpNamespace(request: UpdateHttpNamespaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly
      ]
      def createPublicDnsNamespace(
          request: CreatePublicDnsNamespaceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly
      ]
      def createService(request: CreateServiceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly
      ]
      def updatePublicDnsNamespace(
          request: UpdatePublicDnsNamespaceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly
      ]
      def getInstancesHealthStatus(
          request: GetInstancesHealthStatusRequest
      ): ZStream[Any, AwsError, Tuple2[ResourceId, HealthStatus]]
      def listInstances(request: ListInstancesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
      ]
      def getNamespace(request: GetNamespaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly
      ]
      def updateInstanceCustomHealthStatus(
          request: UpdateInstanceCustomHealthStatusRequest
      ): IO[AwsError, Unit]
      def deleteService(request: DeleteServiceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.DeleteServiceResponse.ReadOnly
      ]
      def listServices(request: ListServicesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
      ]
      def getInstance(request: GetInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly
      ]
      def listOperations(request: ListOperationsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
      ]
      def deregisterInstance(request: DeregisterInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly
      ]
      def listNamespaces(request: ListNamespacesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
      ]
      def untagResource(request: UntagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.UntagResourceResponse.ReadOnly
      ]
      def updatePrivateDnsNamespace(
          request: UpdatePrivateDnsNamespaceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly
      ]
      def discoverInstances(
          request: DiscoverInstancesRequest
      ): IO[AwsError, ReadOnly]
      def getService(request: GetServiceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.GetServiceResponse.ReadOnly
      ]
      def listTagsForResource(request: ListTagsForResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceResponse.ReadOnly
      ]
      def tagResource(request: TagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.TagResourceResponse.ReadOnly
      ]
      def getOperation(request: GetOperationRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly
      ]
      def deleteNamespace(request: DeleteNamespaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.DeleteNamespaceResponse.ReadOnly
      ]
      def updateService(request: UpdateServiceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly
      ]
      def registerInstance(request: RegisterInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceResponse.ReadOnly
      ]
    }
    object ServiceDiscoveryMock extends Mock[ServiceDiscovery] {
      object CreatePrivateDnsNamespace
          extends Effect[
            CreatePrivateDnsNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceResponse.ReadOnly
          ]
      object CreateHttpNamespace
          extends Effect[
            CreateHttpNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly
          ]
      object UpdateHttpNamespace
          extends Effect[
            UpdateHttpNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly
          ]
      object CreatePublicDnsNamespace
          extends Effect[
            CreatePublicDnsNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly
          ]
      object CreateService
          extends Effect[
            CreateServiceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly
          ]
      object UpdatePublicDnsNamespace
          extends Effect[
            UpdatePublicDnsNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly
          ]
      object GetInstancesHealthStatus
          extends Stream[
            GetInstancesHealthStatusRequest,
            AwsError,
            Tuple2[ResourceId, HealthStatus]
          ]
      object ListInstances
          extends Stream[
            ListInstancesRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
          ]
      object GetNamespace
          extends Effect[
            GetNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly
          ]
      object UpdateInstanceCustomHealthStatus
          extends Effect[
            UpdateInstanceCustomHealthStatusRequest,
            AwsError,
            Unit
          ]
      object DeleteService
          extends Effect[
            DeleteServiceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.DeleteServiceResponse.ReadOnly
          ]
      object ListServices
          extends Stream[
            ListServicesRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
          ]
      object GetInstance
          extends Effect[
            GetInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly
          ]
      object ListOperations
          extends Stream[
            ListOperationsRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
          ]
      object DeregisterInstance
          extends Effect[
            DeregisterInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly
          ]
      object ListNamespaces
          extends Stream[
            ListNamespacesRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
          ]
      object UntagResource
          extends Effect[
            UntagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.UntagResourceResponse.ReadOnly
          ]
      object UpdatePrivateDnsNamespace
          extends Effect[
            UpdatePrivateDnsNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly
          ]
      object DiscoverInstances
          extends Effect[DiscoverInstancesRequest, AwsError, ReadOnly]
      object GetService
          extends Effect[
            GetServiceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.GetServiceResponse.ReadOnly
          ]
      object ListTagsForResource
          extends Effect[
            ListTagsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceResponse.ReadOnly
          ]
      object TagResource
          extends Effect[
            TagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.TagResourceResponse.ReadOnly
          ]
      object GetOperation
          extends Effect[
            GetOperationRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly
          ]
      object DeleteNamespace
          extends Effect[
            DeleteNamespaceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.DeleteNamespaceResponse.ReadOnly
          ]
      object UpdateService
          extends Effect[
            UpdateServiceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly
          ]
      object RegisterInstance
          extends Effect[
            RegisterInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], ServiceDiscovery] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new ServiceDiscovery.Service {
              val api: ServiceDiscoveryAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): ServiceDiscovery.Service = this
              def createPrivateDnsNamespace(
                  request: CreatePrivateDnsNamespaceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceResponse.ReadOnly
              ] = proxy(CreatePrivateDnsNamespace, request)
              def createHttpNamespace(request: CreateHttpNamespaceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly
              ] = proxy(CreateHttpNamespace, request)
              def updateHttpNamespace(request: UpdateHttpNamespaceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly
              ] = proxy(UpdateHttpNamespace, request)
              def createPublicDnsNamespace(
                  request: CreatePublicDnsNamespaceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly
              ] = proxy(CreatePublicDnsNamespace, request)
              def createService(request: CreateServiceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly
              ] = proxy(CreateService, request)
              def updatePublicDnsNamespace(
                  request: UpdatePublicDnsNamespaceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly
              ] = proxy(UpdatePublicDnsNamespace, request)
              def getInstancesHealthStatus(
                  request: GetInstancesHealthStatusRequest
              ): ZStream[Any, AwsError, Tuple2[ResourceId, HealthStatus]] =
                rts.unsafeRun(proxy(GetInstancesHealthStatus, request))
              def listInstances(request: ListInstancesRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
              ] = rts.unsafeRun(proxy(ListInstances, request))
              def getNamespace(request: GetNamespaceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly
              ] = proxy(GetNamespace, request)
              def updateInstanceCustomHealthStatus(
                  request: UpdateInstanceCustomHealthStatusRequest
              ): IO[AwsError, Unit] =
                proxy(UpdateInstanceCustomHealthStatus, request)
              def deleteService(request: DeleteServiceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.DeleteServiceResponse.ReadOnly
              ] = proxy(DeleteService, request)
              def listServices(request: ListServicesRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
              ] = rts.unsafeRun(proxy(ListServices, request))
              def getInstance(request: GetInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly
              ] = proxy(GetInstance, request)
              def listOperations(request: ListOperationsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
              ] = rts.unsafeRun(proxy(ListOperations, request))
              def deregisterInstance(request: DeregisterInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly
              ] = proxy(DeregisterInstance, request)
              def listNamespaces(request: ListNamespacesRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
              ] = rts.unsafeRun(proxy(ListNamespaces, request))
              def untagResource(request: UntagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.UntagResourceResponse.ReadOnly
              ] = proxy(UntagResource, request)
              def updatePrivateDnsNamespace(
                  request: UpdatePrivateDnsNamespaceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly
              ] = proxy(UpdatePrivateDnsNamespace, request)
              def discoverInstances(
                  request: DiscoverInstancesRequest
              ): IO[AwsError, ReadOnly] = proxy(DiscoverInstances, request)
              def getService(request: GetServiceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.GetServiceResponse.ReadOnly
              ] = proxy(GetService, request)
              def listTagsForResource(request: ListTagsForResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceResponse.ReadOnly
              ] = proxy(ListTagsForResource, request)
              def tagResource(request: TagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.TagResourceResponse.ReadOnly
              ] = proxy(TagResource, request)
              def getOperation(request: GetOperationRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly
              ] = proxy(GetOperation, request)
              def deleteNamespace(request: DeleteNamespaceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.DeleteNamespaceResponse.ReadOnly
              ] = proxy(DeleteNamespace, request)
              def updateService(request: UpdateServiceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly
              ] = proxy(UpdateService, request)
              def registerInstance(request: RegisterInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceResponse.ReadOnly
              ] = proxy(RegisterInstance, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, ServiceDiscovery] =
    customized(identity)
  def customized(
      customization: ServiceDiscoveryAsyncClientBuilder => ServiceDiscoveryAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ServiceDiscovery] = managed(
    customization
  ).toLayer
  def managed(
      customization: ServiceDiscoveryAsyncClientBuilder => ServiceDiscoveryAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ServiceDiscovery.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = ServiceDiscoveryAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ServiceDiscoveryAsyncClient,
        ServiceDiscoveryAsyncClientBuilder
      ](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[
        ServiceDiscoveryAsyncClient,
        ServiceDiscoveryAsyncClientBuilder
      ](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new ServiceDiscoveryImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class ServiceDiscoveryImpl[R](
      override val api: ServiceDiscoveryAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends ServiceDiscovery.Service
      with AwsServiceBase[R, ServiceDiscoveryImpl] {
    override val serviceName: String = "ServiceDiscovery"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): ServiceDiscoveryImpl[R1] = new ServiceDiscoveryImpl(api, newAspect, r)
    def createPrivateDnsNamespace(
        request: CreatePrivateDnsNamespaceRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest,
      CreatePrivateDnsNamespaceResponse
    ]("createPrivateDnsNamespace", api.createPrivateDnsNamespace)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceResponse.wrap
    ).provide(r)
    def createHttpNamespace(request: CreateHttpNamespaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest,
      CreateHttpNamespaceResponse
    ]("createHttpNamespace", api.createHttpNamespace)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.wrap
      )
      .provide(r)
    def updateHttpNamespace(request: UpdateHttpNamespaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest,
      UpdateHttpNamespaceResponse
    ]("updateHttpNamespace", api.updateHttpNamespace)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.wrap
      )
      .provide(r)
    def createPublicDnsNamespace(request: CreatePublicDnsNamespaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest,
      CreatePublicDnsNamespaceResponse
    ]("createPublicDnsNamespace", api.createPublicDnsNamespace)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.wrap
    ).provide(r)
    def createService(request: CreateServiceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest,
      CreateServiceResponse
    ]("createService", api.createService)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.wrap
      )
      .provide(r)
    def updatePublicDnsNamespace(request: UpdatePublicDnsNamespaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceRequest,
      UpdatePublicDnsNamespaceResponse
    ]("updatePublicDnsNamespace", api.updatePublicDnsNamespace)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.wrap
    ).provide(r)
    def getInstancesHealthStatus(
        request: GetInstancesHealthStatusRequest
    ): ZStream[Any, AwsError, Tuple2[ResourceId, HealthStatus]] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest,
        GetInstancesHealthStatusResponse,
        (
            java.lang.String,
            software.amazon.awssdk.services.servicediscovery.model.HealthStatus
        )
      ](
        "getInstancesHealthStatus",
        api.getInstancesHealthStatus,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.status().asScala)
      )(request.buildAwsValue())
        .map({ case (key, value) =>
          (key: ResourceId) -> HealthStatus.wrap(value)
        })
        .provide(r)
    def listInstances(request: ListInstancesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest,
      ListInstancesResponse,
      InstanceSummary
    ](
      "listInstances",
      api.listInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instances().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.wrap(item)
      )
      .provide(r)
    def getNamespace(request: GetNamespaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest,
      GetNamespaceResponse
    ]("getNamespace", api.getNamespace)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.wrap
      )
      .provide(r)
    def updateInstanceCustomHealthStatus(
        request: UpdateInstanceCustomHealthStatusRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest,
      UpdateInstanceCustomHealthStatusResponse
    ]("updateInstanceCustomHealthStatus", api.updateInstanceCustomHealthStatus)(
      request.buildAwsValue()
    ).unit.provide(r)
    def deleteService(request: DeleteServiceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.DeleteServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest,
      DeleteServiceResponse
    ]("deleteService", api.deleteService)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.DeleteServiceResponse.wrap
      )
      .provide(r)
    def listServices(request: ListServicesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest,
      ListServicesResponse,
      ServiceSummary
    ](
      "listServices",
      api.listServices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.services().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.wrap(item)
      )
      .provide(r)
    def getInstance(request: GetInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest,
      GetInstanceResponse
    ]("getInstance", api.getInstance)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.wrap
      )
      .provide(r)
    def listOperations(request: ListOperationsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest,
      ListOperationsResponse,
      OperationSummary
    ](
      "listOperations",
      api.listOperations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.operations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.servicediscovery.model.OperationSummary
          .wrap(item)
      )
      .provide(r)
    def deregisterInstance(request: DeregisterInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest,
      DeregisterInstanceResponse
    ]("deregisterInstance", api.deregisterInstance)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.wrap
      )
      .provide(r)
    def listNamespaces(request: ListNamespacesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest,
      ListNamespacesResponse,
      NamespaceSummary
    ](
      "listNamespaces",
      api.listNamespaces,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.namespaces().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary
          .wrap(item)
      )
      .provide(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.UntagResourceResponse.wrap
      )
      .provide(r)
    def updatePrivateDnsNamespace(
        request: UpdatePrivateDnsNamespaceRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest,
      UpdatePrivateDnsNamespaceResponse
    ]("updatePrivateDnsNamespace", api.updatePrivateDnsNamespace)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.wrap
    ).provide(r)
    def discoverInstances(
        request: DiscoverInstancesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest,
      DiscoverInstancesResponse
    ]("discoverInstances", api.discoverInstances)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.DiscoverInstancesResponse.wrap
      )
      .provide(r)
    def getService(request: GetServiceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.GetServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest,
      GetServiceResponse
    ]("getService", api.getService)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.GetServiceResponse.wrap
      )
      .provide(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceResponse.wrap
      )
      .provide(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.TagResourceResponse.wrap
      )
      .provide(r)
    def getOperation(request: GetOperationRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest,
      GetOperationResponse
    ]("getOperation", api.getOperation)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.wrap
      )
      .provide(r)
    def deleteNamespace(request: DeleteNamespaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.DeleteNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest,
      DeleteNamespaceResponse
    ]("deleteNamespace", api.deleteNamespace)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.DeleteNamespaceResponse.wrap
      )
      .provide(r)
    def updateService(request: UpdateServiceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest,
      UpdateServiceResponse
    ]("updateService", api.updateService)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.wrap
      )
      .provide(r)
    def registerInstance(request: RegisterInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest,
      RegisterInstanceResponse
    ]("registerInstance", api.registerInstance)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceResponse.wrap
      )
      .provide(r)
  }
  def createPrivateDnsNamespace(request: CreatePrivateDnsNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.createPrivateDnsNamespace(request))
  def createHttpNamespace(request: CreateHttpNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.createHttpNamespace(request))
  def updateHttpNamespace(request: UpdateHttpNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.UpdateHttpNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateHttpNamespace(request))
  def createPublicDnsNamespace(request: CreatePublicDnsNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.createPublicDnsNamespace(request))
  def createService(request: CreateServiceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.CreateServiceResponse.ReadOnly
  ] = ZIO.accessM(_.get.createService(request))
  def updatePublicDnsNamespace(request: UpdatePublicDnsNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.UpdatePublicDnsNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.updatePublicDnsNamespace(request))
  def getInstancesHealthStatus(
      request: GetInstancesHealthStatusRequest
  ): ZStream[ServiceDiscovery, AwsError, Tuple2[ResourceId, HealthStatus]] =
    ZStream.accessStream(_.get.getInstancesHealthStatus(request))
  def listInstances(request: ListInstancesRequest): ZStream[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.InstanceSummary.ReadOnly
  ] = ZStream.accessStream(_.get.listInstances(request))
  def getNamespace(request: GetNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.GetNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.getNamespace(request))
  def updateInstanceCustomHealthStatus(
      request: UpdateInstanceCustomHealthStatusRequest
  ): ZIO[ServiceDiscovery, AwsError, Unit] =
    ZIO.accessM(_.get.updateInstanceCustomHealthStatus(request))
  def deleteService(request: DeleteServiceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.DeleteServiceResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteService(request))
  def listServices(request: ListServicesRequest): ZStream[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.ServiceSummary.ReadOnly
  ] = ZStream.accessStream(_.get.listServices(request))
  def getInstance(request: GetInstanceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.GetInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstance(request))
  def listOperations(request: ListOperationsRequest): ZStream[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.OperationSummary.ReadOnly
  ] = ZStream.accessStream(_.get.listOperations(request))
  def deregisterInstance(request: DeregisterInstanceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.DeregisterInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.deregisterInstance(request))
  def listNamespaces(request: ListNamespacesRequest): ZStream[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.NamespaceSummary.ReadOnly
  ] = ZStream.accessStream(_.get.listNamespaces(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.UntagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.untagResource(request))
  def updatePrivateDnsNamespace(request: UpdatePrivateDnsNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.UpdatePrivateDnsNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.updatePrivateDnsNamespace(request))
  def discoverInstances(
      request: DiscoverInstancesRequest
  ): ZIO[ServiceDiscovery, AwsError, ReadOnly] =
    ZIO.accessM(_.get.discoverInstances(request))
  def getService(request: GetServiceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.GetServiceResponse.ReadOnly
  ] = ZIO.accessM(_.get.getService(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.TagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.tagResource(request))
  def getOperation(request: GetOperationRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.GetOperationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getOperation(request))
  def deleteNamespace(request: DeleteNamespaceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.DeleteNamespaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteNamespace(request))
  def updateService(request: UpdateServiceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.UpdateServiceResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateService(request))
  def registerInstance(request: RegisterInstanceRequest): ZIO[
    ServiceDiscovery,
    AwsError,
    io.github.vigoo.zioaws.servicediscovery.model.RegisterInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.registerInstance(request))
}
