package io.github.vigoo.zioaws.sso.model
import io.github.vigoo.zioaws.sso.model.primitives.{
  EmailAddressType,
  AccountNameType,
  AccountIdType
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountInfo(
    accountId: Option[AccountIdType] = None,
    accountName: Option[AccountNameType] = None,
    emailAddress: Option[EmailAddressType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.AccountInfo = {
    import AccountInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.AccountInfo
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(accountName.map(value => value: java.lang.String))(
        _.accountName
      )
      .optionallyWith(emailAddress.map(value => value: java.lang.String))(
        _.emailAddress
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly =
    io.github.vigoo.zioaws.sso.model.AccountInfo.wrap(buildAwsValue())
}
object AccountInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sso.model.AccountInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.AccountInfo =
      io.github.vigoo.zioaws.sso.model.AccountInfo(
        accountIdValue.map(value => value),
        accountNameValue.map(value => value),
        emailAddressValue.map(value => value)
      )
    def accountIdValue: Option[AccountIdType]
    def accountNameValue: Option[AccountNameType]
    def emailAddressValue: Option[EmailAddressType]
    def accountId: ZIO[Any, AwsError, AccountIdType] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def accountName: ZIO[Any, AwsError, AccountNameType] =
      AwsError.unwrapOptionField("accountName", accountNameValue)
    def emailAddress: ZIO[Any, AwsError, EmailAddressType] =
      AwsError.unwrapOptionField("emailAddress", emailAddressValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.AccountInfo
  ) extends io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly {
    override def accountIdValue: Option[AccountIdType] =
      scala.Option(impl.accountId()).map(value => value: AccountIdType)
    override def accountNameValue: Option[AccountNameType] =
      scala.Option(impl.accountName()).map(value => value: AccountNameType)
    override def emailAddressValue: Option[EmailAddressType] =
      scala.Option(impl.emailAddress()).map(value => value: EmailAddressType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.AccountInfo
  ): io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly = new Wrapper(impl)
}
