package io.github.vigoo.zioaws.sso.model
import io.github.vigoo.zioaws.sso.model.primitives.{
  AccessTokenType,
  AccountIdType,
  RoleNameType
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRoleCredentialsRequest(
    roleName: RoleNameType,
    accountId: AccountIdType,
    accessToken: AccessTokenType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest = {
    import GetRoleCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
      .builder()
      .roleName(roleName: java.lang.String)
      .accountId(accountId: java.lang.String)
      .accessToken(accessToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.sso.model.GetRoleCredentialsRequest.ReadOnly =
    io.github.vigoo.zioaws.sso.model.GetRoleCredentialsRequest
      .wrap(buildAwsValue())
}
object GetRoleCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.GetRoleCredentialsRequest =
      io.github.vigoo.zioaws.sso.model.GetRoleCredentialsRequest(
        roleNameValue,
        accountIdValue,
        accessTokenValue
      )
    def roleNameValue: RoleNameType
    def accountIdValue: AccountIdType
    def accessTokenValue: AccessTokenType
    def roleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleNameValue)
    def accountId: ZIO[Any, Nothing, AccountIdType] =
      ZIO.succeed(accountIdValue)
    def accessToken: ZIO[Any, Nothing, AccessTokenType] =
      ZIO.succeed(accessTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
  ) extends io.github.vigoo.zioaws.sso.model.GetRoleCredentialsRequest.ReadOnly {
    override def roleNameValue: RoleNameType = impl.roleName(): RoleNameType
    override def accountIdValue: AccountIdType = impl.accountId(): AccountIdType
    override def accessTokenValue: AccessTokenType =
      impl.accessToken(): AccessTokenType
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest
  ): io.github.vigoo.zioaws.sso.model.GetRoleCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
