package io.github.vigoo.zioaws.sso.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRoleCredentialsResponse(
    roleCredentials: Option[io.github.vigoo.zioaws.sso.model.RoleCredentials] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse = {
    import GetRoleCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
      .builder()
      .optionallyWith(roleCredentials.map(value => value.buildAwsValue()))(
        _.roleCredentials
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse.ReadOnly =
    io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse
      .wrap(buildAwsValue())
}
object GetRoleCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse =
      io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse(
        roleCredentialsValue.map(value => value.editable)
      )
    def roleCredentialsValue
        : Option[io.github.vigoo.zioaws.sso.model.RoleCredentials.ReadOnly]
    def roleCredentials: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.sso.model.RoleCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("roleCredentials", roleCredentialsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
  ) extends io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse.ReadOnly {
    override def roleCredentialsValue
        : Option[io.github.vigoo.zioaws.sso.model.RoleCredentials.ReadOnly] =
      scala
        .Option(impl.roleCredentials())
        .map(value =>
          io.github.vigoo.zioaws.sso.model.RoleCredentials.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse
  ): io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
