package io.github.vigoo.zioaws.sso.model
import io.github.vigoo.zioaws.sso.model.primitives.NextTokenType
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccountRolesResponse(
    nextToken: Option[NextTokenType] = None,
    roleList: Option[Iterable[io.github.vigoo.zioaws.sso.model.RoleInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountRolesResponse = {
    import ListAccountRolesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        roleList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roleList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.sso.model.ListAccountRolesResponse.ReadOnly =
    io.github.vigoo.zioaws.sso.model.ListAccountRolesResponse
      .wrap(buildAwsValue())
}
object ListAccountRolesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.ListAccountRolesResponse =
      io.github.vigoo.zioaws.sso.model.ListAccountRolesResponse(
        nextTokenValue.map(value => value),
        roleListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[NextTokenType]
    def roleListValue
        : Option[List[io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly]]
    def nextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def roleList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("roleList", roleListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ) extends io.github.vigoo.zioaws.sso.model.ListAccountRolesResponse.ReadOnly {
    override def nextTokenValue: Option[NextTokenType] =
      scala.Option(impl.nextToken()).map(value => value: NextTokenType)
    override def roleListValue
        : Option[List[io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly]] =
      scala
        .Option(impl.roleList())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.sso.model.RoleInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ): io.github.vigoo.zioaws.sso.model.ListAccountRolesResponse.ReadOnly =
    new Wrapper(impl)
}
