package io.github.vigoo.zioaws.sso.model
import java.lang.Integer
import io.github.vigoo.zioaws.sso.model.primitives.{
  AccessTokenType,
  MaxResultType,
  NextTokenType
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccountsRequest(
    nextToken: Option[NextTokenType] = None,
    maxResults: Option[MaxResultType] = None,
    accessToken: AccessTokenType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountsRequest = {
    import ListAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .accessToken(accessToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.sso.model.ListAccountsRequest.ReadOnly =
    io.github.vigoo.zioaws.sso.model.ListAccountsRequest.wrap(buildAwsValue())
}
object ListAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.ListAccountsRequest =
      io.github.vigoo.zioaws.sso.model.ListAccountsRequest(
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value),
        accessTokenValue
      )
    def nextTokenValue: Option[NextTokenType]
    def maxResultsValue: Option[MaxResultType]
    def accessTokenValue: AccessTokenType
    def nextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResultType] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def accessToken: ZIO[Any, Nothing, AccessTokenType] =
      ZIO.succeed(accessTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsRequest
  ) extends io.github.vigoo.zioaws.sso.model.ListAccountsRequest.ReadOnly {
    override def nextTokenValue: Option[NextTokenType] =
      scala.Option(impl.nextToken()).map(value => value: NextTokenType)
    override def maxResultsValue: Option[MaxResultType] =
      scala.Option(impl.maxResults()).map(value => value: MaxResultType)
    override def accessTokenValue: AccessTokenType =
      impl.accessToken(): AccessTokenType
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsRequest
  ): io.github.vigoo.zioaws.sso.model.ListAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
