package io.github.vigoo.zioaws.sso.model
import io.github.vigoo.zioaws.sso.model.primitives.NextTokenType
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccountsResponse(
    nextToken: Option[NextTokenType] = None,
    accountList: Option[
      Iterable[io.github.vigoo.zioaws.sso.model.AccountInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountsResponse = {
    import ListAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        accountList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.sso.model.ListAccountsResponse.ReadOnly =
    io.github.vigoo.zioaws.sso.model.ListAccountsResponse.wrap(buildAwsValue())
}
object ListAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.ListAccountsResponse =
      io.github.vigoo.zioaws.sso.model.ListAccountsResponse(
        nextTokenValue.map(value => value),
        accountListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[NextTokenType]
    def accountListValue
        : Option[List[io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly]]
    def nextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def accountList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("accountList", accountListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ) extends io.github.vigoo.zioaws.sso.model.ListAccountsResponse.ReadOnly {
    override def nextTokenValue: Option[NextTokenType] =
      scala.Option(impl.nextToken()).map(value => value: NextTokenType)
    override def accountListValue
        : Option[List[io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly]] =
      scala
        .Option(impl.accountList())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.sso.model.AccountInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ): io.github.vigoo.zioaws.sso.model.ListAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
