package io.github.vigoo.zioaws.sso.model
import io.github.vigoo.zioaws.sso.model.primitives.{
  ExpirationTimestampType,
  SessionTokenType,
  SecretAccessKeyType,
  AccessKeyType
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RoleCredentials(
    accessKeyId: Option[AccessKeyType] = None,
    secretAccessKey: Option[SecretAccessKeyType] = None,
    sessionToken: Option[SessionTokenType] = None,
    expiration: Option[ExpirationTimestampType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.RoleCredentials = {
    import RoleCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.RoleCredentials
      .builder()
      .optionallyWith(accessKeyId.map(value => value: java.lang.String))(
        _.accessKeyId
      )
      .optionallyWith(secretAccessKey.map(value => value: java.lang.String))(
        _.secretAccessKey
      )
      .optionallyWith(sessionToken.map(value => value: java.lang.String))(
        _.sessionToken
      )
      .optionallyWith(expiration.map(value => value: java.lang.Long))(
        _.expiration
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.sso.model.RoleCredentials.ReadOnly =
    io.github.vigoo.zioaws.sso.model.RoleCredentials.wrap(buildAwsValue())
}
object RoleCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.RoleCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.RoleCredentials =
      io.github.vigoo.zioaws.sso.model.RoleCredentials(
        accessKeyIdValue.map(value => value),
        secretAccessKeyValue.map(value => value),
        sessionTokenValue.map(value => value),
        expirationValue.map(value => value)
      )
    def accessKeyIdValue: Option[AccessKeyType]
    def secretAccessKeyValue: Option[SecretAccessKeyType]
    def sessionTokenValue: Option[SessionTokenType]
    def expirationValue: Option[ExpirationTimestampType]
    def accessKeyId: ZIO[Any, AwsError, AccessKeyType] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyIdValue)
    def secretAccessKey: ZIO[Any, AwsError, SecretAccessKeyType] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKeyValue)
    def sessionToken: ZIO[Any, AwsError, SessionTokenType] =
      AwsError.unwrapOptionField("sessionToken", sessionTokenValue)
    def expiration: ZIO[Any, AwsError, ExpirationTimestampType] =
      AwsError.unwrapOptionField("expiration", expirationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.RoleCredentials
  ) extends io.github.vigoo.zioaws.sso.model.RoleCredentials.ReadOnly {
    override def accessKeyIdValue: Option[AccessKeyType] =
      scala.Option(impl.accessKeyId()).map(value => value: AccessKeyType)
    override def secretAccessKeyValue: Option[SecretAccessKeyType] = scala
      .Option(impl.secretAccessKey())
      .map(value => value: SecretAccessKeyType)
    override def sessionTokenValue: Option[SessionTokenType] =
      scala.Option(impl.sessionToken()).map(value => value: SessionTokenType)
    override def expirationValue: Option[ExpirationTimestampType] = scala
      .Option(impl.expiration())
      .map(value => value: ExpirationTimestampType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.RoleCredentials
  ): io.github.vigoo.zioaws.sso.model.RoleCredentials.ReadOnly = new Wrapper(
    impl
  )
}
