package io.github.vigoo.zioaws.sso.model
import io.github.vigoo.zioaws.sso.model.primitives.{AccountIdType, RoleNameType}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RoleInfo(
    roleName: Option[RoleNameType] = None,
    accountId: Option[AccountIdType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.RoleInfo = {
    import RoleInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.RoleInfo
      .builder()
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly =
    io.github.vigoo.zioaws.sso.model.RoleInfo.wrap(buildAwsValue())
}
object RoleInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sso.model.RoleInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.RoleInfo =
      io.github.vigoo.zioaws.sso.model.RoleInfo(
        roleNameValue.map(value => value),
        accountIdValue.map(value => value)
      )
    def roleNameValue: Option[RoleNameType]
    def accountIdValue: Option[AccountIdType]
    def roleName: ZIO[Any, AwsError, RoleNameType] =
      AwsError.unwrapOptionField("roleName", roleNameValue)
    def accountId: ZIO[Any, AwsError, AccountIdType] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.RoleInfo
  ) extends io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly {
    override def roleNameValue: Option[RoleNameType] =
      scala.Option(impl.roleName()).map(value => value: RoleNameType)
    override def accountIdValue: Option[AccountIdType] =
      scala.Option(impl.accountId()).map(value => value: AccountIdType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.RoleInfo
  ): io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly = new Wrapper(impl)
}
