package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse.ReadOnly
import software.amazon.awssdk.services.sso.paginators.{
  ListAccountsPublisher,
  ListAccountRolesPublisher
}
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import io.github.vigoo.zioaws.sso.Sso
import io.github.vigoo.zioaws.sso.model.{
  LogoutRequest,
  ListAccountsRequest,
  ListAccountRolesRequest,
  GetRoleCredentialsRequest
}
import software.amazon.awssdk.services.sso.model.{
  AccountInfo,
  LogoutResponse,
  RoleInfo,
  GetRoleCredentialsResponse
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import software.amazon.awssdk.services.sso.{
  SsoAsyncClientBuilder,
  SsoAsyncClient
}
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
package object sso {
  import scala.jdk.CollectionConverters._
  type Sso = Has[Sso.Service]
  object Sso {
    trait Service extends AspectSupport[Service] {
      val api: SsoAsyncClient
      def getRoleCredentials(
          request: GetRoleCredentialsRequest
      ): IO[AwsError, ReadOnly]
      def listAccountRoles(request: ListAccountRolesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly
      ]
      def listAccounts(request: ListAccountsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly
      ]
      def logout(request: LogoutRequest): IO[AwsError, Unit]
    }
    object SsoMock extends Mock[Sso] {
      object GetRoleCredentials
          extends Effect[GetRoleCredentialsRequest, AwsError, ReadOnly]
      object ListAccountRoles
          extends Stream[
            ListAccountRolesRequest,
            AwsError,
            io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly
          ]
      object ListAccounts
          extends Stream[
            ListAccountsRequest,
            AwsError,
            io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly
          ]
      object Logout extends Effect[LogoutRequest, AwsError, Unit]
      val compose: URLayer[Has[Proxy], Sso] = ZLayer.fromServiceM { proxy =>
        withRuntime.map { rts =>
          new Sso.Service {
            val api: SsoAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: R1
            ): Sso.Service = this
            def getRoleCredentials(
                request: GetRoleCredentialsRequest
            ): IO[AwsError, ReadOnly] = proxy(GetRoleCredentials, request)
            def listAccountRoles(request: ListAccountRolesRequest): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly
            ] = rts.unsafeRun(proxy(ListAccountRoles, request))
            def listAccounts(request: ListAccountsRequest): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly
            ] = rts.unsafeRun(proxy(ListAccounts, request))
            def logout(request: LogoutRequest): IO[AwsError, Unit] =
              proxy(Logout, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, Sso] = customized(identity)
  def customized(
      customization: SsoAsyncClientBuilder => SsoAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Sso] = managed(
    customization
  ).toLayer
  def managed(
      customization: SsoAsyncClientBuilder => SsoAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Sso.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = SsoAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SsoAsyncClient, SsoAsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[SsoAsyncClient, SsoAsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  ) yield new SsoImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class SsoImpl[R](
      override val api: SsoAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends Sso.Service
      with AwsServiceBase[R, SsoImpl] {
    override val serviceName: String = "Sso"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): SsoImpl[R1] = new SsoImpl(api, newAspect, r)
    def getRoleCredentials(
        request: GetRoleCredentialsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest,
      GetRoleCredentialsResponse
    ]("getRoleCredentials", api.getRoleCredentials)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.sso.model.GetRoleCredentialsResponse.wrap)
      .provide(r)
    def listAccountRoles(request: ListAccountRolesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.sso.model.ListAccountRolesRequest,
      RoleInfo,
      ListAccountRolesPublisher
    ]("listAccountRoles", api.listAccountRolesPaginator, _.roleList())(
      request.buildAwsValue()
    ).map(item => io.github.vigoo.zioaws.sso.model.RoleInfo.wrap(item))
      .provide(r)
    def listAccounts(request: ListAccountsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.sso.model.ListAccountsRequest,
      AccountInfo,
      ListAccountsPublisher
    ]("listAccounts", api.listAccountsPaginator, _.accountList())(
      request.buildAwsValue()
    ).map(item => io.github.vigoo.zioaws.sso.model.AccountInfo.wrap(item))
      .provide(r)
    def logout(request: LogoutRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sso.model.LogoutRequest,
        LogoutResponse
      ]("logout", api.logout)(request.buildAwsValue()).unit.provide(r)
  }
  def getRoleCredentials(
      request: GetRoleCredentialsRequest
  ): ZIO[Sso, AwsError, ReadOnly] =
    ZIO.accessM(_.get.getRoleCredentials(request))
  def listAccountRoles(request: ListAccountRolesRequest): ZStream[
    Sso,
    AwsError,
    io.github.vigoo.zioaws.sso.model.RoleInfo.ReadOnly
  ] = ZStream.accessStream(_.get.listAccountRoles(request))
  def listAccounts(request: ListAccountsRequest): ZStream[
    Sso,
    AwsError,
    io.github.vigoo.zioaws.sso.model.AccountInfo.ReadOnly
  ] = ZStream.accessStream(_.get.listAccounts(request))
  def logout(request: LogoutRequest): ZIO[Sso, AwsError, Unit] =
    ZIO.accessM(_.get.logout(request))
}
