/**
 * MIT License
 *
 * <p>Copyright (c) 2018-2020 atharva washimkar, Vincenzo Palazzo vincenzopalazzo1996@gmail.com
 * Copyright (c) 2021 Vincenzo Palazzo vincenzopalazzodev@gmail.com
 *
 * <p>Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * <p>The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * <p>THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mdlaf.utils;

import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

/**
 * @author https://github.com/vincenzopalazzo
 * @author https://github.com/atarw
 */
public class MaterialColors {

  public static final ColorUIResource RED_50 = new ColorUIResource(255, 235, 238);
  public static final ColorUIResource RED_100 = new ColorUIResource(255, 205, 210);
  public static final ColorUIResource RED_200 = new ColorUIResource(239, 154, 154);
  public static final ColorUIResource RED_300 = new ColorUIResource(229, 115, 115);
  public static final ColorUIResource RED_400 = new ColorUIResource(239, 83, 80);
  public static final ColorUIResource RED_500 = new ColorUIResource(244, 67, 54);
  public static final ColorUIResource RED_600 = new ColorUIResource(229, 57, 53);
  public static final ColorUIResource RED_700 = new ColorUIResource(211, 47, 47);
  public static final ColorUIResource RED_800 = new ColorUIResource(198, 40, 40);
  public static final ColorUIResource RED_900 = new ColorUIResource(183, 28, 28);
  public static final ColorUIResource RED_A100 = new ColorUIResource(255, 138, 128);
  public static final ColorUIResource RED_A200 = new ColorUIResource(255, 82, 82);
  public static final ColorUIResource RED_A400 = new ColorUIResource(255, 23, 68);
  public static final ColorUIResource RED_A700 = new ColorUIResource(213, 0, 0);
  public static final ColorUIResource PINK_50 = new ColorUIResource(252, 228, 236);
  public static final ColorUIResource PINK_100 = new ColorUIResource(248, 187, 208);
  public static final ColorUIResource PINK_200 = new ColorUIResource(244, 143, 177);
  public static final ColorUIResource PINK_300 = new ColorUIResource(240, 98, 146);
  public static final ColorUIResource PINK_400 = new ColorUIResource(236, 64, 122);
  public static final ColorUIResource PINK_500 = new ColorUIResource(233, 30, 99);
  public static final ColorUIResource PINK_600 = new ColorUIResource(216, 27, 96);
  public static final ColorUIResource PINK_700 = new ColorUIResource(194, 24, 91);
  public static final ColorUIResource PINK_800 = new ColorUIResource(173, 20, 87);
  public static final ColorUIResource PINK_900 = new ColorUIResource(136, 14, 79);
  public static final ColorUIResource PINK_A100 = new ColorUIResource(255, 128, 171);
  public static final ColorUIResource PINK_A200 = new ColorUIResource(255, 64, 129);
  public static final ColorUIResource PINK_A400 = new ColorUIResource(245, 0, 87);
  public static final ColorUIResource PINK_A700 = new ColorUIResource(197, 17, 98);
  public static final ColorUIResource PURPLE_50 = new ColorUIResource(243, 229, 245);
  public static final ColorUIResource PURPLE_100 = new ColorUIResource(225, 190, 231);
  public static final ColorUIResource PURPLE_200 = new ColorUIResource(206, 147, 216);
  public static final ColorUIResource PURPLE_300 = new ColorUIResource(186, 104, 200);
  public static final ColorUIResource PURPLE_400 = new ColorUIResource(171, 71, 188);
  public static final ColorUIResource PURPLE_500 = new ColorUIResource(156, 39, 176);
  public static final ColorUIResource PURPLE_600 = new ColorUIResource(142, 36, 170);
  public static final ColorUIResource PURPLE_700 = new ColorUIResource(123, 31, 162);
  public static final ColorUIResource PURPLE_800 = new ColorUIResource(106, 27, 154);
  public static final ColorUIResource PURPLE_900 = new ColorUIResource(74, 20, 140);
  public static final ColorUIResource PURPLE_A100 = new ColorUIResource(234, 128, 252);
  public static final ColorUIResource PURPLE_A200 = new ColorUIResource(224, 64, 251);
  public static final ColorUIResource PURPLE_A400 = new ColorUIResource(213, 0, 249);
  public static final ColorUIResource PURPLE_A700 = new ColorUIResource(170, 0, 255);
  public static final ColorUIResource DEEP_PURPLE_50 = new ColorUIResource(237, 231, 246);
  public static final ColorUIResource DEEP_PURPLE_100 = new ColorUIResource(209, 196, 233);
  public static final ColorUIResource DEEP_PURPLE_200 = new ColorUIResource(179, 157, 219);
  public static final ColorUIResource DEEP_PURPLE_300 = new ColorUIResource(149, 117, 205);
  public static final ColorUIResource DEEP_PURPLE_400 = new ColorUIResource(126, 87, 194);
  public static final ColorUIResource DEEP_PURPLE_500 = new ColorUIResource(103, 58, 183);
  public static final ColorUIResource DEEP_PURPLE_600 = new ColorUIResource(94, 53, 177);
  public static final ColorUIResource DEEP_PURPLE_700 = new ColorUIResource(81, 45, 168);
  public static final ColorUIResource DEEP_PURPLE_800 = new ColorUIResource(69, 39, 160);
  public static final ColorUIResource DEEP_PURPLE_900 = new ColorUIResource(49, 27, 146);
  public static final ColorUIResource DEEP_PURPLE_A100 = new ColorUIResource(179, 136, 255);
  public static final ColorUIResource DEEP_PURPLE_A200 = new ColorUIResource(124, 77, 255);
  public static final ColorUIResource DEEP_PURPLE_A400 = new ColorUIResource(101, 31, 255);
  public static final ColorUIResource DEEP_PURPLE_A700 = new ColorUIResource(98, 0, 234);
  public static final ColorUIResource INDIGO_50 = new ColorUIResource(232, 234, 246);
  public static final ColorUIResource INDIGO_100 = new ColorUIResource(197, 202, 233);
  public static final ColorUIResource INDIGO_200 = new ColorUIResource(159, 168, 218);
  public static final ColorUIResource INDIGO_300 = new ColorUIResource(121, 134, 203);
  public static final ColorUIResource INDIGO_400 = new ColorUIResource(92, 107, 192);
  public static final ColorUIResource INDIGO_500 = new ColorUIResource(63, 81, 181);
  public static final ColorUIResource INDIGO_600 = new ColorUIResource(57, 73, 171);
  public static final ColorUIResource INDIGO_700 = new ColorUIResource(48, 63, 159);
  public static final ColorUIResource INDIGO_800 = new ColorUIResource(40, 53, 147);
  public static final ColorUIResource INDIGO_900 = new ColorUIResource(26, 35, 126);
  public static final ColorUIResource INDIGO_A100 = new ColorUIResource(140, 158, 255);
  public static final ColorUIResource INDIGO_A200 = new ColorUIResource(83, 109, 254);
  public static final ColorUIResource INDIGO_A400 = new ColorUIResource(61, 90, 254);
  public static final ColorUIResource INDIGO_A700 = new ColorUIResource(48, 79, 254);
  public static final ColorUIResource BLUE_50 = new ColorUIResource(227, 242, 253);
  public static final ColorUIResource BLUE_100 = new ColorUIResource(187, 222, 251);
  public static final ColorUIResource BLUE_200 = new ColorUIResource(144, 202, 249);
  public static final ColorUIResource BLUE_300 = new ColorUIResource(100, 181, 246);
  public static final ColorUIResource BLUE_400 = new ColorUIResource(66, 165, 245);
  public static final ColorUIResource BLUE_500 = new ColorUIResource(33, 150, 243);
  public static final ColorUIResource BLUE_600 = new ColorUIResource(30, 136, 229);
  public static final ColorUIResource BLUE_700 = new ColorUIResource(25, 118, 210);
  public static final ColorUIResource BLUE_800 = new ColorUIResource(21, 101, 192);
  public static final ColorUIResource BLUE_900 = new ColorUIResource(13, 71, 161);
  public static final ColorUIResource BLUE_A100 = new ColorUIResource(130, 177, 255);
  public static final ColorUIResource BLUE_A200 = new ColorUIResource(68, 138, 255);
  public static final ColorUIResource BLUE_A400 = new ColorUIResource(41, 121, 255);
  public static final ColorUIResource BLUE_A700 = new ColorUIResource(41, 98, 255);
  public static final ColorUIResource LIGHT_BLUE_50 = new ColorUIResource(225, 245, 254);
  public static final ColorUIResource LIGHT_BLUE_100 = new ColorUIResource(179, 229, 252);
  public static final ColorUIResource LIGHT_BLUE_200 = new ColorUIResource(129, 212, 250);
  public static final ColorUIResource LIGHT_BLUE_300 = new ColorUIResource(79, 195, 247);
  public static final ColorUIResource LIGHT_BLUE_400 = new ColorUIResource(41, 182, 246);
  public static final ColorUIResource LIGHT_BLUE_500 = new ColorUIResource(3, 169, 244);
  public static final ColorUIResource LIGHT_BLUE_600 = new ColorUIResource(3, 155, 229);
  public static final ColorUIResource LIGHT_BLUE_700 = new ColorUIResource(2, 136, 209);
  public static final ColorUIResource LIGHT_BLUE_800 = new ColorUIResource(2, 119, 189);
  public static final ColorUIResource LIGHT_BLUE_900 = new ColorUIResource(1, 87, 155);
  public static final ColorUIResource LIGHT_BLUE_A100 = new ColorUIResource(128, 216, 255);
  public static final ColorUIResource LIGHT_BLUE_A200 = new ColorUIResource(64, 196, 255);
  public static final ColorUIResource LIGHT_BLUE_A400 = new ColorUIResource(0, 176, 255);
  public static final ColorUIResource LIGHT_BLUE_A700 = new ColorUIResource(0, 145, 234);
  public static final ColorUIResource CYAN_50 = new ColorUIResource(224, 247, 250);
  public static final ColorUIResource CYAN_100 = new ColorUIResource(178, 235, 242);
  public static final ColorUIResource CYAN_200 = new ColorUIResource(128, 222, 234);
  public static final ColorUIResource CYAN_300 = new ColorUIResource(77, 208, 225);
  public static final ColorUIResource CYAN_400 = new ColorUIResource(38, 198, 218);
  public static final ColorUIResource CYAN_500 = new ColorUIResource(0, 188, 212);
  public static final ColorUIResource CYAN_600 = new ColorUIResource(0, 172, 193);
  public static final ColorUIResource CYAN_700 = new ColorUIResource(0, 151, 167);
  public static final ColorUIResource CYAN_800 = new ColorUIResource(0, 131, 143);
  public static final ColorUIResource CYAN_900 = new ColorUIResource(0, 96, 100);
  public static final ColorUIResource CYAN_A100 = new ColorUIResource(132, 255, 255);
  public static final ColorUIResource CYAN_A200 = new ColorUIResource(24, 255, 255);
  public static final ColorUIResource CYAN_A400 = new ColorUIResource(0, 229, 255);
  public static final ColorUIResource CYAN_A700 = new ColorUIResource(0, 184, 212);
  public static final ColorUIResource TEAL_50 = new ColorUIResource(224, 242, 241);
  public static final ColorUIResource TEAL_100 = new ColorUIResource(178, 223, 219);
  public static final ColorUIResource TEAL_200 = new ColorUIResource(128, 203, 196);
  public static final ColorUIResource TEAL_300 = new ColorUIResource(77, 182, 172);
  public static final ColorUIResource TEAL_400 = new ColorUIResource(38, 166, 154);
  public static final ColorUIResource TEAL_500 = new ColorUIResource(0, 150, 136);
  public static final ColorUIResource TEAL_600 = new ColorUIResource(0, 137, 123);
  public static final ColorUIResource TEAL_700 = new ColorUIResource(0, 121, 107);
  public static final ColorUIResource TEAL_800 = new ColorUIResource(0, 105, 92);
  public static final ColorUIResource TEAL_900 = new ColorUIResource(0, 77, 64);
  public static final ColorUIResource TEAL_A100 = new ColorUIResource(167, 255, 235);
  public static final ColorUIResource TEAL_A200 = new ColorUIResource(100, 255, 218);
  public static final ColorUIResource TEAL_A400 = new ColorUIResource(29, 233, 182);
  public static final ColorUIResource TEAL_A700 = new ColorUIResource(0, 191, 165);
  public static final ColorUIResource GREEN_50 = new ColorUIResource(232, 245, 233);
  public static final ColorUIResource GREEN_100 = new ColorUIResource(200, 230, 201);
  public static final ColorUIResource GREEN_200 = new ColorUIResource(165, 214, 167);
  public static final ColorUIResource GREEN_300 = new ColorUIResource(129, 199, 132);
  public static final ColorUIResource GREEN_400 = new ColorUIResource(102, 187, 106);
  public static final ColorUIResource GREEN_500 = new ColorUIResource(76, 175, 80);
  public static final ColorUIResource GREEN_600 = new ColorUIResource(67, 160, 71);
  public static final ColorUIResource GREEN_700 = new ColorUIResource(56, 142, 60);
  public static final ColorUIResource GREEN_800 = new ColorUIResource(46, 125, 50);
  public static final ColorUIResource GREEN_900 = new ColorUIResource(27, 94, 32);
  public static final ColorUIResource GREEN_A100 = new ColorUIResource(185, 246, 202);
  public static final ColorUIResource GREEN_A200 = new ColorUIResource(105, 240, 174);
  public static final ColorUIResource GREEN_A400 = new ColorUIResource(0, 230, 118);
  public static final ColorUIResource GREEN_A700 = new ColorUIResource(0, 200, 83);
  public static final ColorUIResource LIGHT_GREEN_50 = new ColorUIResource(241, 248, 233);
  public static final ColorUIResource LIGHT_GREEN_100 = new ColorUIResource(220, 237, 200);
  public static final ColorUIResource LIGHT_GREEN_200 = new ColorUIResource(197, 225, 165);
  public static final ColorUIResource LIGHT_GREEN_300 = new ColorUIResource(174, 213, 129);
  public static final ColorUIResource LIGHT_GREEN_400 = new ColorUIResource(156, 204, 101);
  public static final ColorUIResource LIGHT_GREEN_500 = new ColorUIResource(139, 195, 74);
  public static final ColorUIResource LIGHT_GREEN_600 = new ColorUIResource(124, 179, 66);
  public static final ColorUIResource LIGHT_GREEN_700 = new ColorUIResource(104, 159, 56);
  public static final ColorUIResource LIGHT_GREEN_800 = new ColorUIResource(85, 139, 47);
  public static final ColorUIResource LIGHT_GREEN_900 = new ColorUIResource(51, 105, 30);
  public static final ColorUIResource LIGHT_GREEN_A100 = new ColorUIResource(204, 255, 144);
  public static final ColorUIResource LIGHT_GREEN_A200 = new ColorUIResource(178, 255, 89);
  public static final ColorUIResource LIGHT_GREEN_A400 = new ColorUIResource(118, 255, 3);
  public static final ColorUIResource LIGHT_GREEN_A700 = new ColorUIResource(100, 221, 23);
  public static final ColorUIResource LIME_50 = new ColorUIResource(249, 251, 231);
  public static final ColorUIResource LIME_100 = new ColorUIResource(240, 244, 195);
  public static final ColorUIResource LIME_200 = new ColorUIResource(230, 238, 156);
  public static final ColorUIResource LIME_300 = new ColorUIResource(220, 231, 117);
  public static final ColorUIResource LIME_400 = new ColorUIResource(212, 225, 87);
  public static final ColorUIResource LIME_500 = new ColorUIResource(205, 220, 57);
  public static final ColorUIResource LIME_600 = new ColorUIResource(192, 202, 51);
  public static final ColorUIResource LIME_700 = new ColorUIResource(175, 180, 43);
  public static final ColorUIResource LIME_800 = new ColorUIResource(158, 157, 36);
  public static final ColorUIResource LIME_900 = new ColorUIResource(130, 119, 23);
  public static final ColorUIResource LIME_A100 = new ColorUIResource(244, 255, 129);
  public static final ColorUIResource LIME_A200 = new ColorUIResource(238, 255, 65);
  public static final ColorUIResource LIME_A400 = new ColorUIResource(198, 255, 0);
  public static final ColorUIResource LIME_A700 = new ColorUIResource(174, 234, 0);
  public static final ColorUIResource YELLOW_50 = new ColorUIResource(255, 253, 231);
  public static final ColorUIResource YELLOW_100 = new ColorUIResource(255, 249, 196);
  public static final ColorUIResource YELLOW_200 = new ColorUIResource(255, 245, 157);
  public static final ColorUIResource YELLOW_300 = new ColorUIResource(255, 241, 118);
  public static final ColorUIResource YELLOW_400 = new ColorUIResource(255, 238, 88);
  public static final ColorUIResource YELLOW_500 = new ColorUIResource(255, 235, 59);
  public static final ColorUIResource YELLOW_600 = new ColorUIResource(253, 216, 53);
  public static final ColorUIResource YELLOW_700 = new ColorUIResource(251, 192, 45);
  public static final ColorUIResource YELLOW_800 = new ColorUIResource(249, 168, 37);
  public static final ColorUIResource YELLOW_900 = new ColorUIResource(245, 127, 23);
  public static final ColorUIResource YELLOW_A100 = new ColorUIResource(255, 255, 141);
  public static final ColorUIResource YELLOW_A200 = new ColorUIResource(255, 255, 0);
  public static final ColorUIResource YELLOW_A400 = new ColorUIResource(255, 234, 0);
  public static final ColorUIResource YELLOW_A700 = new ColorUIResource(255, 214, 0);
  public static final ColorUIResource AMBER_50 = new ColorUIResource(255, 248, 225);
  public static final ColorUIResource AMBER_100 = new ColorUIResource(255, 236, 179);
  public static final ColorUIResource AMBER_200 = new ColorUIResource(255, 224, 130);
  public static final ColorUIResource AMBER_300 = new ColorUIResource(255, 213, 79);
  public static final ColorUIResource AMBER_400 = new ColorUIResource(255, 202, 40);
  public static final ColorUIResource AMBER_500 = new ColorUIResource(255, 193, 7);
  public static final ColorUIResource AMBER_600 = new ColorUIResource(255, 179, 0);
  public static final ColorUIResource AMBER_700 = new ColorUIResource(255, 160, 0);
  public static final ColorUIResource AMBER_800 = new ColorUIResource(255, 143, 0);
  public static final ColorUIResource AMBER_900 = new ColorUIResource(255, 111, 0);
  public static final ColorUIResource AMBER_A100 = new ColorUIResource(255, 229, 127);
  public static final ColorUIResource AMBER_A200 = new ColorUIResource(255, 215, 64);
  public static final ColorUIResource AMBER_A400 = new ColorUIResource(255, 196, 0);
  public static final ColorUIResource AMBER_A700 = new ColorUIResource(255, 171, 0);
  public static final ColorUIResource ORANGE_50 = new ColorUIResource(255, 243, 224);
  public static final ColorUIResource ORANGE_100 = new ColorUIResource(255, 224, 178);
  public static final ColorUIResource ORANGE_200 = new ColorUIResource(255, 204, 128);
  public static final ColorUIResource ORANGE_300 = new ColorUIResource(255, 183, 77);
  public static final ColorUIResource ORANGE_400 = new ColorUIResource(255, 167, 38);
  public static final ColorUIResource ORANGE_500 = new ColorUIResource(255, 152, 0);
  public static final ColorUIResource ORANGE_600 = new ColorUIResource(251, 140, 0);
  public static final ColorUIResource ORANGE_700 = new ColorUIResource(245, 124, 0);
  public static final ColorUIResource ORANGE_800 = new ColorUIResource(239, 108, 0);
  public static final ColorUIResource ORANGE_900 = new ColorUIResource(230, 81, 0);
  public static final ColorUIResource ORANGE_A100 = new ColorUIResource(255, 209, 128);
  public static final ColorUIResource ORANGE_A200 = new ColorUIResource(255, 171, 64);
  public static final ColorUIResource ORANGE_A400 = new ColorUIResource(255, 145, 0);
  public static final ColorUIResource ORANGE_A700 = new ColorUIResource(255, 109, 0);
  public static final ColorUIResource DEEP_ORANGE_50 = new ColorUIResource(251, 233, 231);
  public static final ColorUIResource DEEP_ORANGE_100 = new ColorUIResource(255, 204, 188);
  public static final ColorUIResource DEEP_ORANGE_200 = new ColorUIResource(255, 171, 145);
  public static final ColorUIResource DEEP_ORANGE_300 = new ColorUIResource(255, 138, 101);
  public static final ColorUIResource DEEP_ORANGE_400 = new ColorUIResource(255, 112, 67);
  public static final ColorUIResource DEEP_ORANGE_500 = new ColorUIResource(255, 87, 34);
  public static final ColorUIResource DEEP_ORANGE_600 = new ColorUIResource(244, 81, 30);
  public static final ColorUIResource DEEP_ORANGE_700 = new ColorUIResource(230, 74, 25);
  public static final ColorUIResource DEEP_ORANGE_800 = new ColorUIResource(216, 67, 21);
  public static final ColorUIResource DEEP_ORANGE_900 = new ColorUIResource(191, 54, 12);
  public static final ColorUIResource DEEP_ORANGE_A100 = new ColorUIResource(255, 158, 128);
  public static final ColorUIResource DEEP_ORANGE_A200 = new ColorUIResource(255, 110, 64);
  public static final ColorUIResource DEEP_ORANGE_A400 = new ColorUIResource(255, 61, 0);
  public static final ColorUIResource DEEP_ORANGE_A700 = new ColorUIResource(221, 44, 0);
  public static final ColorUIResource BROWN_50 = new ColorUIResource(239, 235, 233);
  public static final ColorUIResource BROWN_100 = new ColorUIResource(215, 204, 200);
  public static final ColorUIResource BROWN_200 = new ColorUIResource(188, 170, 164);
  public static final ColorUIResource BROWN_300 = new ColorUIResource(161, 136, 127);
  public static final ColorUIResource BROWN_400 = new ColorUIResource(141, 110, 99);
  public static final ColorUIResource BROWN_500 = new ColorUIResource(121, 85, 72);
  public static final ColorUIResource BROWN_600 = new ColorUIResource(109, 76, 65);
  public static final ColorUIResource BROWN_700 = new ColorUIResource(93, 64, 55);
  public static final ColorUIResource BROWN_800 = new ColorUIResource(78, 52, 46);
  public static final ColorUIResource BROWN_900 = new ColorUIResource(62, 39, 35);
  public static final ColorUIResource GRAY_50 = new ColorUIResource(250, 250, 250);
  public static final ColorUIResource GRAY_100 = new ColorUIResource(245, 245, 245);
  public static final ColorUIResource GRAY_200 = new ColorUIResource(238, 238, 238);
  public static final ColorUIResource GRAY_300 = new ColorUIResource(224, 224, 224);
  public static final ColorUIResource GRAY_400 = new ColorUIResource(189, 189, 189);
  public static final ColorUIResource GRAY_500 = new ColorUIResource(158, 158, 158);
  public static final ColorUIResource GRAY_600 = new ColorUIResource(117, 117, 117);
  public static final ColorUIResource GRAY_700 = new ColorUIResource(97, 97, 97);
  public static final ColorUIResource GRAY_800 = new ColorUIResource(66, 66, 66);
  public static final ColorUIResource GRAY_900 = new ColorUIResource(33, 33, 33);
  public static final ColorUIResource BLUE_GRAY_50 = new ColorUIResource(236, 239, 241);
  public static final ColorUIResource BLUE_GRAY_100 = new ColorUIResource(207, 216, 220);
  public static final ColorUIResource BLUE_GRAY_200 = new ColorUIResource(176, 190, 197);
  public static final ColorUIResource BLUE_GRAY_300 = new ColorUIResource(144, 164, 174);
  public static final ColorUIResource BLUE_GRAY_400 = new ColorUIResource(120, 144, 156);
  public static final ColorUIResource BLUE_GRAY_500 = new ColorUIResource(96, 125, 139);
  public static final ColorUIResource BLUE_GRAY_600 = new ColorUIResource(84, 110, 122);
  public static final ColorUIResource BLUE_GRAY_700 = new ColorUIResource(69, 90, 100);
  public static final ColorUIResource BLUE_GRAY_800 = new ColorUIResource(55, 71, 79);
  public static final ColorUIResource BLUE_GRAY_900 = new ColorUIResource(38, 50, 56);
  public static final ColorUIResource BLACK = new ColorUIResource(0, 0, 0);
  public static final ColorUIResource WHITE = new ColorUIResource(255, 255, 255);
  public static final ColorUIResource TRANSPANENT = new ColorUIResource(new Color(0, 0, 0, 100));

  // Cosmo ColorUIResource
  public static final ColorUIResource DARKLY_STRONG_BLUE = new ColorUIResource(40, 65, 91);
  public static final ColorUIResource DARKLY_BLUE = new ColorUIResource(55, 90, 127);
  public static final ColorUIResource COSMO_STRONG_BLUE = new ColorUIResource(25, 103, 190);
  public static final ColorUIResource COSMO_BLUE = new ColorUIResource(39, 128, 227);
  public static final ColorUIResource COSMO_LIGTH_BLUE = new ColorUIResource(195, 219, 247);
  public static final ColorUIResource DARKLY_RED = new ColorUIResource(231, 76, 60);
  public static final ColorUIResource COSMO_RED = new ColorUIResource(255, 0, 57);
  public static final ColorUIResource COSMO_LIGHT_RED = new ColorUIResource(255, 184, 200);
  public static final ColorUIResource COSMO_PURPLE = new ColorUIResource(153, 84, 187);
  public static final ColorUIResource COSMO_LIGHT_PURPLE = new ColorUIResource(226, 207, 236);
  public static final ColorUIResource DARKLY_ORANGE = new ColorUIResource(243, 156, 18);
  public static final ColorUIResource COSMO_ORANGE = new ColorUIResource(255, 117, 24);
  public static final ColorUIResource COSMO_LIGHT_ORANGE = new ColorUIResource(255, 216, 190);
  public static final ColorUIResource DARKLY_STRONG_GREEN = new ColorUIResource(0, 112, 83);
  public static final ColorUIResource DARKLY_GREEN = new ColorUIResource(0, 188, 140);
  public static final ColorUIResource COSMO_GREEN = new ColorUIResource(61, 176, 23);
  public static final ColorUIResource COSMO_LIGHT_GREEN = new ColorUIResource(201, 235, 190);
  public static final ColorUIResource COSMO_LIGTH_GRAY = new ColorUIResource(248, 249, 250);
  public static final ColorUIResource COSMO_MEDIUM_GRAY = new ColorUIResource(218, 218, 218);
  public static final ColorUIResource COSMO_STRONG_GRAY = new ColorUIResource(199, 200, 200);
  public static final ColorUIResource COSMO_DARK_GRAY = new ColorUIResource(199, 200, 200);
  public static final ColorUIResource DARKLY_GRAY = new ColorUIResource(173, 181, 189);
  public static final ColorUIResource COSMO_BLACK = new ColorUIResource(55, 58, 60);

  // Other color
  public static final ColorUIResource MYRTLE_GREEN = new ColorUIResource(29, 120, 116);
  public static final ColorUIResource DARK_JUNGLE_GREEN = new ColorUIResource(7, 30, 34);
  public static final ColorUIResource SUNNY = new ColorUIResource(244, 232, 124);

  private MaterialColors() {}

  public static ColorUIResource bleach(Color color, float amount) {
    int red = (int) ((color.getRed() * (1 - amount) / 255 + amount) * 255);
    int green = (int) ((color.getGreen() * (1 - amount) / 255 + amount) * 255);
    int blue = (int) ((color.getBlue() * (1 - amount) / 255 + amount) * 255);
    return new ColorUIResource(red, green, blue);
  }
}
