/**
 * MIT License
 *
 * <p>Copyright (c) 2018-2020 atharva washimkar, Vincenzo Palazzo vincenzopalazzo1996@gmail.com
 * Copyright (c) 2021 Vincenzo Palazzo vincenzopalazzodev@gmail.com
 *
 * <p>Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * <p>The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * <p>THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mdlaf.components.splitpane;

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalSplitPaneUI;

/** @author https://github.com/vincenzopalazzo */
public class MaterialSplitPaneUI extends MetalSplitPaneUI {

  @SuppressWarnings({"MethodOverridesStaticMethodOfSuperclass", "UnusedDeclaration"})
  public static ComponentUI createUI(JComponent c) {
    return new MaterialSplitPaneUI();
  }

  @Override
  public void installUI(JComponent c) {
    super.installUI(c);

    this.divider.setBackground(UIManager.getColor("SplitPaneDivider.background"));
  }

  @Override
  public void uninstallUI(JComponent c) {
    this.divider.setBackground(null);

    super.uninstallUI(c);
  }

  @Override
  public void paint(Graphics g, JComponent jc) {
    super.paint(g, jc);
  }

  @Override
  public BasicSplitPaneDivider createDefaultDivider() {
    return new MaterialSplitPaneDivider(this);
  }

  protected class MaterialSplitPaneDivider extends BasicSplitPaneDivider {

    /**
     * Creates an instance of BasicSplitPaneDivider. Registers this instance for mouse events and
     * mouse dragged events.
     */
    public MaterialSplitPaneDivider(BasicSplitPaneUI ui) {
      super(ui);
    }

    @Override
    public void paintAll(Graphics g) {
      // g.setColor(UIManager.getColor("SplitPaneDivider.background"));
      super.paintAll(g);
    }
  }
}
