/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.button;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import mdlaf.animation.MaterialMouseHover;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialButtonUI
extends BasicButtonUI {
    protected AbstractButton button;
    protected Boolean mouseHoverEnabled;
    protected Color foreground;
    protected Color background;
    protected Color disabledBackground;
    protected Color disabledForeground;
    protected Color defaultBackground;
    protected Color defaultForeground;
    protected Color colorMouseHoverDefaultButton;
    protected Color colorMouseHoverNormalButton;
    protected Color borderColor;
    protected Boolean defaultButton;
    protected Boolean borderEnabled;
    protected int arch = 7;
    protected PropertyChangeListener enableButton = new MaterialListenerButtonEvent();
    protected boolean buttonBorderToAll = false;
    protected boolean mouseHoverRunning = false;
    protected boolean buttonToolBarInit = false;
    protected MaterialMouseHover mouseHover;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        JButton b;
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setOpaque(UIManager.getBoolean("Button.opaque"));
        this.foreground = UIManager.getColor("Button.foreground");
        this.background = UIManager.getColor("Button.background");
        this.disabledBackground = UIManager.getColor("Button.disabledBackground");
        this.disabledForeground = UIManager.getColor("Button.disabledForeground");
        this.defaultBackground = UIManager.getColor("Button[Default].background");
        this.defaultForeground = UIManager.getColor("Button[Default].foreground");
        this.colorMouseHoverNormalButton = UIManager.getColor("Button.mouseHoverColor");
        this.colorMouseHoverDefaultButton = UIManager.getColor("Button[Default].mouseHoverColor");
        this.borderColor = UIManager.getColor("Button[border].color");
        this.borderEnabled = UIManager.getBoolean("Button[border].enable");
        this.buttonBorderToAll = UIManager.getBoolean("Button[border].toAll");
        if (this.mouseHoverEnabled == null) {
            this.mouseHoverEnabled = UIManager.getBoolean("Button.mouseHoverEnable");
        }
        this.arch = UIManager.getInt("Button.arc");
        if (this.mouseHoverEnabled.booleanValue() && !(b = (JButton)button).isDefaultButton()) {
            this.mouseHover = MaterialUIMovement.getMovement(button, this.colorMouseHoverNormalButton);
            button.addMouseListener(this.mouseHover);
        }
        button.setFocusable(UIManager.getBoolean("Button.focusable"));
        this.button = button;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        AbstractButton button = (AbstractButton)c;
        this.foreground = null;
        this.background = null;
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
        this.buttonToolBarInit = false;
        button.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JButton b = (JButton)c;
        if (b.isContentAreaFilled()) {
            this.paintBackground(g, b);
        }
        if (this.defaultButton == null && b.isEnabled()) {
            this.defaultButton = ((JButton)this.button).isDefaultButton();
            if (this.defaultButton.booleanValue()) {
                if (this.mouseHoverEnabled.booleanValue()) {
                    b.removeMouseListener(this.mouseHover);
                    this.mouseHover = MaterialUIMovement.getMovement(b, this.colorMouseHoverDefaultButton);
                    b.addMouseListener(this.mouseHover);
                }
                b.setBackground(this.defaultBackground);
                b.setForeground(this.defaultForeground);
            }
        }
        if (this.borderEnabled != null && this.borderEnabled.booleanValue()) {
            if (this.buttonBorderToAll) {
                this.paintBorderButton(g, b);
            } else if (b.getIcon() == null && !b.isDefaultButton()) {
                this.paintBorderButton(g, b);
            }
        }
        super.paint(g, c);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isEnabled()) {
            MaterialDrawingUtils.drawString(c, g, text, textRect, b.getDisplayedMnemonicIndex(), this.getTextShiftOffset(), b.getForeground());
            return;
        }
        MaterialDrawingUtils.drawString(c, g, text, textRect, b.getDisplayedMnemonicIndex(), this.getTextShiftOffset(), this.disabledForeground);
    }

    protected void paintBackground(Graphics g, JComponent c) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        Graphics2D graphics = (Graphics2D)g.create();
        if (c.isEnabled()) {
            if (this.defaultButton != null && this.defaultButton.booleanValue()) {
                graphics.setColor(this.defaultBackground);
            } else {
                graphics.setColor(c.getBackground());
            }
        } else {
            graphics.setColor(this.disabledBackground);
        }
        graphics.fillRoundRect(0, 0, c.getWidth(), c.getHeight(), this.arch, this.arch);
        graphics.dispose();
        if (!this.buttonToolBarInit && this.isToolBarButton(c)) {
            this.borderEnabled = false;
            this.mouseHoverEnabled = UIManager.getBoolean("ToolBar[button].mouseHover");
            c.removeMouseListener(this.mouseHover);
            c.setBackground(UIManager.getColor("ToolBar.background"));
            if (this.mouseHoverEnabled.booleanValue()) {
                this.mouseHover = MaterialUIMovement.getMovement(c, this.colorMouseHoverNormalButton);
                c.addMouseListener(this.mouseHover);
            }
            this.buttonToolBarInit = true;
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!this.button.isEnabled()) {
            return;
        }
        this.paintFocusRing(g, (JButton)b);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (this.mouseHoverEnabled.booleanValue() && b.getModel().isPressed()) {
            if (b.isEnabled()) {
                if (this.isDefaultButton().booleanValue()) {
                    g.setColor(this.colorMouseHoverDefaultButton);
                } else {
                    g.setColor(this.colorMouseHoverNormalButton);
                }
            } else {
                g.setColor(this.disabledBackground);
            }
        } else {
            g.setColor(this.background);
        }
        g.fillRoundRect(0, 0, b.getWidth(), b.getHeight(), this.arch, this.arch);
        this.paintBorderButton(g, b);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        b.addPropertyChangeListener(this.enableButton);
        return super.createButtonListener(b);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener(this.enableButton);
        super.uninstallListeners(b);
        b.removeMouseListener(this.mouseHover);
    }

    protected void paintFocusRing(Graphics g, JButton b) {
        BasicStroke dashed = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{0.0f, 3.0f}, 10.0f);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(dashed);
        if (this.defaultButton != null && this.defaultButton.booleanValue()) {
            g2.setColor(UIManager.getColor("Button[Default][focus].color"));
        } else {
            g2.setColor(UIManager.getColor("Button[focus].color"));
        }
        g2.drawRoundRect(5, 5, b.getWidth() - 10, b.getHeight() - 10, this.arch, this.arch);
        g2.dispose();
    }

    protected void paintBorderButton(Graphics graphics, JComponent b) {
        if (!b.isEnabled() || !this.borderEnabled.booleanValue()) {
            return;
        }
        if (!this.buttonBorderToAll && ((JButton)b).getIcon() != null) {
            return;
        }
        if (this.isDefaultButton().booleanValue() && !this.buttonBorderToAll) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = b.getWidth() - 1;
        int h = b.getHeight() - 1;
        graphics2D.setColor(this.borderColor);
        graphics2D.drawRoundRect(0, 0, w, h, this.arch + 2, this.arch + 2);
        graphics2D.dispose();
    }

    public void setColorMouseHoverDefaultButton(Color colorMouseHoverDefaultButton) {
        this.colorMouseHoverDefaultButton = colorMouseHoverDefaultButton;
    }

    public void setColorMouseHoverNormalButton(Color colorMouseHoverNormalButton) {
        this.colorMouseHoverNormalButton = colorMouseHoverNormalButton;
    }

    public Boolean isDefaultButton() {
        return this.defaultButton != null && this.defaultButton != false;
    }

    protected boolean isToolBarButton(Component component) {
        Container container = component.getParent();
        if (container instanceof JToolBar) {
            return true;
        }
        if (container != null) {
            return this.isToolBarButton(container);
        }
        return false;
    }

    protected class MaterialListenerButtonEvent
    implements PropertyChangeListener {
        private static final String BACKGROUND_EVENT = "background";
        private static final String FOREGROUND_EVENT = "foreground";
        private static final String ENABLED_EVENT = "enabled";

        protected MaterialListenerButtonEvent() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                throw new IllegalArgumentException("The event null");
            }
            if (evt.getPropertyName().equals(ENABLED_EVENT) && ((Boolean)evt.getNewValue()).booleanValue()) {
                if (MaterialButtonUI.this.defaultButton != null && MaterialButtonUI.this.defaultButton.booleanValue()) {
                    MaterialButtonUI.this.button.setBackground(MaterialButtonUI.this.defaultBackground);
                    MaterialButtonUI.this.button.setForeground(MaterialButtonUI.this.defaultForeground);
                } else {
                    MaterialButtonUI.this.button.setBackground(MaterialButtonUI.this.background);
                    MaterialButtonUI.this.button.setForeground(MaterialButtonUI.this.foreground);
                }
            } else if (evt.getPropertyName().equals(BACKGROUND_EVENT) && MaterialButtonUI.this.button.isEnabled()) {
                if (MaterialButtonUI.this.defaultButton != null && MaterialButtonUI.this.defaultButton.booleanValue()) {
                    MaterialButtonUI.this.defaultBackground = (Color)evt.getNewValue();
                } else if (MaterialButtonUI.this.mouseHover != null && !MaterialButtonUI.this.mouseHover.isRunning()) {
                    MaterialButtonUI.this.background = (Color)evt.getNewValue();
                }
            } else if (evt.getPropertyName().equals(FOREGROUND_EVENT) && MaterialButtonUI.this.button.isEnabled()) {
                if (MaterialButtonUI.this.defaultButton != null && MaterialButtonUI.this.defaultButton.booleanValue()) {
                    MaterialButtonUI.this.defaultForeground = (Color)evt.getNewValue();
                } else if (MaterialButtonUI.this.mouseHover != null && !MaterialButtonUI.this.mouseHover.isRunning()) {
                    MaterialButtonUI.this.foreground = (Color)evt.getNewValue();
                }
            }
        }
    }
}

