/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.rootpane;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import mdlaf.components.titlepane.MaterialTitlePaneUI;

@Deprecated
public class MaterialRootPaneUI
extends BasicRootPaneUI {
    protected static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    protected Cursor myLastCursor = Cursor.getPredefinedCursor(0);
    protected Window window;
    protected JComponent titlePane;
    protected MaterialHandler materialHandler;
    protected LayoutManager layoutManager;
    protected LayoutManager savedOldLayout;
    protected JRootPane root;
    private boolean dragging = false;
    private boolean resizing = false;
    protected Dimension dimensionDevices;
    protected Dimension parentBounds;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialRootPaneUI();
    }

    public MaterialRootPaneUI() {
        GraphicsDevice[] graphicDevices;
        int deviceWidth = 0;
        int deviceHeight = 0;
        for (GraphicsDevice graphicsDevice : graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            deviceWidth += graphicsDevice.getDisplayMode().getWidth();
            deviceHeight += graphicsDevice.getDisplayMode().getHeight();
        }
        this.parentBounds = this.dimensionDevices = new Dimension(deviceWidth, deviceHeight);
    }

    private void cancelResize(Window w) {
        if (this.resizing && this.materialHandler != null) {
            this.materialHandler.finishMouseReleased(w);
        }
    }

    protected void setupDragMode(Window f) {
    }

    public void beginDraggingFrame(Window f) {
        this.setupDragMode(f);
    }

    public void dragFrame(Window w, int newX, int newY) {
        this.setBoundsForFrame(w, newX, newY, w.getWidth(), w.getHeight());
    }

    public void endDraggingFrame(Window f) {
    }

    public void beginResizingFrame(Window f, int direction) {
        this.setupDragMode(f);
    }

    public void resizeFrame(Window f, int newX, int newY, int newWidth, int newHeight) {
        this.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
    }

    public void endResizingFrame(Window f) {
    }

    public void setBoundsForFrame(Window f, int newX, int newY, int newWidth, int newHeight) {
        f.setBounds(newX, newY, newWidth, newHeight);
        f.revalidate();
    }

    @Override
    protected void installListeners(JRootPane root) {
        super.installListeners(root);
    }

    @Override
    protected void uninstallListeners(JRootPane root) {
        super.uninstallListeners(root);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        this.root.setBackground(UIManager.getColor("RootPane.background"));
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.materialHandler = null;
        this.root = null;
    }

    protected void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    protected void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.materialHandler == null) {
                this.materialHandler = this.createWindowHandler(root);
            }
            this.window.addMouseListener(this.materialHandler);
            this.window.addMouseMotionListener(this.materialHandler);
            this.window.addWindowFocusListener(this.materialHandler);
            this.window.addWindowListener(this.materialHandler);
        }
    }

    protected void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.materialHandler);
            this.window.removeMouseMotionListener(this.materialHandler);
            this.window.removeWindowFocusListener(this.materialHandler);
            this.window.removeWindowListener(this.materialHandler);
        }
    }

    protected void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    protected void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    protected void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    protected void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    protected JComponent createTitlePane(JRootPane root) {
        return new MaterialTitlePaneUI(root);
    }

    protected MaterialHandler createWindowHandler(JRootPane root) {
        return new MaterialHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new MaterialLayout();
    }

    protected void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    protected JComponent getTitlePane() {
        return this.titlePane;
    }

    protected JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    public void setMaximized() {
        Container tla = this.root.getTopLevelAncestor();
        GraphicsConfiguration gc = tla.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        screenBounds.x = 0;
        screenBounds.y = 0;
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
        if (tla instanceof JFrame) {
            ((JFrame)tla).setMaximizedBounds(maxBounds);
        }
    }

    protected void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, borderKeys[style]);
        }
    }

    protected class MaterialHandler
    implements MouseInputListener,
    WindowListener,
    WindowFocusListener,
    SwingConstants {
        int absoluteX;
        int absoluteY;
        int windowNowX;
        int windowNowY;
        Rectangle startingBounds;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        private boolean discardRelease = false;
        int resizeCornerSize = 5;

        protected MaterialHandler() {
        }

        void updateFrameCursor(Window w) {
            if (MaterialRootPaneUI.this.resizing) {
                return;
            }
            Cursor s = MaterialRootPaneUI.this.myLastCursor;
            if (s == null) {
                s = Cursor.getPredefinedCursor(0);
            }
            w.setCursor(s);
        }

        void finishMouseReleased(Window w) {
            if (this.discardRelease) {
                this.discardRelease = false;
                return;
            }
            if (this.resizeDir == 0) {
                MaterialRootPaneUI.this.endDraggingFrame(w);
                MaterialRootPaneUI.this.dragging = false;
            } else {
                MaterialRootPaneUI.this.endResizingFrame(w);
                MaterialRootPaneUI.this.resizing = false;
                this.updateFrameCursor(w);
            }
            this.absoluteX = 0;
            this.absoluteY = 0;
            this.windowNowX = 0;
            this.windowNowY = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
            this.discardRelease = true;
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.windowNowX = ev.getX();
            this.windowNowY = ev.getY();
            Point mouseCurent = MouseInfo.getPointerInfo().getLocation();
            this.absoluteX = mouseCurent.x;
            this.absoluteY = mouseCurent.y;
            this.resizeDir = 0;
            this.discardRelease = false;
            JRootPane rootPane = MaterialRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            this.startingBounds = w.getBounds();
            Insets i = w.getInsets();
            Point ep = new Point(this.windowNowX, this.windowNowY);
            boolean resizable = false;
            boolean maximized = false;
            if (w instanceof Frame) {
                Frame f = (Frame)w;
                resizable = f.isResizable();
                maximized = (f.getExtendedState() & 6) == 0;
            } else if (w instanceof Dialog) {
                Dialog d = (Dialog)w;
                resizable = d.isResizable();
            }
            if (MaterialRootPaneUI.this.getTitlePane().getBounds().contains(ev.getPoint()) && ev.getX() > i.left + this.resizeCornerSize && ev.getX() < w.getWidth() - i.right - this.resizeCornerSize && ev.getY() > i.top + this.resizeCornerSize) {
                MaterialRootPaneUI.this.beginDraggingFrame(w);
                MaterialRootPaneUI.this.dragging = true;
                return;
            }
            if (!resizable || maximized) {
                return;
            }
            if (ep.x <= i.left + this.resizeCornerSize) {
                this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 8 : (ep.y > w.getHeight() - this.resizeCornerSize - i.bottom ? 6 : 7);
            } else if (ep.x >= w.getWidth() - i.right - this.resizeCornerSize) {
                this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 2 : (ep.y > w.getHeight() - this.resizeCornerSize - i.bottom ? 4 : 3);
            } else if (ep.y <= i.top + this.resizeCornerSize) {
                this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 8 : (ep.x > w.getWidth() - this.resizeCornerSize - i.right ? 2 : 1);
            } else if (ep.y >= w.getHeight() - i.bottom - this.resizeCornerSize) {
                this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 6 : (ep.x > w.getWidth() - this.resizeCornerSize - i.right ? 4 : 5);
            } else {
                this.discardRelease = true;
                return;
            }
            Cursor s = Cursor.getPredefinedCursor(0);
            switch (this.resizeDir) {
                case 5: {
                    s = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 1: {
                    s = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 7: {
                    s = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 3: {
                    s = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 4: {
                    s = Cursor.getPredefinedCursor(5);
                    break;
                }
                case 6: {
                    s = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 8: {
                    s = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 2: {
                    s = Cursor.getPredefinedCursor(7);
                }
            }
            MaterialRootPaneUI.this.beginResizingFrame(w, this.resizeDir);
            w.setCursor(s);
            MaterialRootPaneUI.this.resizing = true;
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            this.finishMouseReleased(w);
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            JRootPane root = MaterialRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = (Window)ev.getSource();
            boolean undecorated = false;
            boolean resizable = false;
            boolean maximized = false;
            if (w instanceof Frame) {
                Frame f = (Frame)w;
                undecorated = f.isUndecorated();
                resizable = f.isResizable();
                maximized = (f.getExtendedState() & 6) == 0;
            } else if (w instanceof Dialog) {
                Dialog d = (Dialog)w;
                undecorated = d.isUndecorated();
                resizable = d.isResizable();
            }
            Insets i = w.getInsets();
            Point ep = new Point(ev.getX(), ev.getY());
            if (resizable && !maximized) {
                if (ep.x <= i.left + this.resizeCornerSize) {
                    if (ep.y < this.resizeCornerSize + i.top) {
                        w.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (ep.y > w.getHeight() - this.resizeCornerSize - i.bottom) {
                        w.setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        w.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (ep.x >= w.getWidth() - i.right - this.resizeCornerSize) {
                    if (ev.getY() < this.resizeCornerSize + i.top) {
                        w.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (ep.y > w.getHeight() - this.resizeCornerSize - i.bottom) {
                        w.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        w.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (ep.y <= i.top + this.resizeCornerSize) {
                    if (ep.x < this.resizeCornerSize + i.left) {
                        w.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (ep.x > w.getWidth() - this.resizeCornerSize - i.right) {
                        w.setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        w.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (ep.y >= w.getHeight() - i.bottom - this.resizeCornerSize) {
                    if (ep.x < this.resizeCornerSize + i.left) {
                        w.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (ep.x > w.getWidth() - this.resizeCornerSize - i.right) {
                        w.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        w.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    this.updateFrameCursor(w);
                }
            } else {
                this.updateFrameCursor(w);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startingBounds == null) {
                return;
            }
            Window window = (Window)e.getSource();
            Point mouseCurent = MouseInfo.getPointerInfo().getLocation();
            int deltaX = this.absoluteX - mouseCurent.x;
            int deltaY = this.absoluteY - mouseCurent.y;
            Dimension min = window.getMinimumSize();
            Dimension max = window.getMaximumSize();
            Insets windows = window.getInsets();
            boolean resizable = false;
            boolean maximized = false;
            if (window instanceof Frame) {
                Frame f = (Frame)window;
                resizable = f.isResizable();
                maximized = (f.getExtendedState() & 6) == 0;
            } else if (window instanceof Dialog) {
                Dialog d = (Dialog)window;
                resizable = d.isResizable();
            }
            if (MaterialRootPaneUI.this.dragging) {
                if (maximized || (e.getModifiers() & 0x10) != 16) {
                    return;
                }
                int parentWidth = MaterialRootPaneUI.this.dimensionDevices.width;
                int parentHeight = MaterialRootPaneUI.this.dimensionDevices.height;
                int newX = this.startingBounds.x - deltaX;
                int newY = this.startingBounds.y - deltaY;
                if (newX + windows.left <= -this.windowNowX) {
                    newX = -this.windowNowX - windows.left + 1;
                } else if (newY + windows.top <= -this.windowNowY) {
                    newY = -this.windowNowY - windows.top + 1;
                } else if (newX + this.windowNowX + windows.right >= parentWidth) {
                    newX = parentWidth - this.windowNowX - windows.right - 1;
                } else if (newY + this.windowNowY + windows.bottom >= parentHeight) {
                    newY = parentHeight - this.windowNowY - windows.bottom - 1;
                }
                MaterialRootPaneUI.this.dragFrame(window, newX, newY);
                return;
            }
            if (!resizable) {
                return;
            }
            int newX = window.getX();
            int newY = window.getY();
            int newW = window.getWidth();
            int newH = window.getHeight();
            switch (this.resizeDir) {
                case 1: {
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y - deltaY;
                    newW = this.startingBounds.width;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                case 2: {
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > MaterialRootPaneUI.this.parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - MaterialRootPaneUI.this.parentBounds.width;
                    }
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y - deltaY;
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                case 3: {
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > MaterialRootPaneUI.this.parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - MaterialRootPaneUI.this.parentBounds.width;
                    }
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height;
                    break;
                }
                case 4: {
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > MaterialRootPaneUI.this.parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - MaterialRootPaneUI.this.parentBounds.width;
                    }
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > MaterialRootPaneUI.this.parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - MaterialRootPaneUI.this.parentBounds.height;
                    }
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 5: {
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > MaterialRootPaneUI.this.parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - MaterialRootPaneUI.this.parentBounds.height;
                    }
                    newW = this.startingBounds.width;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 6: {
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > MaterialRootPaneUI.this.parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - MaterialRootPaneUI.this.parentBounds.height;
                    }
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y;
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 7: {
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y;
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height;
                    break;
                }
                case 8: {
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y - deltaY;
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                default: {
                    return;
                }
            }
            MaterialRootPaneUI.this.resizeFrame(window, newX, newY, newW, newH);
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            this.updateFrameCursor(w);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            this.updateFrameCursor(w);
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            if (!(w instanceof Frame)) {
                return;
            }
            Frame f = (Frame)w;
            JComponent windowTitlePane = MaterialRootPaneUI.this.getTitlePane();
            if (windowTitlePane == null) {
                return;
            }
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), windowTitlePane);
            int state = f.getExtendedState();
            if (windowTitlePane.contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    MaterialRootPaneUI.this.setMaximized();
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    MaterialRootPaneUI.this.setMaximized();
                    f.setExtendedState(state | 6);
                }
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            MaterialRootPaneUI.this.cancelResize(e.getWindow());
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            MaterialRootPaneUI.this.cancelResize(e.getWindow());
        }
    }

    protected static class MaterialLayout
    implements LayoutManager2 {
        protected MaterialLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MaterialRootPaneUI && (titlePane = ((MaterialRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MaterialRootPaneUI && (titlePane = ((MaterialRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MaterialRootPaneUI && (titlePane = ((MaterialRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MaterialRootPaneUI && (titlePane = ((MaterialRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

