/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.textfield;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public abstract class MaterialComponentField
extends BasicTextFieldUI {
    protected static final String PROPERTY_LINE_COLOR = "lineColor";
    protected static final String PROPERTY_SELECTION_COLOR = "selectionColor";
    protected static final String PROPERTY_SELECTION_TEXT_COLOR = "selectedTextColor";
    protected static final String PROPERTY_ENABLED_COMPONENT = "enabled";
    protected boolean drawLine;
    protected boolean focused;
    protected JTextComponent textComponent;
    protected Color background;
    protected Color foreground;
    protected Color activeBackground;
    protected Color activeForeground;
    protected Color inactiveBackground;
    protected Color inactiveForeground;
    protected Color disabledBackground;
    protected Color disabledForeground;
    protected Color colorLineInactive;
    protected Color colorLineActive;
    protected Color colorLine;
    protected FocusListener focusListenerColorLine;
    protected PropertyChangeListener propertyChangeListener;
    protected PropertyChangeSupport propertyChangeSupport;

    public MaterialComponentField() {
        this(true);
    }

    public MaterialComponentField(boolean drawLine) {
        this.drawLine = drawLine;
        this.focusListenerColorLine = new FocusListenerColorLine();
        this.propertyChangeListener = new MaterialPropertyChangeListener();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    protected void logicForChangeColorOnFocus(JComponent component, Color background, Color foreground) {
        if (background == null || foreground == null) {
            return;
        }
        JTextField componentText = (JTextField)component;
        componentText.setSelectedTextColor(foreground);
        componentText.setSelectionColor(background);
    }

    protected void installMyDefaults(JComponent component) {
        this.textComponent = (JTextComponent)component;
        this.background = UIManager.getColor(this.getPropertyPrefix() + ".background");
        this.foreground = UIManager.getColor(this.getPropertyPrefix() + ".foreground");
        this.activeBackground = UIManager.getColor(this.getPropertyPrefix() + ".selectionBackground");
        this.activeForeground = UIManager.getColor(this.getPropertyPrefix() + ".selectionForeground");
        this.inactiveBackground = UIManager.getColor(this.getPropertyPrefix() + ".inactiveBackground");
        this.inactiveForeground = UIManager.getColor(this.getPropertyPrefix() + ".inactiveForeground");
        this.disabledBackground = UIManager.getColor(this.getPropertyPrefix() + ".disabledBackground");
        this.disabledForeground = UIManager.getColor(this.getPropertyPrefix() + ".disabledForeground");
        this.textComponent.setDisabledTextColor(this.disabledForeground);
        this.colorLineInactive = UIManager.getColor(this.getPropertyPrefix() + "[Line].inactiveColor");
        this.colorLineActive = UIManager.getColor(this.getPropertyPrefix() + "[Line].activeColor");
        this.textComponent.setFont(UIManager.getFont(this.getPropertyPrefix() + ".font"));
        this.colorLine = this.getComponent().hasFocus() && this.getComponent().isEditable() ? this.colorLineActive : this.colorLineInactive;
        this.textComponent.setSelectionColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeBackground : this.inactiveBackground);
        this.textComponent.setSelectedTextColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.textComponent.setForeground(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.textComponent.setBorder(UIManager.getBorder(this.getPropertyPrefix() + ".border"));
    }

    protected void logicForPropertyChange(Color newColor, boolean isForeground) {
        if (newColor == null) {
            return;
        }
        if (isForeground) {
            if (!newColor.equals(this.activeForeground)) {
                this.inactiveForeground = newColor;
            } else {
                this.activeForeground = newColor;
            }
            this.getComponent().repaint();
        }
        if (!isForeground) {
            if (!newColor.equals(this.activeBackground)) {
                this.inactiveBackground = newColor;
            } else {
                this.activeBackground = newColor;
            }
            this.getComponent().repaint();
        }
    }

    protected void changeColorOnFocus(Graphics g) {
        boolean hasFocus = this.focused;
        JTextComponent c = this.getComponent();
        if (c == null) {
            return;
        }
        if (hasFocus && this.activeBackground != null && this.activeForeground != null) {
            this.logicForChangeColorOnFocus(c, this.activeBackground, this.activeForeground);
            this.paintLine(g);
        }
        if (!hasFocus && this.inactiveBackground != null && this.inactiveForeground != null) {
            this.logicForChangeColorOnFocus(c, this.inactiveBackground, this.inactiveForeground);
            this.paintLine(g);
        }
    }

    protected synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null || propertyName.isEmpty() || oldValue == null || newValue == null) {
            throw new IllegalArgumentException("Some property null");
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void paintLine(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        JTextComponent c = this.getComponent();
        if (this.drawLine) {
            int x = c.getInsets().left;
            int y = c.getInsets().top;
            int w = c.getWidth() - c.getInsets().left - c.getInsets().right;
            if (this.textComponent.isEnabled()) {
                graphics.setColor(this.colorLine);
            } else {
                graphics.setColor(this.disabledBackground);
            }
            graphics.fillRect(x, c.getHeight() - y, w, 1);
        }
    }

    protected class MaterialPropertyChangeListener
    implements PropertyChangeListener {
        protected MaterialPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (MaterialComponentField.this.getComponent() == null) {
                return;
            }
            if (pce.getPropertyName().equals(MaterialComponentField.PROPERTY_SELECTION_COLOR)) {
                Color newColor = (Color)pce.getNewValue();
                MaterialComponentField.this.logicForPropertyChange(newColor, false);
            } else if (pce.getPropertyName().equals(MaterialComponentField.PROPERTY_SELECTION_TEXT_COLOR)) {
                Color newColor = (Color)pce.getNewValue();
                MaterialComponentField.this.logicForPropertyChange(newColor, true);
            } else if (pce.getPropertyName().equals(MaterialComponentField.PROPERTY_LINE_COLOR)) {
                Color newColor;
                MaterialComponentField.this.colorLine = newColor = (Color)pce.getNewValue();
                MaterialComponentField.this.getComponent().repaint();
            } else if (pce.getPropertyName().equals("background")) {
                MaterialComponentField.this.getComponent().repaint();
            } else if (pce.getPropertyName().equals(MaterialComponentField.PROPERTY_ENABLED_COMPONENT)) {
                boolean newValue = (Boolean)pce.getNewValue();
                if (!newValue) {
                    MaterialComponentField.this.getComponent().setSelectionStart(0);
                    MaterialComponentField.this.getComponent().setSelectionEnd(0);
                }
                MaterialComponentField.this.getComponent().repaint();
            }
        }
    }

    protected class FocusListenerColorLine
    implements FocusListener {
        protected FocusListenerColorLine() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MaterialComponentField.this.firePropertyChange(MaterialComponentField.PROPERTY_LINE_COLOR, MaterialComponentField.this.colorLineInactive, MaterialComponentField.this.colorLineActive);
            MaterialComponentField.this.firePropertyChange(MaterialComponentField.PROPERTY_SELECTION_COLOR, MaterialComponentField.this.inactiveBackground, MaterialComponentField.this.activeBackground);
            MaterialComponentField.this.firePropertyChange(MaterialComponentField.PROPERTY_SELECTION_TEXT_COLOR, MaterialComponentField.this.inactiveForeground, MaterialComponentField.this.activeForeground);
            MaterialComponentField.this.focused = true;
        }

        @Override
        public void focusLost(FocusEvent e) {
            MaterialComponentField.this.firePropertyChange(MaterialComponentField.PROPERTY_LINE_COLOR, MaterialComponentField.this.colorLineActive, MaterialComponentField.this.colorLineInactive);
            MaterialComponentField.this.firePropertyChange(MaterialComponentField.PROPERTY_SELECTION_COLOR, MaterialComponentField.this.activeBackground, MaterialComponentField.this.inactiveBackground);
            MaterialComponentField.this.firePropertyChange(MaterialComponentField.PROPERTY_SELECTION_TEXT_COLOR, MaterialComponentField.this.activeForeground, MaterialComponentField.this.inactiveForeground);
            MaterialComponentField.this.focused = false;
        }
    }
}

