/*
 * Decompiled with CFR 0.152.
 */
package io.github.vipcxj.beanknife.runtime;

import io.github.vipcxj.beanknife.runtime.providers.DefaultBeanProvider;
import io.github.vipcxj.beanknife.runtime.spi.BeanProvider;
import io.github.vipcxj.beanknife.runtime.utils.BeanUsage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public enum BeanProviders {
    INSTANCE;

    private final List<BeanProvider> providers = new ArrayList<BeanProvider>();
    private final Map<String, WeakReference<?>> cacheMap;

    private BeanProviders() {
        ServiceLoader<BeanProvider> loader = ServiceLoader.load(BeanProvider.class);
        for (BeanProvider provider : loader) {
            this.providers.add(provider);
        }
        this.providers.sort(Comparator.comparing(BeanProvider::getPriority).reversed());
        this.cacheMap = new ConcurrentHashMap();
    }

    public <T> T get(Class<T> type, BeanUsage usage, Object requester, boolean useDefaultBeanProvider, boolean cache) {
        Object inst;
        WeakReference<?> reference;
        String key = null;
        if (cache && (reference = this.cacheMap.get(key = type.getName() + "_" + usage.name())) != null && (inst = reference.get()) != null) {
            return inst;
        }
        Object instance = null;
        ArrayList<Throwable> suppressed = new ArrayList<Throwable>();
        Throwable throwable = null;
        for (BeanProvider provider : this.providers) {
            if (!this.support(provider, type, usage, useDefaultBeanProvider)) continue;
            try {
                instance = provider.get(type, usage, requester);
            }
            catch (Throwable t) {
                if (throwable != null) {
                    suppressed.add(throwable);
                }
                throwable = t;
            }
            if (instance == null) continue;
            break;
        }
        if (instance == null) {
            RuntimeException e = new RuntimeException("Unable to initialize the class: " + type.getName() + " for " + (Object)((Object)usage) + " usage.");
            for (Throwable t : suppressed) {
                e.addSuppressed(t);
            }
            throw e;
        }
        if (cache) {
            this.cacheMap.put(key, new WeakReference<Object>(instance));
        }
        return instance;
    }

    private <T> boolean support(BeanProvider provider, Class<T> type, BeanUsage usage, boolean useDefaultBeanProvider) {
        try {
            if (provider instanceof DefaultBeanProvider && !useDefaultBeanProvider) {
                return false;
            }
            return provider.support(type, usage);
        }
        catch (Throwable t) {
            return false;
        }
    }
}

