/*
 * Decompiled with CFR 0.152.
 */
package io.github.vipcxj.jasync.reactive;

import io.github.vipcxj.jasync.ng.runtime.utils.UnPaddedLockFreeArrayQueue0;
import io.github.vipcxj.jasync.reactive.PromiseContext;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class JAsyncSubscriber<T>
implements Subscriber<T> {
    private final long initRequest;
    private final Queue<T> cache;
    private final Queue<PromiseContext<T>> contexts;
    private Throwable error;
    private volatile long remain;
    private static final AtomicLongFieldUpdater<JAsyncSubscriber> REMAIN = AtomicLongFieldUpdater.newUpdater(JAsyncSubscriber.class, "remain");
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<JAsyncSubscriber> STATE = AtomicIntegerFieldUpdater.newUpdater(JAsyncSubscriber.class, "state");
    private static final int ST_READY = 0;
    private static final int ST_CANCEL = 1;
    private static final int ST_COMPLETED = 2;
    private static final int ST_ERROR = 3;
    private Subscription subscription;
    private volatile Publisher<T> publisher;
    private static final AtomicReferenceFieldUpdater<JAsyncSubscriber, Publisher> PUBLISHER = AtomicReferenceFieldUpdater.newUpdater(JAsyncSubscriber.class, Publisher.class, "publisher");

    public JAsyncSubscriber(long initRequest) {
        this.initRequest = initRequest;
        this.cache = new UnPaddedLockFreeArrayQueue0(2);
        this.contexts = new UnPaddedLockFreeArrayQueue0(2);
        this.remain = initRequest;
        this.state = 0;
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.subscription.request(this.initRequest);
    }

    public void onNext(T t) {
        T v;
        PromiseContext<T> context = this.contexts.poll();
        if (context != null) {
            this.consume(context, t);
            return;
        }
        this.cache.offer(t);
        context = this.contexts.poll();
        if (context != null && (v = this.cache.poll()) != null) {
            this.consume(context, v);
        }
    }

    public void onError(Throwable t) {
        if (STATE.compareAndSet(this, 0, 3)) {
            PromiseContext<T> context;
            this.error = t;
            while ((context = this.contexts.poll()) != null) {
                context.getThunk().reject(t, context.getContext());
            }
        }
    }

    public void onComplete() {
        if (STATE.compareAndSet(this, 0, 2)) {
            PromiseContext<T> context;
            while ((context = this.contexts.poll()) != null) {
                context.getThunk().resolve(null, context.getContext());
            }
        }
    }

    public void addPromiseContext(PromiseContext<T> context) {
        T v = this.cache.poll();
        if (v != null) {
            this.consume(context, v);
            return;
        }
        this.contexts.offer(context);
        v = this.cache.poll();
        if (v != null) {
            PromiseContext<T> ctx = this.contexts.poll();
            if (ctx != null) {
                this.consume(ctx, v);
            }
        } else if (this.state == 2) {
            context.getThunk().resolve(null, context.getContext());
        } else if (this.state == 3) {
            context.getThunk().reject(this.error, context.getContext());
        }
    }

    public void cancel() {
        this.state = 1;
        this.subscription.cancel();
    }

    private void consume(PromiseContext<T> context, T value) {
        long remain;
        do {
            if ((remain = this.remain) >= 1L) continue;
            throw new IllegalStateException("This is impossible.");
        } while (!REMAIN.weakCompareAndSet(this, remain, remain - 1L));
        context.getThunk().resolve(value, context.getContext());
        if (remain == 1L) {
            this.remain = context.getNextRequest();
            this.subscription.request(this.remain);
        }
    }

    public void subscribe(Publisher<T> publisher) {
        if (!PUBLISHER.compareAndSet(this, null, publisher) && this.publisher != publisher) {
            throw new IllegalStateException("The subscriber has been subscribed by publisher " + this.publisher + ".");
        }
    }
}

