/*
 * Decompiled with CFR 0.152.
 */
package io.github.vipcxj.jasync.reactive;

import io.github.vipcxj.jasync.ng.spec.JPromise;
import io.github.vipcxj.jasync.reactive.JAsyncSubscriber;
import io.github.vipcxj.jasync.reactive.ReactivePromise;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;

public class ReactiveStream<T> {
    private final Publisher<T> publisher;
    private volatile JAsyncSubscriber<T> subscriber;
    private static final AtomicReferenceFieldUpdater<ReactiveStream, JAsyncSubscriber> SUBSCRIBER = AtomicReferenceFieldUpdater.newUpdater(ReactiveStream.class, JAsyncSubscriber.class, "subscriber");
    private volatile int state;

    public ReactiveStream(Publisher<T> publisher) {
        this.publisher = publisher;
    }

    private JAsyncSubscriber<T> getSubscriber(long n) {
        do {
            if (this.subscriber != null || !SUBSCRIBER.compareAndSet(this, null, new JAsyncSubscriber(n))) continue;
            return this.subscriber;
        } while (this.subscriber == null);
        return this.subscriber;
    }

    public JPromise<T> request(long n) {
        return new ReactivePromise<T>(this.publisher, this.getSubscriber(n), n);
    }
}

