/*
 * Decompiled with CFR 0.152.
 */
package io.github.vipcxj.jasync.ng.spec;

import io.github.vipcxj.jasync.ng.spec.JAsyncReadWriteLock;
import io.github.vipcxj.jasync.ng.spec.JContext;
import io.github.vipcxj.jasync.ng.spec.JHandle;
import io.github.vipcxj.jasync.ng.spec.JPortal;
import io.github.vipcxj.jasync.ng.spec.JPromiseTrigger;
import io.github.vipcxj.jasync.ng.spec.JScheduler;
import io.github.vipcxj.jasync.ng.spec.JThunk;
import io.github.vipcxj.jasync.ng.spec.Utils;
import io.github.vipcxj.jasync.ng.spec.functional.Functions;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncCatchFunction0;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncCatchFunction1;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncFunction0;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncFunction1;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPortalTask0;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPortalTask1;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPromiseFunction0;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPromiseFunction1;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPromiseFunction2;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPromiseFunction3;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPromiseSupplier0;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncPromiseSupplier1;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncSupplier0;
import io.github.vipcxj.jasync.ng.spec.functional.JAsyncSupplier1;
import io.github.vipcxj.jasync.ng.spec.functional.TriConsumer;
import io.github.vipcxj.jasync.ng.spec.spi.JPromiseSupport;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface JPromise<T>
extends JHandle<T> {
    public static final JPromiseSupport provider = Utils.getProvider(JPromiseSupport.class);
    public static final String MULTI_CATCH_ARGS_ERROR = "The arguments exceptionTypeAndCatches composed with throwable class and JPromiseCatchFunction0 or JPromiseCatchFunction1 pairs.";

    public static int genId() {
        return provider.generateId();
    }

    public static <T> JPromise<T> just(T value) {
        return provider.just(value);
    }

    public static <T> JPromise<T> empty() {
        return provider.just(null);
    }

    public static <T> JPromise<T> error(Throwable error) {
        return provider.error(error);
    }

    public static JPromise<Void> sleep(long timeout, TimeUnit unit) {
        return provider.sleep(timeout, unit);
    }

    public static <T> JPromise<T> portal(JAsyncPortalTask1<T> task) {
        return provider.portal(task);
    }

    public static <T> JPromise<T> portal(JAsyncPortalTask0<T> task) {
        return JPromise.portal((JPortal<T> factory, JContext context) -> task.invoke(factory));
    }

    public static <T> JPromise<T> portal(JAsyncPromiseFunction0<Object[], T> task, int jumpIndex, Object ... locals) {
        JPromise promise = JPromise.updateContext((JContext ctx) -> ctx.pushLocals(locals)).thenImmediate(() -> JPromise.portal((JPortal<T> factory, JContext context) -> {
            Object[] theLocals = context.getLocals();
            return JPromise.updateContext((JContext ctx) -> ctx.popLocals().setPortal(jumpIndex, factory)).thenImmediate(() -> task.apply(theLocals));
        }));
        return promise.withUpdateContext((JContext ctx) -> ctx.removePortal(jumpIndex));
    }

    public static <T> JPromise<T> portal(JAsyncPromiseFunction1<Object[], T> task, int jumpIndex, Object ... locals) {
        JPromise promise = JPromise.updateContext((JContext ctx) -> ctx.pushLocals(locals)).thenImmediate(() -> JPromise.portal((JPortal<T> factory, JContext context) -> {
            Object[] theLocals = context.getLocals();
            return JPromise.updateContext((JContext ctx) -> ctx.popLocals().setPortal(jumpIndex, factory)).thenWithContextImmediate((JContext ctx) -> task.apply(theLocals, ctx));
        }));
        return promise.withUpdateContext((JContext ctx) -> ctx.removePortal(jumpIndex));
    }

    public static <T> JPromise<T> jump(int jumpIndex, Object ... localVars) {
        return JPromise.updateContext((JContext ctx) -> ctx.pushLocals(localVars)).thenImmediate((T ctx) -> ctx.jump(jumpIndex));
    }

    public static JAsyncReadWriteLock readWriteLock() {
        return provider.readWriteLock();
    }

    public static <T> JPromise<T> methodDebugInfo(JAsyncPromiseSupplier1<T> supplier, String declaringClassQualifiedName, String method, String fileName) {
        return JPromise.updateContext((JContext ctx) -> ctx.pushStackFrame(declaringClassQualifiedName, method, fileName)).thenWithContextImmediate(supplier).withUpdateContext(JContext::popStackFrame);
    }

    public static <T> JPromise<T> wrap(JAsyncPromiseSupplier0<T> supplier) {
        return JPromise.empty().thenImmediate(supplier);
    }

    public static <T> JPromise<T> wrap(JAsyncPromiseSupplier1<T> supplier) {
        return JPromise.empty().thenWithContextImmediate(supplier);
    }

    @SafeVarargs
    public static <T> JPromise<T> any(JPromise<? extends T> ... promises) {
        return provider.any(promises);
    }

    public static <T> JPromise<T> any(List<JPromise<? extends T>> promises) {
        return provider.any(promises);
    }

    @SafeVarargs
    public static <T> JPromise<T> race(JPromise<? extends T> ... promises) {
        return provider.race(promises);
    }

    public static <T> JPromise<T> race(List<JPromise<? extends T>> promises) {
        return provider.race(promises);
    }

    public static <T> JPromise<List<T>> all(List<JPromise<? extends T>> promises) {
        return provider.all(promises);
    }

    @SafeVarargs
    public static <T> JPromise<List<T>> all(JPromise<? extends T> ... promises) {
        return provider.all(promises);
    }

    public static <T> JPromise<T> create(BiConsumer<JThunk<T>, JContext> handler) {
        return provider.create(handler);
    }

    public static <T> JPromise<T> generate(BiConsumer<JThunk<T>, JContext> handler) {
        return provider.generate(handler);
    }

    public static <T> JPromiseTrigger<T> createTrigger() {
        return provider.createTrigger();
    }

    public static JPromise<JContext> context() {
        return JPromise.generate(Functions.PROMISE_HANDLER_EXTRACT_CONTEXT);
    }

    public static JPromise<JContext> updateContext(JContext context) {
        return JPromise.generate((thunk, oldContext) -> thunk.resolve(oldContext, context));
    }

    public static JPromise<JContext> updateContext(Function<JContext, JContext> contextUpdater) {
        return JPromise.generate((thunk, context) -> {
            JContext newContext = (JContext)contextUpdater.apply((JContext)context);
            thunk.resolve(context, newContext);
        });
    }

    public static <T> JPromise<T> wrapContext(JPromise<T> promise, JContext context) {
        return JPromise.updateContext(context).thenImmediate(promise::withUpdateContext);
    }

    public static <T> JPromise<T> wrapContext(JPromise<T> promise, Function<JContext, JContext> contextUpdater) {
        return JPromise.updateContext(contextUpdater).thenImmediate(promise::withUpdateContext);
    }

    public static <T> JPromise<T> wrapContext(JAsyncPromiseFunction0<JContext, T> function, JContext context) {
        return JPromise.updateContext(context).thenWithContextImmediate((T oldContext, JContext newContext) -> function.apply(newContext).withUpdateContext((JContext)oldContext));
    }

    public static <T> JPromise<T> wrapContext(JAsyncPromiseFunction0<JContext, T> function, Function<JContext, JContext> contextUpdater) {
        return JPromise.updateContext(contextUpdater).thenWithContextImmediate((T oldContext, JContext newContext) -> function.apply(newContext).withUpdateContext((JContext)oldContext));
    }

    public static <T> JPromise<T> wrapContext(JAsyncPromiseSupplier0<T> function, JContext context) {
        return JPromise.updateContext(context).thenImmediate((T oldContext) -> function.get().withUpdateContext((JContext)oldContext));
    }

    public static <T> JPromise<T> wrapContext(JAsyncPromiseSupplier0<T> function, Function<JContext, JContext> contextUpdater) {
        return JPromise.updateContext(contextUpdater).thenImmediate((T oldContext) -> function.get().withUpdateContext((JContext)oldContext));
    }

    public static JPromise<JScheduler> updateScheduler(JScheduler scheduler) {
        return JPromise.generate((thunk, context) -> {
            JScheduler oldScheduler = context.getScheduler();
            JContext newContext = context.setScheduler(scheduler);
            thunk.resolve(oldScheduler, newContext);
        });
    }

    public static <T> JPromise<T> wrapScheduler(JPromise<T> promise, JScheduler scheduler) {
        return JPromise.updateScheduler(scheduler).thenImmediate(promise::withUpdateScheduler);
    }

    public static <T> JPromise<T> wrapScheduler(JAsyncPromiseSupplier0<T> function, JScheduler scheduler) {
        return JPromise.updateScheduler(scheduler).thenImmediate((T oldScheduler) -> function.get().withUpdateScheduler((JScheduler)oldScheduler));
    }

    public static JPromise<Boolean> hasContextValue(Object key) {
        return JPromise.generate((thunk, context) -> thunk.resolve(context.hasKey(key), (JContext)context));
    }

    public static <T> JPromise<T> getContextValue(Object key) {
        return JPromise.generate((thunk, context) -> thunk.resolve(context.get(key), (JContext)context));
    }

    public static <T> JPromise<T> getContextValue(Object key, T defaultValue) {
        return JPromise.generate((thunk, context) -> thunk.resolve(context.getOrDefault(key, defaultValue), (JContext)context));
    }

    public static <T> JPromise<Optional<T>> getContextValueOrEmpty(Object key) {
        return JPromise.generate((thunk, context) -> thunk.resolve(context.getOrEmpty(key), (JContext)context));
    }

    public static JPromise<JScheduler> getScheduler() {
        return JPromise.generate(Functions.PROMISE_HANDLER_EXTRACT_SCHEDULER);
    }

    public static <T> JPromise<T> setContextValue(Object key, Object newValue) {
        return JPromise.generate((thunk, context) -> {
            Object old = context.get(key);
            JContext newContext = context.set(key, newValue);
            thunk.resolve(old, newContext);
        });
    }

    public static JPromise<Void> updateContextValue(Object key, Function<Object, Object> valueUpdater) {
        return JPromise.generate((thunk, context) -> {
            Object value = context.get(key);
            JContext newContext = context.set(key, valueUpdater.apply(value));
            thunk.resolve(null, newContext);
        });
    }

    public static <E> JPromise<Void> updateContextValue(Object key, Function<E, E> valueUpdater, E emptyValue) {
        return JPromise.generate((thunk, context) -> {
            if (context.hasKey(key)) {
                Object value = context.get(key);
                JContext newContext = context.set(key, valueUpdater.apply(value));
                thunk.resolve(null, newContext);
            } else {
                JContext newContext = context.set(key, emptyValue);
                thunk.resolve(null, newContext);
            }
        });
    }

    public static JPromise<Boolean> setContextValueIfExists(Object key, Object newValue) {
        return JPromise.generate((thunk, context) -> {
            if (context.hasKey(key)) {
                JContext newContext = context.set(key, newValue);
                thunk.resolve(true, newContext);
            } else {
                thunk.resolve(false, (JContext)context);
            }
        });
    }

    public static JPromise<Void> updateContextValueIfExists(Object key, Function<Object, Object> valueUpdater) {
        return JPromise.generate((thunk, context) -> {
            if (context.hasKey(key)) {
                Object value = context.get(key);
                JContext newContext = context.set(key, valueUpdater.apply(value));
                thunk.resolve(null, newContext);
            } else {
                thunk.resolve(null, (JContext)context);
            }
        });
    }

    public static <T> JPromise<T> removeContextValue(Object key) {
        return JPromise.generate((thunk, context) -> {
            Object old = context.get(key);
            JContext newContext = context.remove(key);
            thunk.resolve(old, newContext);
        });
    }

    default public T await() throws InterruptedException {
        throw new UnsupportedOperationException("The method \"await\" should be called in an async method.");
    }

    public <R> JPromise<R> thenWithContext(JAsyncPromiseFunction1<T, R> var1, boolean var2);

    default public <R> JPromise<R> thenWithContext(JAsyncPromiseFunction1<T, R> mapper) {
        return this.thenWithContext(mapper, false);
    }

    default public <R> JPromise<R> thenWithContextImmediate(JAsyncPromiseFunction1<T, R> mapper) {
        return this.thenWithContext(mapper, true);
    }

    default public <R> JPromise<R> then(JAsyncPromiseFunction0<T, R> mapper, boolean immediate) {
        return this.thenWithContext((T v, JContext ctx) -> mapper.apply(v), immediate);
    }

    default public <R> JPromise<R> then(JAsyncPromiseFunction0<T, R> mapper) {
        return this.then(mapper, false);
    }

    default public <R> JPromise<R> thenImmediate(JAsyncPromiseFunction0<T, R> mapper) {
        return this.then(mapper, true);
    }

    default public <R> JPromise<R> thenWithContext(JAsyncPromiseSupplier1<R> supplier, boolean immediate) {
        return this.thenWithContext((T ignored, JContext ctx) -> supplier.get(ctx), immediate);
    }

    default public <R> JPromise<R> thenWithContext(JAsyncPromiseSupplier1<R> supplier) {
        return this.thenWithContext(supplier, false);
    }

    default public <R> JPromise<R> thenWithContextImmediate(JAsyncPromiseSupplier1<R> supplier) {
        return this.thenWithContext(supplier, true);
    }

    default public <R> JPromise<R> then(JAsyncPromiseSupplier0<R> supplier, boolean immediate) {
        return this.then((T ignored) -> supplier.get(), immediate);
    }

    default public <R> JPromise<R> then(JAsyncPromiseSupplier0<R> supplier) {
        return this.then(supplier, false);
    }

    default public <R> JPromise<R> thenImmediate(JAsyncPromiseSupplier0<R> supplier) {
        return this.then(supplier, true);
    }

    default public <R> JPromise<R> thenMapWithContext(JAsyncFunction1<T, R> function, boolean immediate) {
        return this.thenWithContext((T v, JContext ctx) -> JPromise.just(function.apply(v, ctx)), immediate);
    }

    default public <R> JPromise<R> thenMapWithContext(JAsyncFunction1<T, R> function) {
        return this.thenMapWithContext(function, false);
    }

    default public <R> JPromise<R> thenMapWithContextImmediate(JAsyncFunction1<T, R> function) {
        return this.thenMapWithContext(function, true);
    }

    default public <R> JPromise<R> thenMap(JAsyncFunction0<T, R> function, boolean immediate) {
        return this.then((T v) -> JPromise.just(function.apply(v)), immediate);
    }

    default public <R> JPromise<R> thenMap(JAsyncFunction0<T, R> function) {
        return this.thenMap(function, false);
    }

    default public <R> JPromise<R> thenMapImmediate(JAsyncFunction0<T, R> function) {
        return this.thenMap(function, true);
    }

    default public <R> JPromise<R> thenMapWithContext(JAsyncSupplier1<R> function, boolean immediate) {
        return this.thenWithContext((T v, JContext ctx) -> JPromise.just(function.get(ctx)), immediate);
    }

    default public <R> JPromise<R> thenMapWithContext(JAsyncSupplier1<R> function) {
        return this.thenMapWithContext(function, false);
    }

    default public <R> JPromise<R> thenMapWithContextImmediate(JAsyncSupplier1<R> function) {
        return this.thenMapWithContext(function, true);
    }

    default public <R> JPromise<R> thenMap(JAsyncSupplier0<R> function, boolean immediate) {
        return this.then((T v) -> JPromise.just(function.get()), immediate);
    }

    default public <R> JPromise<R> thenMap(JAsyncSupplier0<R> function) {
        return this.thenMap(function, false);
    }

    default public <R> JPromise<R> thenMapImmediate(JAsyncSupplier0<R> function) {
        return this.thenMap(function, true);
    }

    default public <R> JPromise<T> thenWithWithContext(JAsyncPromiseFunction1<T, R> function, boolean immediate) {
        return this.thenWithContext((T v, JContext ctx) -> function.apply(v, ctx).thenReturn(v), immediate);
    }

    default public <R> JPromise<T> thenWithWithContext(JAsyncPromiseFunction1<T, R> function) {
        return this.thenWithWithContext(function, false);
    }

    default public <R> JPromise<T> thenWithWithContextImmediate(JAsyncPromiseFunction1<T, R> function) {
        return this.thenWithWithContext(function, true);
    }

    default public <R> JPromise<T> thenWith(JAsyncPromiseFunction0<T, R> function, boolean immediate) {
        return this.then((T v) -> function.apply(v).thenReturn(v), immediate);
    }

    default public <R> JPromise<T> thenWith(JAsyncPromiseFunction0<T, R> function) {
        return this.thenWith(function, false);
    }

    default public <R> JPromise<T> thenWithImmediate(JAsyncPromiseFunction0<T, R> function) {
        return this.thenWith(function, true);
    }

    default public <R> JPromise<T> thenWithWithContext(JAsyncPromiseSupplier1<R> supplier, boolean immediate) {
        return this.thenWithContext((T v, JContext ctx) -> supplier.get(ctx).thenReturn(v), immediate);
    }

    default public <R> JPromise<T> thenWithWithContext(JAsyncPromiseSupplier1<R> supplier) {
        return this.thenWithWithContext(supplier, false);
    }

    default public <R> JPromise<T> thenWithWithContextImmediate(JAsyncPromiseSupplier1<R> supplier) {
        return this.thenWithWithContext(supplier, true);
    }

    default public <R> JPromise<T> thenWith(JAsyncPromiseSupplier0<R> supplier, boolean immediate) {
        return this.then((T v) -> supplier.get().thenReturn(v), immediate);
    }

    default public <R> JPromise<T> thenWith(JAsyncPromiseSupplier0<R> supplier) {
        return this.thenWith(supplier, false);
    }

    default public <R> JPromise<T> thenWithImmediate(JAsyncPromiseSupplier0<R> supplier) {
        return this.thenWith(supplier, true);
    }

    default public <R> JPromise<R> thenReturn(R next) {
        return this.thenMapImmediate(() -> next);
    }

    default public <R> JPromise<R> thenVoid() {
        return this.thenReturn(null);
    }

    default public <R> JPromise<R> thenPromise(JPromise<R> nextPromise) {
        return this.thenImmediate(() -> nextPromise);
    }

    default public JPromise<T> withContext(Consumer<JContext> consumer) {
        return this.thenWithWithContextImmediate((JContext context) -> {
            consumer.accept(context);
            return JPromise.empty();
        });
    }

    default public JPromise<T> withUpdateContext(JContext context) {
        return this.thenWithImmediate(() -> JPromise.updateContext((JContext ctx) -> context));
    }

    default public JPromise<T> withUpdateContext(Function<JContext, JContext> contextUpdater) {
        return this.thenWithImmediate(() -> JPromise.updateContext(contextUpdater));
    }

    default public JPromise<T> withSetContextValue(Object key, Object value) {
        return this.thenWithImmediate(() -> JPromise.setContextValue(key, value));
    }

    default public JPromise<T> withRemoveContextValue(Object key) {
        return this.thenWithImmediate(() -> JPromise.removeContextValue(key));
    }

    default public JPromise<T> withUpdateContextValue(Object key, Function<Object, Object> updater, Object emptyValue) {
        return this.thenWithImmediate(() -> JPromise.updateContextValue(key, updater, emptyValue));
    }

    default public JPromise<T> withUpdateContextValueIfExists(Object key, Function<Object, Object> updater) {
        return this.thenWithImmediate(() -> JPromise.updateContextValueIfExists(key, updater));
    }

    default public JPromise<T> withUpdateScheduler(JScheduler scheduler) {
        return this.thenWithImmediate(() -> JPromise.updateScheduler(scheduler));
    }

    default public JPromise<T> delay(long timeout, TimeUnit unit) {
        return this.thenWith(() -> JPromise.sleep(timeout, unit));
    }

    public JPromise<T> doCatchWithContext(JAsyncCatchFunction1<Throwable, T> var1, boolean var2);

    default public JPromise<T> doCatchWithContext(JAsyncCatchFunction1<Throwable, T> catcher) {
        return this.doCatchWithContext(catcher, false);
    }

    default public JPromise<T> doCatchWithContextImmediate(JAsyncCatchFunction1<Throwable, T> catcher) {
        return this.doCatchWithContext(catcher, true);
    }

    default public JPromise<T> doCatch(JAsyncCatchFunction0<Throwable, T> catcher, boolean immediate) {
        return this.doCatchWithContext((error, ctx) -> catcher.apply(error), immediate);
    }

    default public JPromise<T> doCatch(JAsyncCatchFunction0<Throwable, T> catcher) {
        return this.doCatch(catcher, false);
    }

    default public JPromise<T> doCatchImmediate(JAsyncCatchFunction0<Throwable, T> catcher) {
        return this.doCatch(catcher, true);
    }

    default public JPromise<T> doMultiCatches(boolean immediate, Object ... exceptionTypeAndCatches) {
        if ((exceptionTypeAndCatches.length & 1) == 1) {
            throw new IllegalArgumentException("The number of arguments exceptionTypeAndCatches must be even.");
        }
        int i = 0;
        while (i < exceptionTypeAndCatches.length) {
            Object arg;
            if (!((arg = exceptionTypeAndCatches[i++]) instanceof Class)) {
                throw new IllegalArgumentException(MULTI_CATCH_ARGS_ERROR);
            }
            Class exceptionType = (Class)arg;
            if (!Throwable.class.isAssignableFrom(exceptionType)) {
                throw new IllegalArgumentException(MULTI_CATCH_ARGS_ERROR);
            }
            if ((arg = exceptionTypeAndCatches[i++]) instanceof JAsyncCatchFunction0 || arg instanceof JAsyncCatchFunction1) continue;
            throw new IllegalArgumentException(MULTI_CATCH_ARGS_ERROR);
        }
        return this.doCatchWithContext((e, ctx) -> {
            int i = 0;
            while (i < exceptionTypeAndCatches.length) {
                Class exceptionType = (Class)exceptionTypeAndCatches[i++];
                Object closure = exceptionTypeAndCatches[i++];
                if (!exceptionType.isInstance(e)) continue;
                if (closure instanceof JAsyncCatchFunction0) {
                    return ((JAsyncCatchFunction0)closure).apply(e);
                }
                return ((JAsyncCatchFunction1)closure).apply(e, ctx);
            }
            throw e;
        }, immediate);
    }

    default public JPromise<T> doMultiCatches(Object ... exceptionTypeAndCatches) {
        return this.doMultiCatches(false, exceptionTypeAndCatches);
    }

    default public JPromise<T> doMultiCatchImmediate(Object ... exceptionTypeAndCatches) {
        return this.doMultiCatches(true, exceptionTypeAndCatches);
    }

    public <R> JPromise<R> thenOrCatchWithContext(JAsyncPromiseFunction3<T, R> var1, boolean var2);

    default public <R> JPromise<R> thenOrCatchWithContext(JAsyncPromiseFunction3<T, R> handler) {
        return this.thenOrCatchWithContext(handler, false);
    }

    default public <R> JPromise<R> thenOrCatchWithContextImmediate(JAsyncPromiseFunction3<T, R> handler) {
        return this.thenOrCatchWithContext(handler, true);
    }

    default public <R> JPromise<R> thenOrCatch(JAsyncPromiseFunction2<T, R> handler) {
        return this.thenOrCatchWithContext((t, throwable, context) -> handler.apply(t, throwable));
    }

    default public <R> JPromise<R> thenOrCatchImmediate(JAsyncPromiseFunction2<T, R> handler) {
        return this.thenOrCatchWithContext((t, throwable, context) -> handler.apply(t, throwable), true);
    }

    public <R> JPromise<T> doFinallyWithContext(JAsyncPromiseSupplier1<R> var1, boolean var2);

    default public <R> JPromise<T> doFinallyWithContext(JAsyncPromiseSupplier1<R> supplier) {
        return this.doFinallyWithContext(supplier, false);
    }

    default public <R> JPromise<T> doFinallyWithContextImmediate(JAsyncPromiseSupplier1<R> supplier) {
        return this.doFinallyWithContext(supplier, true);
    }

    default public <R> JPromise<T> doFinally(JAsyncPromiseSupplier0<R> supplier, boolean immediate) {
        return this.doFinallyWithContext(ctx -> supplier.get(), immediate);
    }

    default public <R> JPromise<T> doFinally(JAsyncPromiseSupplier0<R> supplier) {
        return this.doFinally(supplier, false);
    }

    default public <R> JPromise<T> doFinallyImmediate(JAsyncPromiseSupplier0<R> supplier) {
        return this.doFinally(supplier, true);
    }

    public JPromise<T> onSuccess(BiConsumer<T, JContext> var1);

    default public JPromise<T> onSuccess(Consumer<T> consumer) {
        return this.onSuccess((T v, JContext ctx) -> consumer.accept(v));
    }

    public JPromise<T> onError(BiConsumer<Throwable, JContext> var1);

    default public JPromise<T> onError(Consumer<Throwable> consumer) {
        return this.onError((Throwable error, JContext ctx) -> consumer.accept((Throwable)error));
    }

    public JPromise<T> onFinally(TriConsumer<T, Throwable, JContext> var1);

    default public JPromise<T> onFinally(Runnable runnable) {
        return this.onFinally((T v, Throwable e, JContext ctx) -> runnable.run());
    }

    default public JPromise<T> onFinally(Consumer<JContext> runnable) {
        return this.onFinally((T v, Throwable e, JContext ctx) -> runnable.accept((JContext)ctx));
    }

    default public JPromise<T> onFinally(BiConsumer<T, Throwable> runnable) {
        return this.onFinally((T v, Throwable e, JContext ctx) -> runnable.accept((Object)v, (Throwable)e));
    }

    public void schedule(JContext var1);

    public JHandle<T> async(JContext var1);

    default public JHandle<T> async() {
        return this.async(JContext.defaultContext());
    }
}

