/*
 * Decompiled with CFR 0.152.
 */
package io.github.vipcxj.schedule;

import io.github.vipcxj.schedule.EventHandle;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class Schedule
implements Closeable {
    private final Event head = new Event(0L, null, TAIL, null);
    private static final Event TAIL = new Event(0L, null, null, null);
    private static final Event BUSY = new Event(0L, null, null, null);
    private final Thread thread = new Thread(this::run);
    private volatile boolean parking;
    private static final AtomicReference<Schedule> INSTANCE = new AtomicReference();

    public static Schedule instance() {
        Schedule schedule = INSTANCE.get();
        if (schedule == null && !INSTANCE.compareAndSet(null, schedule = new Schedule())) {
            schedule.close();
            schedule = INSTANCE.get();
        }
        return schedule;
    }

    public Schedule() {
        this.thread.start();
    }

    private synchronized void signal() {
        if (this.parking) {
            this.notify();
        }
    }

    private synchronized void waitForever() throws InterruptedException {
        this.head.next = Schedule.TAIL;
        this.parking = true;
        try {
            this.wait();
        }
        finally {
            this.parking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitFor(long ns) throws InterruptedException {
        long ms = ns / 1000L / 1000L;
        this.parking = true;
        try {
            this.wait(ms, (int)(ns - ms * 1000L * 1000L));
        }
        finally {
            this.parking = false;
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
    }

    private void run() {
        try {
            while (true) {
                Event first = this.head.next;
                assert (first != null);
                if (first != TAIL) {
                    long now = System.nanoTime();
                    if (first.deadline <= now) {
                        Event prev = first.tryLockPrev();
                        if (prev == null) continue;
                        Event next = first.next;
                        assert (next != null);
                        if (next == TAIL) {
                            if (this.head.weakCasNext(first, TAIL)) {
                                first.prev = (first.next = null);
                                first.run();
                                continue;
                            }
                            first.prev = prev;
                            continue;
                        }
                        Event nextPrev = next.tryLockPrev();
                        if (nextPrev != null) {
                            if (nextPrev != first) {
                                next.prev = nextPrev;
                                first.prev = prev;
                                continue;
                            }
                            if (first == this.head.next && this.head.weakCasNext(first, next)) {
                                next.prev = this.head;
                                first.prev = (first.next = null);
                                first.run();
                                continue;
                            }
                            next.prev = nextPrev;
                            first.prev = prev;
                            continue;
                        }
                        first.prev = prev;
                        continue;
                    }
                    if (first.deadline - now > 100000L) {
                        this.waitFor(first.deadline - now);
                        continue;
                    }
                    Thread.yield();
                    continue;
                }
                if (first == BUSY) {
                    Thread.yield();
                    continue;
                }
                if (!this.head.weakCasNext(TAIL, BUSY)) continue;
                this.waitForever();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static EventHandle createInvalidHandle() {
        return new InvalidHandle();
    }

    public EventHandle addEvent(long time, TimeUnit unit, Runnable callback) {
        return this.addEvent(unit.toNanos(time), callback);
    }

    public EventHandle addEvent(long nanoTime, Runnable callback) {
        long deadline = System.nanoTime() + nanoTime;
        while (true) {
            Event first;
            if ((first = this.head.next) == TAIL) {
                Event event = new Event(deadline, callback, TAIL, this.head);
                if (!this.head.weakCasNext(TAIL, event)) continue;
                this.signal();
                return event;
            }
            if (first == BUSY) {
                Thread.yield();
                continue;
            }
            if (deadline < first.deadline) {
                Event prev = first.tryLockPrev();
                if (prev == null) continue;
                if (prev != this.head) {
                    first.prev = prev;
                    continue;
                }
                Event event = new Event(deadline, callback, first, this.head);
                if (!this.head.weakCasNext(first, event)) continue;
                first.prev = event;
                this.signal();
                return event;
            }
            Event node = first;
            Event next = first.next;
            while (next != null && next != TAIL && deadline >= next.deadline) {
                node = next;
                next = next.next;
            }
            if (next == BUSY) {
                throw new RuntimeException("This is impossible");
            }
            if (next == null) {
                Thread.yield();
                continue;
            }
            if (next == TAIL) {
                Event event = new Event(deadline, callback, TAIL, node);
                if (!node.weakCasNext(TAIL, event)) continue;
                return event;
            }
            Event nextPrev = next.tryLockPrev();
            if (nextPrev == null) {
                Thread.yield();
                continue;
            }
            Event event = new Event(deadline, callback, next, node);
            if (node.weakCasNext(next, event)) {
                next.prev = event;
                return event;
            }
            next.prev = nextPrev;
        }
    }

    static class Event
    implements EventHandle {
        private final long deadline;
        private final Runnable callback;
        private volatile Event next;
        private static final AtomicReferenceFieldUpdater<Event, Event> NEXT = AtomicReferenceFieldUpdater.newUpdater(Event.class, Event.class, "next");
        private volatile Event prev;
        private static final AtomicReferenceFieldUpdater<Event, Event> PREV = AtomicReferenceFieldUpdater.newUpdater(Event.class, Event.class, "prev");

        Event(long deadline, Runnable callback, Event next, Event prev) {
            this.deadline = deadline;
            this.callback = callback;
            this.next = next;
            this.prev = prev;
        }

        boolean weakCasNext(Event expect, Event update) {
            return NEXT.weakCompareAndSet(this, expect, update);
        }

        Event tryLockPrev() {
            Event prev = this.prev;
            return prev != null && prev != BUSY && PREV.weakCompareAndSet(this, prev, BUSY) ? prev : null;
        }

        @Override
        public boolean remove() {
            while (true) {
                Event prev = this.prev;
                Event next = this.next;
                if (prev == null || next == null) {
                    return false;
                }
                if (prev == BUSY) {
                    Thread.yield();
                    continue;
                }
                if (!PREV.weakCompareAndSet(this, prev, BUSY)) {
                    Thread.yield();
                    continue;
                }
                if (next == BUSY) {
                    this.prev = prev;
                    Thread.yield();
                    continue;
                }
                Event nextPrev = null;
                if (next != TAIL) {
                    nextPrev = next.tryLockPrev();
                    if (nextPrev == null) {
                        this.prev = prev;
                        Thread.yield();
                        continue;
                    }
                    if (nextPrev != this) {
                        next.prev = nextPrev;
                        this.prev = prev;
                        Thread.yield();
                        continue;
                    }
                }
                if (prev.weakCasNext(this, next)) {
                    if (next != TAIL) {
                        next.prev = prev;
                    }
                    this.prev = null;
                    this.next = null;
                    return true;
                }
                if (next != TAIL) {
                    next.prev = nextPrev;
                }
                this.prev = prev;
            }
        }

        public void run() {
            try {
                this.callback.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static class InvalidHandle
    implements EventHandle {
        InvalidHandle() {
        }

        @Override
        public boolean remove() {
            throw new UnsupportedOperationException();
        }
    }
}

