/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.client;

import io.github.vishalmysore.a2a.domain.DataPart;
import io.github.vishalmysore.a2a.domain.FileContent;
import io.github.vishalmysore.a2a.domain.FilePart;
import io.github.vishalmysore.a2a.domain.JsonRpcRequest;
import io.github.vishalmysore.a2a.domain.Message;
import io.github.vishalmysore.a2a.domain.Part;
import io.github.vishalmysore.a2a.domain.SendTaskResponse;
import io.github.vishalmysore.a2a.domain.Task;
import io.github.vishalmysore.a2a.domain.TaskQueryParams;
import io.github.vishalmysore.a2a.domain.TaskSendParams;
import io.github.vishalmysore.a2a.domain.TextPart;
import io.github.vishalmysore.common.server.JsonRpcController;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;

public class LocalA2ATaskClient {
    private static final Logger log = Logger.getLogger(LocalA2ATaskClient.class.getName());
    public static final String TASKS_SEND = "tasks/send";
    public static final String TASKS_GET = "tasks/get";
    public static final String ERROR_SENDING_FILE_TASK = "Error sending file task: ";
    private JsonRpcController jrc = null;

    public LocalA2ATaskClient() {
        this.jrc = new JsonRpcController();
    }

    public LocalA2ATaskClient(JsonRpcController jrc) {
        this.jrc = jrc;
    }

    private JsonRpcRequest createRequest(String method, Object params) {
        return new JsonRpcRequest("2.0", method, params, UUID.randomUUID().toString());
    }

    public Task sendTask(String prompt) {
        try {
            Message message = new Message();
            TextPart textPart = new TextPart();
            textPart.setText(prompt);
            message.setParts(Collections.singletonList(textPart));
            TaskSendParams params = new TaskSendParams();
            params.setId(String.valueOf(UUID.randomUUID()));
            params.setMessage(message);
            JsonRpcRequest request = this.createRequest(TASKS_SEND, params);
            return ((SendTaskResponse)this.jrc.handleRpc(request)).getResult();
        }
        catch (HttpClientErrorException e) {
            log.severe("Error sending task: " + e.getMessage());
            throw e;
        }
    }

    public Task getTask(String taskId, Integer historyLength) {
        try {
            TaskQueryParams params = new TaskQueryParams();
            params.setId(taskId);
            params.setHistoryLength(historyLength);
            JsonRpcRequest request = this.createRequest(TASKS_GET, params);
            ResponseEntity response = (ResponseEntity)this.jrc.handleRpc(request);
            return (Task)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.severe("Error getting task: " + e.getMessage());
            throw e;
        }
    }

    public Task sendFileTask(String filePath) {
        try {
            log.info(filePath);
            Message message = new Message();
            FilePart filePart = new FilePart();
            FileContent content = new FileContent();
            filePart.setFile(content);
            message.setParts(Collections.singletonList(filePart));
            TaskSendParams params = new TaskSendParams();
            params.setId(String.valueOf(UUID.randomUUID()));
            params.setMessage(message);
            JsonRpcRequest request = this.createRequest(TASKS_SEND, params);
            return ((SendTaskResponse)this.jrc.handleRpc(request)).getResult();
        }
        catch (HttpClientErrorException e) {
            log.severe(ERROR_SENDING_FILE_TASK + e.getMessage());
            throw e;
        }
    }

    public Task sendFileTask(FilePart filePart) {
        try {
            Message message = new Message();
            message.setParts(Collections.singletonList(filePart));
            TaskSendParams params = new TaskSendParams();
            params.setId(String.valueOf(UUID.randomUUID()));
            params.setMessage(message);
            JsonRpcRequest request = this.createRequest(TASKS_SEND, params);
            return ((SendTaskResponse)this.jrc.handleRpc(request)).getResult();
        }
        catch (HttpClientErrorException e) {
            log.severe(ERROR_SENDING_FILE_TASK + e.getMessage());
            throw e;
        }
    }

    public Task sendFileTask(TextPart textPart, FilePart filePart) {
        try {
            Message message = new Message();
            ArrayList<Part> partList = new ArrayList<Part>();
            partList.add(textPart);
            partList.add(filePart);
            message.setParts(partList);
            TaskSendParams params = new TaskSendParams();
            params.setId(String.valueOf(UUID.randomUUID()));
            params.setMessage(message);
            JsonRpcRequest request = this.createRequest(TASKS_SEND, params);
            return ((SendTaskResponse)this.jrc.handleRpc(request)).getResult();
        }
        catch (HttpClientErrorException e) {
            log.severe(ERROR_SENDING_FILE_TASK + e.getMessage());
            throw e;
        }
    }

    public Task sendDataTask(Map<String, Object> data) {
        try {
            Message message = new Message();
            DataPart dataPart = new DataPart();
            dataPart.setData(data);
            message.setParts(Collections.singletonList(dataPart));
            TaskSendParams params = new TaskSendParams();
            params.setId(String.valueOf(UUID.randomUUID()));
            params.setMessage(message);
            JsonRpcRequest request = this.createRequest(TASKS_SEND, params);
            return ((SendTaskResponse)this.jrc.handleRpc(request)).getResult();
        }
        catch (HttpClientErrorException e) {
            log.severe("Error sending data task: " + e.getMessage());
            throw e;
        }
    }

    public Task sendMultiPartTask(List<Object> parts) {
        try {
            Message message = new Message();
            ArrayList<Part> messageParts = new ArrayList<Part>();
            for (Object part : parts) {
                if (part instanceof String) {
                    TextPart textPart = new TextPart();
                    textPart.setText((String)part);
                    messageParts.add(textPart);
                    continue;
                }
                if (part instanceof File) {
                    FilePart filePart = new FilePart();
                    FileContent content = new FileContent();
                    filePart.setFile(content);
                    messageParts.add(filePart);
                    continue;
                }
                DataPart dataPart = new DataPart();
                messageParts.add(dataPart);
            }
            TaskSendParams params = new TaskSendParams();
            params.setId(String.valueOf(UUID.randomUUID()));
            params.setMessage(message);
            JsonRpcRequest request = this.createRequest(TASKS_SEND, params);
            return ((SendTaskResponse)this.jrc.handleRpc(request)).getResult();
        }
        catch (HttpClientErrorException e) {
            log.severe("Error sending multi-part task: " + e.getMessage());
            throw e;
        }
    }
}

