/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.server;

import com.t4a.api.AIAction;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.api.GroupInfo;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.GeminiV2PromptTransformer;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.a2a.domain.AgentCard;
import io.github.vishalmysore.a2a.server.A2AAgentCardController;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;

public class RealTimeAgentCardController
implements A2AAgentCardController {
    private static final Logger log = Logger.getLogger(RealTimeAgentCardController.class.getName());
    private PromptTransformer promptTransformer;
    public static final String WELL_KNOWN_PATH = "/.well-known/";
    public static final String AGENT_PATH = "/agent.json";
    private AgentCard cachedAgentCard;
    @Value(value="${server.port:8080}")
    private String serverPort;

    public RealTimeAgentCardController() {
        this.promptTransformer = new GeminiV2PromptTransformer();
    }

    public RealTimeAgentCardController(ApplicationContext context) {
        PredictionLoader.getInstance((ApplicationContext)context);
        this.promptTransformer = new GeminiV2PromptTransformer();
    }

    public boolean isMethodAllowed(Method method) {
        log.info(method.getName());
        return true;
    }

    @Override
    public PromptTransformer getPromptTransformer() {
        return this.promptTransformer;
    }

    @PostConstruct
    public void init() {
        this.promptTransformer = PredictionLoader.getInstance().createOrGetPromptTransformer();
        Map groupActions = PredictionLoader.getInstance().getActionGroupList().getGroupActions();
        Map predictions = PredictionLoader.getInstance().getPredictions();
        StringBuilder realTimeDescription = new StringBuilder("This agent provides the following capabilities: ");
        for (Map.Entry entry : groupActions.entrySet()) {
            GroupInfo group = (GroupInfo)entry.getKey();
            String[] actionNames = ((String)entry.getValue()).split(",");
            StringBuilder methodNames = new StringBuilder();
            for (String actionName : actionNames) {
                GenericJavaMethodAction methodAction;
                Method m;
                AIAction action = (AIAction)predictions.get(actionName.trim());
                if (!(action instanceof GenericJavaMethodAction) || !this.isMethodAllowed(m = (methodAction = (GenericJavaMethodAction)action).getActionMethod())) continue;
                methodNames.append(",");
                methodNames.append(actionName.trim());
            }
            realTimeDescription.append(group.getGroupName()).append(" (").append(group.getGroupDescription()).append("), with actions: ").append((CharSequence)methodNames).append("; ");
        }
        if (realTimeDescription.length() > 2) {
            realTimeDescription.setLength(realTimeDescription.length() - 2);
        }
        String finalDescription = realTimeDescription.toString();
        try {
            if (groupActions.isEmpty()) {
                log.warning("No actions found for the agent card");
                card = new AgentCard();
                this.storeCard(card);
            } else {
                card = (AgentCard)this.promptTransformer.transformIntoPojo("use this description and also populate skills in detail " + finalDescription, AgentCard.class);
                this.storeCard(card);
            }
            String hostName = InetAddress.getLocalHost().getHostName();
            this.cachedAgentCard.setUrl("http://" + hostName + ":" + this.serverPort);
            this.poplateCardFromProperties(this.cachedAgentCard);
        }
        catch (AIProcessingException e) {
            log.severe("The skills are not populate in the agent card as actions are more in number \n you can either try with different processor \n or you can populate skills individually and add to agent card , or it could be that AI key is not initialized " + e.getMessage());
        }
        catch (UnknownHostException e) {
            log.warning("host not knwon set the url manually card.setUrl");
        }
    }

    public void storeCard(AgentCard card) {
        this.cachedAgentCard = card;
    }

    private boolean isNonEmptyString(String value) {
        return value != null && !value.trim().isEmpty();
    }

    public void poplateCardFromProperties(AgentCard card) {
        String authCredentials;
        String authSchemes;
        String providerUrl;
        String organization;
        String defaultInputModes;
        String defaultOutputModes;
        String documentationUrl;
        String version;
        String url;
        Boolean stateTransitionHistory;
        Boolean pushNotifications;
        Boolean streaming;
        String cardName;
        Map tools4AI = PredictionLoader.getInstance().getTools4AIProperties();
        String cardDescription = (String)tools4AI.get("a2a.card.description");
        if (this.isNonEmptyString(cardDescription)) {
            card.setDescription(cardDescription);
        }
        if (this.isNonEmptyString(cardName = (String)tools4AI.get("a2a.card.name"))) {
            card.setName(cardName);
        }
        if ((streaming = (Boolean)tools4AI.get("a2a.card.capabilities.streaming")) != null) {
            card.getCapabilities().setStreaming(streaming);
        }
        if ((pushNotifications = (Boolean)tools4AI.get("a2a.card.capabilities.pushNotifications")) != null) {
            card.getCapabilities().setPushNotifications(pushNotifications);
        }
        if ((stateTransitionHistory = (Boolean)tools4AI.get("a2a.card.capabilities.stateTransitionHistory")) != null) {
            card.getCapabilities().setStateTransitionHistory(stateTransitionHistory);
        }
        if (this.isNonEmptyString(url = (String)tools4AI.get("a2a.card.url"))) {
            card.setUrl(url);
        }
        if (this.isNonEmptyString(version = (String)tools4AI.get("a2a.card.version"))) {
            card.setVersion(version);
        }
        if (this.isNonEmptyString(documentationUrl = (String)tools4AI.get("a2a.card.documentationUrl"))) {
            card.setDocumentationUrl(documentationUrl);
        }
        if (this.isNonEmptyString(defaultOutputModes = (String)tools4AI.get("a2a.card.defaultOutputModes"))) {
            card.setDefaultOutputModes(defaultOutputModes.split(","));
        }
        if (this.isNonEmptyString(defaultInputModes = (String)tools4AI.get("a2a.card.defaultInputModes"))) {
            card.setDefaultInputModes(defaultInputModes.split(","));
        }
        if (this.isNonEmptyString(organization = (String)tools4AI.get("a2a.card.provider.organization"))) {
            card.getProvider().setOrganization(organization);
        }
        if (this.isNonEmptyString(providerUrl = (String)tools4AI.get("a2a.card.provider.url"))) {
            card.getProvider().setUrl(providerUrl);
        }
        if (this.isNonEmptyString(authSchemes = (String)tools4AI.get("a2a.card.authentication.schemes"))) {
            card.getAuthentication().setSchemes(authSchemes.split(","));
        }
        if (this.isNonEmptyString(authCredentials = (String)tools4AI.get("a2a.card.authentication.credentials"))) {
            card.getAuthentication().setCredentials(authCredentials);
        }
    }

    @Override
    public ResponseEntity<AgentCard> getAgentCard() {
        return ResponseEntity.ok((Object)this.cachedAgentCard);
    }

    public AgentCard getCachedAgentCard() {
        return this.cachedAgentCard;
    }
}

