/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.mcp.domain;

import io.github.vishalmysore.common.AgentInfo;
import io.github.vishalmysore.mcp.domain.Tool;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ListToolsResult
implements AgentInfo {
    private Map<String, Object> _meta;
    private List<Tool> tools;

    public Map<String, Object> getMeta() {
        return this._meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this._meta = meta;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    public String retrieveToolList() {
        if (this.tools == null || this.tools.isEmpty()) {
            return "[]";
        }
        StringBuilder jsonBuilder = new StringBuilder("[\n");
        for (int i = 0; i < this.tools.size(); ++i) {
            Tool tool = this.tools.get(i);
            jsonBuilder.append("  {\n").append("    \"toolName\": \"").append(tool.getName().replace("\"", "\\\"")).append("\",\n").append("    \"toolDescription\": \"").append(tool.getDescription().replace("\"", "\\\"")).append("\"\n").append("  }");
            if (i < this.tools.size() - 1) {
                jsonBuilder.append(",");
            }
            jsonBuilder.append("\n");
        }
        jsonBuilder.append("]");
        return jsonBuilder.toString();
    }

    public String toString() {
        return "ListToolsResult(_meta=" + this._meta + ", tools=" + this.getTools() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListToolsResult)) {
            return false;
        }
        ListToolsResult other = (ListToolsResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$_meta = this._meta;
        Map<String, Object> other$_meta = other._meta;
        if (this$_meta == null ? other$_meta != null : !((Object)this$_meta).equals(other$_meta)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        return !(this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListToolsResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $_meta = this._meta;
        result = result * 59 + ($_meta == null ? 43 : ((Object)$_meta).hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        return result;
    }
}

