/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.mesh;

import com.t4a.JsonUtils;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.common.CommonClientResponse;
import io.github.vishalmysore.mesh.AgentCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgenticMesh {
    private static final Logger log = LoggerFactory.getLogger(AgenticMesh.class);
    private final AgentCatalog agentCatalog;
    private final AIProcessor aiProcessor;
    private final PromptTransformer promptTransformer;
    private final JsonUtils jsonUtils = new JsonUtils();

    public AgenticMesh(AgentCatalog agentCatalog) {
        this.agentCatalog = agentCatalog;
        this.aiProcessor = PredictionLoader.getInstance().createOrGetAIProcessor();
        this.promptTransformer = PredictionLoader.getInstance().createOrGetPromptTransformer();
    }

    public CommonClientResponse pipeLineMesh(String query) {
        return this.pipeLineMesh(query, null);
    }

    public CommonClientResponse pipeLineMesh(String query, CommonClientResponse previousResponse) {
        CommonClientResponse response = this.agentCatalog.processQuery(query);
        String jsonYesOrNo = null;
        String yesOrNoField = "is_User_Query_Answered_Fully_Yes_Or_No_Only";
        String pendingQuery = "if_No_Then_What_Is_Pending_Query";
        if (response == null) {
            return previousResponse;
        }
        try {
            jsonYesOrNo = this.promptTransformer.transformIntoJson(this.jsonUtils.createJson(new String[]{yesOrNoField, pendingQuery}).toString(), "Original query " + query + " response " + response + " ");
            String yesOrNo = this.jsonUtils.getFieldValueFromMultipleFields(jsonYesOrNo, yesOrNoField);
            if (yesOrNo.contains("Yes")) {
                return response;
            }
            String pendingQueryValue = this.jsonUtils.getFieldValueFromMultipleFields(jsonYesOrNo, pendingQuery);
            response = this.pipeLineMesh("Pending query " + pendingQueryValue + " response " + response.getTextResult(), response);
        }
        catch (AIProcessingException e) {
            log.warn(e.getMessage());
        }
        return response;
    }

    public CommonClientResponse hubAndSpoke(String query) {
        CommonClientResponse mainResponse = this.agentCatalog.processQuery(query);
        String jsonQueries = null;
        String subQueriesField = "list_of_sub_queries_needed_to_complete_the_answer";
        if (mainResponse == null) {
            return null;
        }
        try {
            jsonQueries = this.promptTransformer.transformIntoJson(this.jsonUtils.createJson(subQueriesField).toString(), "Original query: " + query + " Initial response: " + mainResponse.getTextResult());
            String subQueriesString = this.jsonUtils.getFieldValueFromMultipleFields(jsonQueries, subQueriesField);
            if (subQueriesString == null || subQueriesString.isEmpty()) {
                return mainResponse;
            }
            String[] subQueries = subQueriesString.split(",");
            StringBuilder aggregatedResponse = new StringBuilder(mainResponse.getTextResult());
            for (String subQuery : subQueries) {
                CommonClientResponse subResponse = this.agentCatalog.processQuery(subQuery.trim());
                if (subResponse == null) continue;
                aggregatedResponse.append("\n").append(subResponse.getTextResult());
            }
            return this.agentCatalog.processQuery("Combine and summarize: " + aggregatedResponse);
        }
        catch (AIProcessingException e) {
            return mainResponse;
        }
    }

    public CommonClientResponse blackboard(String query) {
        CommonClientResponse initialKnowledge = this.agentCatalog.processQuery(query);
        String jsonAnalysis = null;
        String knowledgeGapsField = "knowledge_gaps_to_investigate";
        String expertAgentsField = "required_expert_agents";
        if (initialKnowledge == null) {
            return null;
        }
        try {
            jsonAnalysis = this.promptTransformer.transformIntoJson(this.jsonUtils.createJson(new String[]{knowledgeGapsField, expertAgentsField}).toString(), "Analyze knowledge gaps and required experts for: " + initialKnowledge.getTextResult());
            String gaps = this.jsonUtils.getFieldValueFromMultipleFields(jsonAnalysis, knowledgeGapsField);
            String experts = this.jsonUtils.getFieldValueFromMultipleFields(jsonAnalysis, expertAgentsField);
            if (gaps == null || experts == null) {
                return initialKnowledge;
            }
            StringBuilder blackboard = new StringBuilder(initialKnowledge.getTextResult());
            String[] requiredExperts = experts.split(",");
            String[] knowledgeGaps = gaps.split(",");
            for (int i = 0; i < requiredExperts.length && i < knowledgeGaps.length; ++i) {
                String expertQuery = String.format("As a %s expert, address: %s\nCurrent knowledge: %s", requiredExperts[i].trim(), knowledgeGaps[i].trim(), blackboard.toString());
                CommonClientResponse expertResponse = this.agentCatalog.processQuery(expertQuery);
                if (expertResponse == null) continue;
                blackboard.append("\n\nExpert ").append(requiredExperts[i].trim()).append(" contribution:\n").append(expertResponse.getTextResult());
            }
            return this.agentCatalog.processQuery("Synthesize all expert contributions into a coherent response:\n" + blackboard.toString());
        }
        catch (AIProcessingException e) {
            return initialKnowledge;
        }
    }
}

