/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.vishalmysore.a2a.domain.AgentCard;
import io.github.vishalmysore.a2a.domain.JsonRpcRequest;
import io.github.vishalmysore.a2a.domain.Message;
import io.github.vishalmysore.a2a.domain.SendTaskResponse;
import io.github.vishalmysore.a2a.domain.TaskSendParams;
import io.github.vishalmysore.a2a.domain.TextPart;
import io.github.vishalmysore.common.Agent;
import io.github.vishalmysore.common.AgentInfo;
import io.github.vishalmysore.common.CommonClientResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class A2AAgent
implements Agent {
    private static final Logger log = Logger.getLogger(A2AAgent.class.getName());
    private AgentCard agentCard = null;
    private ObjectMapper mapper = new ObjectMapper();
    private URL serverUrl = null;
    public static final String WELL_KNOWN_PATH = ".well-known";
    public static final String AGENT_PATH = "/agent.json";
    private String type = "a2a";

    public A2AAgent() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public CommonClientResponse remoteMethodCall(String query) {
        try {
            Message message = new Message();
            TextPart textPart = new TextPart();
            textPart.setText(query);
            message.setParts(Collections.singletonList(textPart));
            TaskSendParams params = new TaskSendParams();
            params.setMessage(message);
            params.setId(String.valueOf(UUID.randomUUID()));
            JsonRpcRequest request = this.createRequest("tasks/send", params);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.postForEntity(this.getServerUrl().toURI().toString(), (Object)request, SendTaskResponse.class, new Object[0]);
            return (CommonClientResponse)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.severe("Error sending task: " + e.getMessage());
            throw e;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonRpcRequest createRequest(String method, Object params) {
        return new JsonRpcRequest("2.0", method, params, UUID.randomUUID().toString());
    }

    @Override
    public CommonClientResponse remoteMethodCall(String remoteMethodName, String query) {
        return this.remoteMethodCall(query + " - possible action for this query is " + remoteMethodName);
    }

    @Override
    public void connect(String url, String token) {
        try {
            this.serverUrl = new URL((String)url);
            if (!((String)url).endsWith(".json")) {
                url = ((String)url).endsWith("/") ? (String)url + ".well-known/agent.json" : (String)url + "/.well-known/agent.json";
            } else if (!((String)url).contains(WELL_KNOWN_PATH)) {
                throw new IllegalArgumentException("URL must end with .well-known/agent.json");
            }
            URL agentCardUrl = new URL((String)url);
            HttpURLConnection conn = (HttpURLConnection)agentCardUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed to connect: HTTP " + conn.getResponseCode());
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
                this.agentCard = (AgentCard)this.mapper.readValue(response.toString(), AgentCard.class);
            }
        }
        catch (IOException e) {
            log.severe("Failed to connect to agent server: " + e.getMessage());
            throw new RuntimeException("Connection failed", e);
        }
    }

    @Override
    public void disconnect() {
        this.agentCard = null;
        this.serverUrl = null;
    }

    @Override
    public AgentInfo getInfo() {
        return this.agentCard;
    }

    @Override
    public boolean isConnected() {
        return this.agentCard != null && this.agentCard.getName() != null;
    }

    @Override
    public URL getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

