/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.domain;

import com.t4a.annotations.ListType;
import io.github.vishalmysore.a2a.domain.Authentication;
import io.github.vishalmysore.a2a.domain.Capabilities;
import io.github.vishalmysore.a2a.domain.Provider;
import io.github.vishalmysore.a2a.domain.Skill;
import io.github.vishalmysore.common.AgentInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class AgentCard
implements AgentInfo {
    private String name;
    private String description;
    private String url;
    private Provider provider;
    private String version;
    private String documentationUrl;
    private Capabilities capabilities;
    private Authentication authentication;
    private String[] defaultInputModes;
    private String[] defaultOutputModes;
    @ListType(value=Skill.class)
    private List<Skill> skills;

    public void addSkill(String name, String description) {
        if (this.skills == null) {
            this.skills = new ArrayList<Skill>();
        }
        Skill skill = new Skill();
        skill.setId(UUID.randomUUID().toString());
        skill.setName(name);
        skill.setDescription(description);
        this.skills.add(skill);
    }

    public void addSkill(String name, String description, String ... tags) {
        if (this.skills == null) {
            this.skills = new ArrayList<Skill>();
        }
        Skill skill = new Skill();
        skill.setId(UUID.randomUUID().toString());
        skill.setName(name);
        skill.setDescription(description);
        skill.setTags(tags);
        this.skills.add(skill);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String[] getDefaultInputModes() {
        return this.defaultInputModes;
    }

    public String[] getDefaultOutputModes() {
        return this.defaultOutputModes;
    }

    public List<Skill> getSkills() {
        return this.skills;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setDefaultInputModes(String[] defaultInputModes) {
        this.defaultInputModes = defaultInputModes;
    }

    public void setDefaultOutputModes(String[] defaultOutputModes) {
        this.defaultOutputModes = defaultOutputModes;
    }

    public void setSkills(List<Skill> skills) {
        this.skills = skills;
    }

    public String toString() {
        return "AgentCard(name=" + this.getName() + ", description=" + this.getDescription() + ", url=" + this.getUrl() + ", provider=" + this.getProvider() + ", version=" + this.getVersion() + ", documentationUrl=" + this.getDocumentationUrl() + ", capabilities=" + this.getCapabilities() + ", authentication=" + this.getAuthentication() + ", defaultInputModes=" + Arrays.deepToString(this.getDefaultInputModes()) + ", defaultOutputModes=" + Arrays.deepToString(this.getDefaultOutputModes()) + ", skills=" + this.getSkills() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentCard)) {
            return false;
        }
        AgentCard other = (AgentCard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Provider this$provider = this.getProvider();
        Provider other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$documentationUrl = this.getDocumentationUrl();
        String other$documentationUrl = other.getDocumentationUrl();
        if (this$documentationUrl == null ? other$documentationUrl != null : !this$documentationUrl.equals(other$documentationUrl)) {
            return false;
        }
        Capabilities this$capabilities = this.getCapabilities();
        Capabilities other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDefaultInputModes(), other.getDefaultInputModes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDefaultOutputModes(), other.getDefaultOutputModes())) {
            return false;
        }
        List<Skill> this$skills = this.getSkills();
        List<Skill> other$skills = other.getSkills();
        return !(this$skills == null ? other$skills != null : !((Object)this$skills).equals(other$skills));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentCard;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Provider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $documentationUrl = this.getDocumentationUrl();
        result = result * 59 + ($documentationUrl == null ? 43 : $documentationUrl.hashCode());
        Capabilities $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDefaultInputModes());
        result = result * 59 + Arrays.deepHashCode(this.getDefaultOutputModes());
        List<Skill> $skills = this.getSkills();
        result = result * 59 + ($skills == null ? 43 : ((Object)$skills).hashCode());
        return result;
    }
}

