/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.domain;

import com.t4a.annotations.Prompt;
import java.util.Arrays;
import java.util.Base64;

public class Authentication {
    @Prompt(describe="The authentication schemes supported by the a2a protocol server, e.g., Basic, Bearer, ApiKey. Dont keep it empty")
    private String[] schemes;
    private String credentials;

    public Authentication() {
    }

    public Authentication(String[] schemes) {
        this.schemes = schemes;
    }

    public void setBasicAuth(String username, String password) {
        this.schemes = new String[]{"Basic"};
        String auth = username + ":" + password;
        this.credentials = Base64.getEncoder().encodeToString(auth.getBytes());
    }

    public void setBearerAuth(String token) {
        this.schemes = new String[]{"Bearer"};
        this.credentials = token;
    }

    public void setApiKeyAuth(String apiKey) {
        this.schemes = new String[]{"ApiKey"};
        this.credentials = apiKey;
    }

    public boolean isBasicAuth() {
        return this.schemes != null && this.schemes.length > 0 && "Basic".equals(this.schemes[0]);
    }

    public boolean isBearerAuth() {
        return this.schemes != null && this.schemes.length > 0 && "Bearer".equals(this.schemes[0]);
    }

    public static Authentication fromAuthorizationHeader(String header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        Authentication auth = new Authentication();
        if (header.startsWith("Basic ")) {
            auth.setSchemes(new String[]{"Basic"});
            auth.setCredentials(header.substring(6));
        } else if (header.startsWith("Bearer ")) {
            auth.setSchemes(new String[]{"Bearer"});
            auth.setCredentials(header.substring(7));
        } else {
            auth.setSchemes(new String[]{"ApiKey"});
            auth.setCredentials(header);
        }
        return auth;
    }

    public boolean isValid() {
        return this.schemes != null && this.schemes.length > 0 && this.credentials != null && !this.credentials.isEmpty();
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authentication)) {
            return false;
        }
        Authentication other = (Authentication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSchemes(), other.getSchemes())) {
            return false;
        }
        String this$credentials = this.getCredentials();
        String other$credentials = other.getCredentials();
        return !(this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Authentication;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getSchemes());
        String $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        return result;
    }

    public String toString() {
        return "Authentication(schemes=" + Arrays.deepToString(this.getSchemes()) + ")";
    }
}

