/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.t4a.JsonUtils;
import com.t4a.detect.ActionCallback;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.GeminiV2ActionProcessor;
import com.t4a.processor.scripts.BaseScriptProcessor;
import com.t4a.processor.scripts.ScriptProcessor;
import com.t4a.processor.scripts.ScriptResult;
import com.t4a.transform.GeminiV2PromptTransformer;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.a2a.domain.Artifact;
import io.github.vishalmysore.a2a.domain.FileContent;
import io.github.vishalmysore.a2a.domain.FilePart;
import io.github.vishalmysore.a2a.domain.Message;
import io.github.vishalmysore.a2a.domain.Part;
import io.github.vishalmysore.a2a.domain.SendTaskResponse;
import io.github.vishalmysore.a2a.domain.Task;
import io.github.vishalmysore.a2a.domain.TaskArtifactUpdateEvent;
import io.github.vishalmysore.a2a.domain.TaskGetPushNotificationParams;
import io.github.vishalmysore.a2a.domain.TaskPushNotificationConfig;
import io.github.vishalmysore.a2a.domain.TaskPushNotificationConfigRequest;
import io.github.vishalmysore.a2a.domain.TaskResubscriptionParams;
import io.github.vishalmysore.a2a.domain.TaskSendParams;
import io.github.vishalmysore.a2a.domain.TaskSendSubscribeParams;
import io.github.vishalmysore.a2a.domain.TaskSetPushNotificationParams;
import io.github.vishalmysore.a2a.domain.TaskState;
import io.github.vishalmysore.a2a.domain.TaskStatus;
import io.github.vishalmysore.a2a.domain.TaskStatusUpdateEvent;
import io.github.vishalmysore.a2a.domain.TextPart;
import io.github.vishalmysore.a2a.server.A2ATaskController;
import io.github.vishalmysore.a2a.server.FileProcessingInfo;
import io.github.vishalmysore.a2a.server.SSEEmitterCallback;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class DyanamicTaskContoller
implements A2ATaskController {
    private static final Logger log = Logger.getLogger(DyanamicTaskContoller.class.getName());
    public static final String MESSAGE = "message";
    protected final Map<String, Task> tasks = new ConcurrentHashMap<String, Task>();
    private final Map<String, SseEmitter> emitters = new ConcurrentHashMap<String, SseEmitter>();
    private final ExecutorService nonBlockingService = Executors.newCachedThreadPool();
    protected AIProcessor baseProcessor = new GeminiV2ActionProcessor();
    protected PromptTransformer promptTransformer = new GeminiV2PromptTransformer();
    private BaseScriptProcessor scriptProcessor;
    private JsonUtils utils = new JsonUtils();
    ObjectMapper objectMapper = new ObjectMapper();

    protected PromptTransformer getPromptTransformer() {
        return this.promptTransformer;
    }

    public DyanamicTaskContoller() {
        this.init();
    }

    @PostConstruct
    public void initOptionalProcessors() {
        this.scriptProcessor = new ScriptProcessor();
    }

    public BaseScriptProcessor getScriptProcessor() {
        return this.scriptProcessor;
    }

    public void init() {
        this.baseProcessor = PredictionLoader.getInstance().createOrGetAIProcessor();
    }

    @Override
    public AIProcessor getBaseProcessor() {
        return this.baseProcessor;
    }

    @Override
    public SendTaskResponse sendTask(TaskSendParams taskSendParams, ActionCallback actionCallback, boolean isAsync) {
        Task task;
        String taskId = taskSendParams.getId();
        if (this.tasks.containsKey(taskId)) {
            task = this.tasks.get(taskId);
            List<Message> history = task.getHistory();
            if (history == null) {
                history = new ArrayList<Message>();
            }
            ArrayList<Message> mutableHistory = new ArrayList<Message>(history);
            mutableHistory.add(taskSendParams.getMessage());
            task.setHistory(mutableHistory);
        } else {
            task = new Task();
            task.setId(taskId);
            String sessionId = taskSendParams.getSessionId();
            if (sessionId == null || sessionId.isEmpty()) {
                sessionId = UUID.randomUUID().toString();
            }
            task.setSessionId(sessionId);
            task.setDetailedAndMessage(TaskState.SUBMITTED, " Your Task with id " + taskId + " is submitted");
            task.setHistory(new ArrayList<Message>(List.of(taskSendParams.getMessage())));
            this.tasks.put(taskId, task);
        }
        this.processTaskLogicForSyncndAsync(taskSendParams, actionCallback, isAsync, task, taskId);
        SendTaskResponse response = new SendTaskResponse();
        response.setId(taskId);
        response.setResult(task);
        return response;
    }

    protected void processTaskLogicForSyncndAsync(TaskSendParams taskSendParams, ActionCallback actionCallback, boolean isAsync, Task task, String taskId) {
        if (isAsync) {
            this.nonBlockingService.execute(() -> this.processTaskLogic(taskSendParams, task, taskId, actionCallback));
        } else {
            this.processTaskLogic(taskSendParams, task, taskId, actionCallback);
        }
    }

    protected void processTaskLogic(TaskSendParams taskSendParams, Task task, String taskId, ActionCallback actionCallback) {
        try {
            this.processParts(taskSendParams, task, taskId, actionCallback);
        }
        catch (Exception e) {
            this.handleProcessingError(task, taskId, e);
        }
    }

    private void processParts(TaskSendParams taskSendParams, Task task, String taskId, ActionCallback actionCallback) throws AIProcessingException {
        List<Part> parts = taskSendParams.getMessage().getParts();
        if (parts == null || parts.isEmpty()) {
            return;
        }
        Part part = parts.get(0);
        if (part instanceof TextPart) {
            TextPart textPart = (TextPart)part;
            this.processTextPart(textPart, task, actionCallback);
        } else if (part instanceof FilePart) {
            this.processFileTaskLogic(taskSendParams, task, taskId, actionCallback);
        }
    }

    private void processTextPart(TextPart textPart, Task task, ActionCallback actionCallback) throws AIProcessingException {
        if (!"text".equals(textPart.getType())) {
            return;
        }
        String text = textPart.getText();
        if (actionCallback != null) {
            this.processWithCallback(text, task, actionCallback);
        } else {
            this.processWithoutCallback(text, task);
        }
    }

    private void processWithCallback(String text, Task task, ActionCallback actionCallback) throws AIProcessingException {
        actionCallback.setContext((Object)task);
        this.getBaseProcessor().processSingleAction(text, actionCallback);
    }

    private void processWithoutCallback(String text, Task task) throws AIProcessingException {
        Object obj = this.getBaseProcessor().processSingleAction(text);
        this.updateTaskWithResult(task, obj);
    }

    private void updateTaskWithResult(Task task, Object obj) {
        ArrayList currentParts = task.getStatus().getMessage().getParts();
        ArrayList<Part> partsList = new ArrayList<Part>(currentParts != null ? currentParts : new ArrayList());
        TextPart resultPart = this.createResultPart(obj);
        partsList.add(resultPart);
        task.getStatus().setState(TaskState.COMPLETED);
        task.getStatus().getMessage().setParts(partsList);
    }

    private TextPart createResultPart(Object obj) {
        TextPart resultPart = new TextPart();
        resultPart.setType("text");
        resultPart.setText(obj != null ? JsonUtils.convertObjectToJson((Object)obj) : "No result");
        return resultPart;
    }

    private void handleProcessingError(Task task, String taskId, Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        TaskStatus failedStatus = this.createFailedStatus();
        task.setStatus(failedStatus);
        log.severe("Complete stack trace:\n" + sw.toString());
        this.tasks.put(taskId, task);
    }

    private TaskStatus createFailedStatus() {
        TaskStatus failedStatus = new TaskStatus(TaskState.FAILED);
        Message errorMessage = new Message();
        errorMessage.setRole("agent");
        TextPart errorPart = new TextPart();
        errorPart.setType("text");
        errorPart.setText("Processing failed: Access Denied");
        errorMessage.setParts(List.of(errorPart));
        failedStatus.setMessage(errorMessage);
        return failedStatus;
    }

    protected void processFileTaskLogic(TaskSendParams taskSendParams, Task task, String taskId, ActionCallback actionCallback) {
        try {
            List<Part> parts = taskSendParams.getMessage().getParts();
            FilePart filePart = (FilePart)parts.get(0);
            FileContent fileInfo = filePart.getFile();
            String base64EcbodedString = fileInfo.getBytes();
            String originalString = new String(Base64.getDecoder().decode(base64EcbodedString));
            this.tasks.put(taskId, task);
            if (actionCallback != null) {
                actionCallback.setContext((Object)task);
            }
            FileProcessingInfo info = (FileProcessingInfo)this.getPromptTransformer().transformIntoPojo(originalString, FileProcessingInfo.class);
            log.info("taskId " + taskId + " file info " + info);
            Path tempFile = Files.createTempFile(task.getId() + System.currentTimeMillis() + "web_steps_", ".txt", new FileAttribute[0]);
            String fileName = tempFile.getFileName().toString();
            log.info("Created temp file: " + fileName);
            Files.write(tempFile, originalString.getBytes(), new OpenOption[0]);
            ScriptResult result = this.getScriptProcessor().process(tempFile.toAbsolutePath().toString());
            String resultString = this.objectMapper.writeValueAsString((Object)result);
            log.info(resultString);
            task.setDetailedAndMessage(TaskState.COMPLETED, resultString);
            Path archiveDir = Paths.get("archive", new String[0]);
            Files.createDirectories(archiveDir, new FileAttribute[0]);
            Files.move(tempFile, archiveDir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
            log.info("Moved file to archive: " + fileName);
        }
        catch (AIProcessingException | IOException e) {
            log.warning(e.getMessage());
        }
    }

    @Override
    public ResponseEntity<Task> getTask(@RequestParam String id, @RequestParam(defaultValue="0") int historyLength) {
        Task task = this.tasks.get(id);
        if (task == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Task not found");
        }
        if (historyLength == 0) {
            return ResponseEntity.ok((Object)task);
        }
        Task taskWithHistory = new Task();
        taskWithHistory.setId(task.getId());
        taskWithHistory.setSessionId(task.getSessionId());
        taskWithHistory.setStatus(task.getStatus());
        taskWithHistory.setArtifacts(task.getArtifacts());
        List<Message> history = task.getHistory();
        if (history != null) {
            int start = Math.max(0, history.size() - historyLength);
            taskWithHistory.setHistory(history.subList(start, history.size()));
        }
        return ResponseEntity.ok((Object)taskWithHistory);
    }

    public ResponseEntity<Task> cancelTask(@RequestBody Map<String, String> body) {
        String id = body.get("id");
        Task task = this.tasks.get(id);
        if (task == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Task not found");
        }
        task.setStatus(new TaskStatus("canceled"));
        this.tasks.put(id, task);
        return ResponseEntity.ok((Object)task);
    }

    @Override
    public String setTaskPushNotification(TaskSetPushNotificationParams params) {
        Task task = this.tasks.get(params.getTaskId());
        if (task == null) {
            throw new IllegalArgumentException("Task not found");
        }
        task.setPushNotificationUrl(params.getPushNotificationUrl());
        return "Push notification URL set successfully!";
    }

    @Override
    public String resubscribeToTask(TaskResubscriptionParams params) {
        Task task = this.tasks.get(params.getTaskId());
        if (task == null) {
            throw new IllegalArgumentException("Task not found");
        }
        task.setSubscribed(true);
        task.setSubscriptionDateNow(new Date());
        return "Task resubscribed successfully!";
    }

    @Override
    public String cancelTask(String taskId) {
        Task task = this.tasks.get(taskId);
        if (task == null) {
            throw new IllegalArgumentException("Task not found");
        }
        task.setCancelled(true);
        this.tasks.remove(taskId);
        return "Task cancelled successfully!";
    }

    @Override
    public String getTaskPushNotification(TaskGetPushNotificationParams params) {
        Task task = this.tasks.get(params.getTaskId());
        if (task == null) {
            throw new IllegalArgumentException("Task not found");
        }
        return task.getPushNotificationUrl();
    }

    public ResponseEntity<TaskPushNotificationConfig> setTaskPushNotificationConfig(@RequestBody TaskPushNotificationConfigRequest request) {
        String id = request.getId();
        Task task = this.tasks.get(id);
        if (task == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Task not found");
        }
        task.setPushNotificationConfig(request.getPushNotificationConfig());
        this.tasks.put(id, task);
        return ResponseEntity.ok((Object)request.getPushNotificationConfig());
    }

    public ResponseEntity<TaskPushNotificationConfig> getTaskPushNotificationConfig(@RequestParam String id) {
        Task task = this.tasks.get(id);
        if (task == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Task not found");
        }
        TaskPushNotificationConfig config = task.getPushNotificationConfig();
        if (config == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)config);
    }

    public void sendSseEvent(String taskId, Object event) {
        SseEmitter emitter = this.emitters.get(taskId);
        if (emitter != null) {
            try {
                emitter.send(SseEmitter.event().name(MESSAGE).data(event));
            }
            catch (IOException e) {
                this.emitters.remove(taskId);
                emitter.completeWithError((Throwable)e);
                log.severe("Error sending SSE event: " + e.getMessage());
            }
        }
    }

    @Override
    public SseEmitter sendSubscribeTask(TaskSendSubscribeParams params) {
        String id = params.getId();
        SseEmitter emitter = this.createEmitter(id);
        Task task = this.getOrCreateTask(params);
        this.processTaskAsync(task, emitter, id, params.getMessage());
        return emitter;
    }

    private SseEmitter createEmitter(String id) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        this.emitters.put(id, emitter);
        emitter.onCompletion(() -> {
            this.emitters.remove(id);
            log.info("Client disconnected for task: " + id);
        });
        emitter.onError(throwable -> {
            this.emitters.remove(id);
            log.info("Error occurred for task " + id + ": " + throwable.getMessage());
        });
        emitter.onTimeout(() -> {
            this.emitters.remove(id);
            emitter.complete();
            log.info("Timeout occurred for task: " + id);
        });
        return emitter;
    }

    private Task getOrCreateTask(TaskSendSubscribeParams params) {
        String taskId = params.getId();
        Message message = params.getMessage();
        Task task = this.tasks.get(taskId);
        if (task != null) {
            ArrayList<Message> history = task.getHistory() != null ? new ArrayList<Message>(task.getHistory()) : new ArrayList();
            history.add(message);
            task.setHistory(history);
            return task;
        }
        task = new Task();
        task.setId(taskId);
        String sessionId = Optional.ofNullable(params.getSessionId()).filter(s -> !s.isEmpty()).orElse(UUID.randomUUID().toString());
        task.setSessionId(sessionId);
        task.setStatus(new TaskStatus(TaskState.SUBMITTED));
        task.setHistory(List.of(message));
        this.tasks.put(taskId, task);
        return task;
    }

    private void processTaskAsync(Task task, SseEmitter emitter, String id, Message message) {
        this.nonBlockingService.execute(() -> {
            try {
                TextPart textPart;
                Part part;
                List<Part> parts = message.getParts();
                if (parts != null && !parts.isEmpty() && (part = parts.get(0)) instanceof TextPart && "text".equals((textPart = (TextPart)part).getType())) {
                    String text = textPart.getText();
                    SSEEmitterCallback callback = new SSEEmitterCallback(id, emitter);
                    callback.setContext(task);
                    this.getBaseProcessor().processSingleAction(text, (ActionCallback)callback);
                }
            }
            catch (Exception e) {
                emitter.completeWithError((Throwable)e);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public SseEmitter resubscribe(String id) {
        emitter = new SseEmitter(Long.valueOf(0x7FFFFFFFFFFFFFFFL));
        this.emitters.put(id, emitter);
        task = this.tasks.get(id);
        if (task != null) {
            try {
                emitter.send(SseEmitter.event().name("message").data((Object)new TaskStatusUpdateEvent(id, task.getStatus(), false)));
                if (task.getArtifacts() == null) ** GOTO lbl27
                for (Artifact artifact : task.getArtifacts()) {
                    emitter.send(SseEmitter.event().name("message").data((Object)new TaskArtifactUpdateEvent(id, artifact)));
                }
            }
            catch (IOException e) {
                this.emitters.remove(id);
                emitter.completeWithError((Throwable)e);
                DyanamicTaskContoller.log.severe("Error re-subscribing" + e.getMessage());
            }
        } else {
            try {
                emitter.send(SseEmitter.event().name("message").data((Object)"Task does not exist"));
                emitter.complete();
                this.emitters.remove(id);
            }
            catch (IOException e) {
                DyanamicTaskContoller.log.severe("Error sending task message" + e.getMessage());
            }
        }
lbl27:
        // 5 sources

        emitter.onCompletion((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$resubscribe$6(java.lang.String ), ()V)((DyanamicTaskContoller)this, (String)id));
        emitter.onError((Consumer<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$resubscribe$7(java.lang.String java.lang.Throwable ), (Ljava/lang/Throwable;)V)((DyanamicTaskContoller)this, (String)id));
        emitter.onTimeout((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$resubscribe$8(java.lang.String org.springframework.web.servlet.mvc.method.annotation.SseEmitter ), ()V)((DyanamicTaskContoller)this, (String)id, (SseEmitter)emitter));
        return emitter;
    }

    public JsonUtils getUtils() {
        return this.utils;
    }

    public void setUtils(JsonUtils utils) {
        this.utils = utils;
    }

    public ExecutorService getNonBlockingService() {
        return this.nonBlockingService;
    }

    private /* synthetic */ void lambda$resubscribe$8(String id, SseEmitter emitter) {
        this.emitters.remove(id);
        emitter.complete();
        log.severe("Timeout on resubscribe for task: " + id);
    }

    private /* synthetic */ void lambda$resubscribe$7(String id, Throwable throwable) {
        this.emitters.remove(id);
        log.severe("Error on resubscribe for task " + id + ": " + throwable.getMessage());
    }

    private /* synthetic */ void lambda$resubscribe$6(String id) {
        this.emitters.remove(id);
        log.severe("Client disconnected on resubscribe: " + id);
    }
}

