/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.vishalmysore.common.AgentInfo;
import io.github.vishalmysore.common.CommonClientRequest;
import io.github.vishalmysore.common.CommonClientResponse;
import io.github.vishalmysore.mcp.domain.MCPGenericResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public interface Agent {
    public void connect(String var1, String var2);

    default public void connect(String url) {
        this.connect(url, null);
    }

    public void disconnect();

    public AgentInfo getInfo();

    public boolean isConnected();

    public URL getServerUrl();

    public ObjectMapper getMapper();

    public String getType();

    default public <T> T invokeRPC(CommonClientRequest request, Class<T> responseType) {
        if (!this.isConnected() || this.getServerUrl() == null) {
            throw new IllegalStateException("Agent not connected");
        }
        return this.getRemoteData(request, responseType);
    }

    default public <T> MCPGenericResponse<T> getRemoteData(CommonClientRequest request, TypeReference<MCPGenericResponse<T>> typeRef) {
        MCPGenericResponse mCPGenericResponse;
        HttpURLConnection conn = (HttpURLConnection)this.getServerUrl().openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json");
        conn.setDoOutput(true);
        String jsonRequest = this.getMapper().writeValueAsString((Object)request);
        try (OutputStream os = conn.getOutputStream();){
            os.write(jsonRequest.getBytes(StandardCharsets.UTF_8));
        }
        if (conn.getResponseCode() >= 400) {
            throw new RuntimeException("Request failed: HTTP " + conn.getResponseCode());
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
        try {
            String response = br.lines().collect(Collectors.joining());
            mCPGenericResponse = (MCPGenericResponse)this.getMapper().readValue(response, typeRef);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Request failed - Probably sever is down " + this.getInfo(), e);
            }
        }
        br.close();
        return mCPGenericResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T getRemoteData(CommonClientRequest request, Class<T> responseType) {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.getServerUrl().openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            String jsonRequest = this.getMapper().writeValueAsString((Object)request);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = jsonRequest.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            if (conn.getResponseCode() >= 400) {
                throw new RuntimeException("Request failed: HTTP " + conn.getResponseCode());
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String response = br.lines().collect(Collectors.joining());
                Object object = this.getMapper().readValue(response, responseType);
                return (T)object;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Request failed", e);
        }
    }

    public CommonClientResponse remoteMethodCall(String var1);

    public CommonClientResponse remoteMethodCall(String var1, String var2);
}

