/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.common;

import io.github.vishalmysore.common.Agent;
import io.github.vishalmysore.common.AgentInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ClientRegistryForAgents {
    private static final Logger log = Logger.getLogger(ClientRegistryForAgents.class.getName());
    private Map<AgentInfo, Agent> agents = new HashMap<AgentInfo, Agent>();

    public boolean addAgent(Agent agent) {
        if (agent == null) {
            log.warning("Attempted to add null agent to registry");
            return false;
        }
        AgentInfo info = agent.getInfo();
        if (info == null) {
            log.warning("Agent has null info, cannot add to registry");
            return false;
        }
        this.agents.put(info, agent);
        log.info("Added agent: " + info);
        return true;
    }

    public String getAgentsInfo() {
        if (this.agents.isEmpty()) {
            return "";
        }
        return this.agents.keySet().stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public Agent retrieveAgent(AgentInfo info) {
        if (info == null) {
            log.warning("Attempted to retrieve agent with null info");
            return null;
        }
        return this.agents.get(info);
    }

    public int getAgentCount() {
        return this.agents.size();
    }

    public boolean hasAgent(AgentInfo info) {
        if (info == null) {
            return false;
        }
        return this.agents.containsKey(info);
    }
}

