/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.debug;

import com.t4a.JsonUtils;
import com.t4a.api.AIAction;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.api.GroupInfo;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.PromptTransformer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DebugCurlCommands {
    private static final Logger log = Logger.getLogger(DebugCurlCommands.class.getName());

    public static Map<String, String> getCurlCommands(String[] args) throws AIProcessingException {
        Map groupActions = PredictionLoader.getInstance().getActionGroupList().getGroupActions();
        PromptTransformer transformer = PredictionLoader.getInstance().createOrGetPromptTransformer();
        Map predictions = PredictionLoader.getInstance().getPredictions();
        JsonUtils jsonUtils = new JsonUtils();
        String textPrmt = "your prompt goes here";
        HashMap<String, String> curlCommands = new HashMap<String, String>();
        for (Map.Entry entry : groupActions.entrySet()) {
            String[] actionNames;
            GroupInfo group = (GroupInfo)entry.getKey();
            for (String actionName : actionNames = ((String)entry.getValue()).split(",")) {
                AIAction action = (AIAction)predictions.get(actionName.trim());
                if (!(action instanceof GenericJavaMethodAction)) continue;
                Method m = ((GenericJavaMethodAction)action).getActionMethod();
                String methodName = m.getName();
                String jsonParam = ((GenericJavaMethodAction)action).getActionParameters();
                String json = jsonUtils.createJson("textPromptToTestThisMethod").toString();
                json = transformer.transformIntoJson(json, "This is the method name: " + methodName + " and the parameters are: " + jsonParam + " build a text prompt for this method with parameter values in english");
                textPrmt = jsonUtils.getFieldValue(json, "textPromptToTestThisMethod");
                textPrmt = textPrmt.replaceAll("[\"']", "");
                String curlMCP = "curl  \\\n  -H \"Content-Type: application/json\" \\\n  -d '{\n    \"jsonrpc\": \"2.0\",\n    \"method\": \"tools/call\",\n    \"params\": {\n      \"name\": \"" + methodName + "\",\n      \"arguments\": {\n        \"provideAllValuesInPlainEnglish\": {\n          \"value\": \"" + textPrmt + "\"\n        }\n      }\n    },\n    \"id\": 25\n  }' http://localhost:7860";
                String curlA2A = "curl -v \\\n  -H \"Content-Type: application/json\" \\\n  -d '{\n    \"jsonrpc\": \"2.0\",\n    \"method\": \"tasks/send\",\n    \"params\": {\n      \"id\": \"999789\",\n      \"sessionId\": \"sdf44555\",\n      \"message\": {\n        \"role\": \"user\",\n        \"parts\": [\n          {\n            \"type\": \"text\",\n            \"text\": \"" + textPrmt + "\",\n            \"metadata\": null\n          }\n        ]\n      }\n    }\n  }' http://localhost:7860";
                log.info("MCP Curl Command for " + methodName + ":\n" + curlMCP);
                curlCommands.put("MCP_" + methodName, curlMCP);
                log.info("A2A Curl Command for " + methodName + ":\n" + curlA2A);
                curlCommands.put("A2A_" + methodName, curlA2A);
            }
        }
        curlCommands.put("agent-Card", "curl http://localhost:7860/.well-known/agent.json");
        curlCommands.put("tool-list", "curl -H \"Content-Type: application/json\" -d '{\"jsonrpc\":\"2.0\",\"method\":\"tools/list\",\"params\":{},\"id\":9}' http://localhost:7860");
        return curlCommands;
    }
}

