/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.mcp.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.t4a.JsonUtils;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.common.Agent;
import io.github.vishalmysore.common.AgentInfo;
import io.github.vishalmysore.common.CommonClientRequest;
import io.github.vishalmysore.common.CommonClientResponse;
import io.github.vishalmysore.mcp.domain.CallToolRequest;
import io.github.vishalmysore.mcp.domain.CallToolResult;
import io.github.vishalmysore.mcp.domain.ListToolsRequest;
import io.github.vishalmysore.mcp.domain.ListToolsResult;
import io.github.vishalmysore.mcp.domain.MCPGenericResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class MCPAgent
implements Agent {
    private static final Logger log = Logger.getLogger(MCPAgent.class.getName());
    private URL serverUrl;
    private ListToolsResult toolsResult;
    private JsonUtils utils = new JsonUtils();
    private String availableTools = "[]";
    private String type = "mcp";
    private ObjectMapper mapper;

    public MCPAgent() {
        this(null);
    }

    public MCPAgent(URL serverUrl) {
        this.serverUrl = serverUrl;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public CommonClientResponse remoteMethodCall(String query) {
        PromptTransformer processor = PredictionLoader.getInstance().createOrGetPromptTransformer();
        String toolNameJson = null;
        try {
            toolNameJson = processor.transformIntoJson("{toolName:''}", query);
        }
        catch (AIProcessingException e) {
            log.severe("Error processing query: " + e.getMessage());
        }
        toolNameJson = this.utils.extractJson(toolNameJson);
        JsonNode root = null;
        try {
            root = this.mapper.readTree(toolNameJson);
        }
        catch (JsonProcessingException e) {
            log.severe("Error processing query: " + e.getMessage());
        }
        JsonNode idNode = root.get("toolName");
        if (idNode == null || idNode.asText().trim().isEmpty()) {
            log.warning("No valid agent ID found in JSON");
            return null;
        }
        String methodName = idNode.asText();
        return this.remoteMethodCall(methodName, query);
    }

    @Override
    public CommonClientResponse remoteMethodCall(String methodName, String query) {
        CallToolRequest request = new CallToolRequest();
        request.putArgument("provideAllValuesInPlainEnglish", query);
        request.putArgument("name", methodName);
        return this.callTool(request);
    }

    @Override
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void connect(String url, String token) {
        try {
            this.serverUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            log.severe("Invalid server URL: " + e.getMessage());
        }
        ListToolsRequest request = new ListToolsRequest();
        MCPGenericResponse<ListToolsResult> response = this.getRemoteData((CommonClientRequest)request, new TypeReference<MCPGenericResponse<ListToolsResult>>(this){});
        this.toolsResult = response.getResult();
        if (this.toolsResult != null) {
            this.availableTools = this.toolsResult.retrieveToolList();
        }
    }

    @Override
    public void disconnect() {
        log.info("Disconnecting MCPAgent");
    }

    @Override
    public AgentInfo getInfo() {
        return this.toolsResult;
    }

    @Override
    public boolean isConnected() {
        return this.serverUrl != null && this.toolsResult != null;
    }

    @Override
    public URL getServerUrl() {
        return this.serverUrl;
    }

    public CallToolResult callTool(CallToolRequest request) {
        MCPGenericResponse<CallToolResult> response = this.getRemoteData((CommonClientRequest)request, new TypeReference<MCPGenericResponse<CallToolResult>>(this){});
        return response.getResult();
    }
}

