/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.mcp.server;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.t4a.JsonUtils;
import com.t4a.api.AIAction;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.api.GroupInfo;
import com.t4a.detect.ActionCallback;
import com.t4a.detect.ExplainDecision;
import com.t4a.detect.HumanInLoop;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.GeminiV2ActionProcessor;
import com.t4a.processor.LoggingHumanDecision;
import com.t4a.processor.LogginggExplainDecision;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.common.MCPActionCallback;
import io.github.vishalmysore.mcp.domain.CallToolResult;
import io.github.vishalmysore.mcp.domain.Content;
import io.github.vishalmysore.mcp.domain.JSONRPCResponse;
import io.github.vishalmysore.mcp.domain.ListPromptsResult;
import io.github.vishalmysore.mcp.domain.ListResourcesResult;
import io.github.vishalmysore.mcp.domain.ListToolsResult;
import io.github.vishalmysore.mcp.domain.Prompt;
import io.github.vishalmysore.mcp.domain.Resource;
import io.github.vishalmysore.mcp.domain.TextContent;
import io.github.vishalmysore.mcp.domain.Tool;
import io.github.vishalmysore.mcp.domain.ToolAnnotations;
import io.github.vishalmysore.mcp.domain.ToolCallRequest;
import io.github.vishalmysore.mcp.domain.ToolInputSchema;
import io.github.vishalmysore.mcp.domain.ToolParameter;
import io.github.vishalmysore.mcp.domain.ToolParameters;
import io.github.vishalmysore.mcp.domain.ToolPropertySchema;
import jakarta.annotation.PostConstruct;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;

public class MCPToolsController {
    private static final Logger log = Logger.getLogger(MCPToolsController.class.getName());
    private ListToolsResult toolsResult;
    private ListResourcesResult resourcesResult;
    private ListPromptsResult promptsResult;
    private List<Prompt> prompts;
    private List<Resource> resources;
    private AIProcessor baseProcessor = new GeminiV2ActionProcessor();
    private PromptTransformer promptTransformer;
    private JsonUtils utils = new JsonUtils();
    private String serverName = "MCP Tools Server";
    private String version = "1.0.0";
    private String protocolVersion = "2024-11-05";

    public AIProcessor getBaseProcessor() {
        return this.baseProcessor;
    }

    @PostConstruct
    public void init() {
        this.baseProcessor = PredictionLoader.getInstance().createOrGetAIProcessor();
        this.promptTransformer = PredictionLoader.getInstance().createOrGetPromptTransformer();
        Map groupActions = PredictionLoader.getInstance().getActionGroupList().getGroupActions();
        List<Tool> tools = this.convertGroupActionsToTools(groupActions);
        ListToolsResult newToolsResult = new ListToolsResult();
        newToolsResult.setTools(tools);
        this.storeListToolsResult(newToolsResult);
        this.storeListReources(this.resources);
        this.storeListPrompts(this.prompts);
        this.setProperties();
    }

    public void setProperties() {
        String protocolVersion;
        String version;
        Map tools4AIProperties = PredictionLoader.getInstance().getTools4AIProperties();
        String serverName = (String)tools4AIProperties.get("mcp.tools.servername");
        if (serverName != null && !serverName.trim().isEmpty()) {
            this.setServerName(serverName);
        }
        if ((version = (String)tools4AIProperties.get("mcp.tools.version")) != null && !version.trim().isEmpty()) {
            this.setVersion(version);
        }
        if ((protocolVersion = (String)tools4AIProperties.get("mcp.tools.protocolversion")) != null && !protocolVersion.trim().isEmpty()) {
            this.setProtocolVersion(protocolVersion);
        }
    }

    public void storeListReources(List<Resource> resources) {
        this.resourcesResult = new ListResourcesResult();
        this.resourcesResult.setResources(resources);
    }

    public void storeListPrompts(List<Prompt> prompts) {
        this.promptsResult = new ListPromptsResult();
        this.promptsResult.setPrompts(prompts);
    }

    public void storeListToolsResult(ListToolsResult toolsResult) {
        this.toolsResult = toolsResult;
    }

    public void addResources(ListResourcesResult result) {
    }

    public void addPrompts(ListPromptsResult result) {
    }

    public ResponseEntity<Map<String, String>> getServerConfig() {
        return ResponseEntity.ok(Map.of("name", this.getServerName(), "version", this.getVersion()));
    }

    private boolean validateSchema(ToolInputSchema schema) {
        if (schema.getProperties() == null || schema.getRequired() == null) {
            log.severe("Schema validation failed: Missing properties or required fields.");
            return false;
        }
        return true;
    }

    public void addResource(Method method) {
        Class<?> clazz = method.getReturnType();
        if (Resource.class.isAssignableFrom(clazz)) {
            Resource r = new Resource();
            this.resources.add(r);
        }
    }

    public void addPrompt(Tool tool) {
        Prompt prompt = new Prompt();
    }

    public boolean isMethodAllowed(Method method) {
        return true;
    }

    private List<Tool> convertGroupActionsToTools(Map<GroupInfo, String> groupActions) {
        ArrayList<Tool> tools = new ArrayList<Tool>();
        Map predictions = PredictionLoader.getInstance().getPredictions();
        for (Map.Entry<GroupInfo, String> entry : groupActions.entrySet()) {
            String[] actionNames;
            GroupInfo group = entry.getKey();
            for (String actionName : actionNames = entry.getValue().split(",")) {
                GenericJavaMethodAction methodAction;
                Method m;
                AIAction action = (AIAction)predictions.get(actionName.trim());
                if (!(action instanceof GenericJavaMethodAction) || !this.isMethodAllowed(m = (methodAction = (GenericJavaMethodAction)action).getActionMethod())) continue;
                this.addResource(m);
                log.info("Processing action: " + actionName);
                Tool tool = new Tool();
                tool.setName(action.getActionName());
                tool.setDescription(action.getDescription());
                ToolParameters parameters = new ToolParameters();
                HashMap<String, ToolPropertySchema> schemaProperties = new HashMap<String, ToolPropertySchema>();
                ArrayList<String> requiredFields = new ArrayList<String>();
                String jsonStr = methodAction.getActionParameters();
                AIProcessor processor = this.getBaseProcessor();
                String aiResponse = null;
                try {
                    aiResponse = processor.query("I am giving you a json string check the parameters section and return the required fields including subfields as simple json, do not include any other commentary, control or special characters " + jsonStr);
                    aiResponse = this.utils.extractJson(aiResponse);
                    log.info(aiResponse);
                }
                catch (AIProcessingException e) {
                    throw new RuntimeException(e);
                }
                String customParam = "provideAllValuesInPlainEnglish";
                ToolParameter toolParam = new ToolParameter();
                toolParam.setType("string");
                toolParam.setDescription(aiResponse);
                parameters.getProperties().put(customParam, toolParam);
                ToolPropertySchema schema = new ToolPropertySchema();
                schema.setType("string");
                schema.setDescription(aiResponse);
                schema.setAdditionalProperties(new HashMap<String, Object>());
                schemaProperties.put(customParam, schema);
                parameters.getRequired().add(customParam);
                requiredFields.add(customParam);
                ToolInputSchema inputSchema = new ToolInputSchema();
                inputSchema.setProperties(schemaProperties);
                inputSchema.setRequired(requiredFields);
                if (!this.validateSchema(inputSchema)) {
                    log.severe("Invalid schema for tool: " + tool.getName());
                    continue;
                }
                tool.setInputSchema(inputSchema);
                ToolAnnotations toolAnnotations = null;
                try {
                    toolAnnotations = (ToolAnnotations)this.promptTransformer.transformIntoPojo("this is the tool name " + actionName + " and here are the parameterts it takes " + jsonStr + "  I want you to give name name value pair describing what this tool does so that people can indentify this tool better", ToolAnnotations.class);
                }
                catch (AIProcessingException e) {
                    log.warning(e.getMessage());
                }
                tool.setAnnotations(toolAnnotations);
                tools.add(tool);
                this.addPrompt(tool);
            }
        }
        return tools;
    }

    private String getJsonType(Class<?> type) {
        if (type == String.class) {
            return "string";
        }
        if (type == Integer.class || type == Integer.TYPE || type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE) {
            return "number";
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "boolean";
        }
        if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            return "array";
        }
        return "object";
    }

    public ResponseEntity<Map<String, List<Tool>>> listTools() {
        HashMap<String, List<Tool>> response = new HashMap<String, List<Tool>>();
        response.put("tools", this.toolsResult.getTools());
        return ResponseEntity.ok(response);
    }

    public ResponseEntity<JSONRPCResponse> callTool(@RequestBody ToolCallRequest request) {
        CallToolResult result = this.callToolWithCallback(request, new MCPActionCallback());
        log.info("Received result: " + result);
        JSONRPCResponse response = new JSONRPCResponse();
        response.setId(UUID.randomUUID().toString());
        response.setResult(result);
        return ResponseEntity.ok((Object)response);
    }

    public ResponseEntity<JSONRPCResponse> callTool(@RequestBody ToolCallRequest request, ActionCallback callback) {
        CallToolResult result = this.callToolWithCallback(request, callback);
        log.info("Received result: " + result);
        JSONRPCResponse response = new JSONRPCResponse();
        response.setId(UUID.randomUUID().toString());
        response.setResult(result);
        return ResponseEntity.ok((Object)response);
    }

    public CallToolResult callToolWithCallback(@RequestBody ToolCallRequest request, ActionCallback callback) {
        Map predictions = PredictionLoader.getInstance().getPredictions();
        AIAction action = (AIAction)predictions.get(request.getName());
        AIProcessor processor = this.getBaseProcessor();
        CallToolResult callToolResult = new CallToolResult();
        ArrayList<Content> content = new ArrayList<Content>();
        try {
            callback.setContext((Object)callToolResult);
            Object result = this.processAction(request, callback, processor, action);
            if (result != null) {
                if (result instanceof Content) {
                    content.add((Content)result);
                } else {
                    String resultStr = result.toString();
                    TextContent textContent = new TextContent();
                    textContent.setType("text");
                    textContent.setText(resultStr);
                    content.add(textContent);
                }
            } else {
                TextContent textContent = new TextContent();
                textContent.setType("text");
                textContent.setText("No result available");
                content.add(textContent);
            }
        }
        catch (AIProcessingException e) {
            TextContent textContent = new TextContent();
            textContent.setType("text");
            content.add(textContent);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            textContent.setText("Technical issue occurred while processing the request: " + sw.toString());
            log.severe(sw.toString());
        }
        callToolResult.setContent(content);
        return callToolResult;
    }

    private boolean isBase64(String str) {
        try {
            Base64.getDecoder().decode(str);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected Object processAction(ToolCallRequest request, ActionCallback callback, AIProcessor processor, AIAction action) throws AIProcessingException {
        Object result = processor.processSingleAction(request.toString(), action, (HumanInLoop)new LoggingHumanDecision(), (ExplainDecision)new LogginggExplainDecision(), callback);
        return result;
    }

    private Object[] buildMethodArguments(Method method, String jsonStr) throws Exception {
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode root = objectMapper.readTree(jsonStr);
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            JsonNode paramJson = root.get(param.getName());
            args[i] = paramJson != null ? objectMapper.treeToValue((TreeNode)paramJson, param.getType()) : null;
        }
        return args;
    }

    public ListToolsResult getToolsResult() {
        return this.toolsResult;
    }

    public ListResourcesResult getResourcesResult() {
        return this.resourcesResult;
    }

    public ListPromptsResult getPromptsResult() {
        return this.promptsResult;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }
}

