/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.mesh;

import com.t4a.JsonUtils;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.a2a.client.A2AAgent;
import io.github.vishalmysore.common.Agent;
import io.github.vishalmysore.common.AgentIdentity;
import io.github.vishalmysore.common.AgentInfo;
import io.github.vishalmysore.common.CommonClientResponse;
import io.github.vishalmysore.mcp.client.MCPAgent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AgentCatalog {
    private static final Logger log = Logger.getLogger(AgentCatalog.class.getName());
    private Map<AgentIdentity, Agent> agents;
    private PromptTransformer promptTransformer;
    JsonUtils jsonUtils = new JsonUtils();

    public AgentCatalog() {
        log.info("Initializing AgentCatalog");
        this.agents = new HashMap<AgentIdentity, Agent>();
        this.promptTransformer = PredictionLoader.getInstance().createOrGetPromptTransformer();
    }

    public Agent addAgent(String url) {
        Agent a2agent = null;
        try {
            a2agent = new A2AAgent();
            a2agent.connect(url);
        }
        catch (Exception e) {
            log.warning("Failed to connect to A2A agent at " + url + ": " + e.getMessage() + " will add as mcp agent");
        }
        if (a2agent == null || !a2agent.isConnected()) {
            try {
                a2agent = new MCPAgent();
                a2agent.connect(url);
            }
            catch (Exception e) {
                log.warning("Failed to connect to MCP agent at " + url + ": " + e.getMessage());
            }
        }
        if (a2agent == null || !a2agent.isConnected()) {
            log.warning("Not able to Connect to agent at " + url);
        } else {
            AgentIdentity a2agentIdentity = AgentIdentity.builder().info(a2agent.getInfo()).url(url).build();
            this.agents.put(a2agentIdentity, a2agent);
            log.info("Connected to agent at " + url + " with info: " + a2agent.getInfo());
        }
        return a2agent;
    }

    public String getAgentsInfo() {
        if (this.agents.isEmpty()) {
            return "";
        }
        return this.agents.keySet().stream().map(AgentIdentity::toString).collect(Collectors.joining(", "));
    }

    public boolean addAgent(Agent agent) {
        if (agent == null) {
            log.warning("Attempted to add null agent");
            return false;
        }
        AgentInfo info = agent.getInfo();
        if (info == null) {
            log.warning("Agent has null info, cannot add to catalog");
            return false;
        }
        AgentIdentity a2agentIdentity = AgentIdentity.builder().info(agent.getInfo()).build();
        this.agents.put(a2agentIdentity, agent);
        log.info("Added agent with info: " + info);
        return true;
    }

    public Agent retrieveAgent(AgentInfo info) {
        if (info == null) {
            log.warning("Attempted to retrieve agent with null info");
            return null;
        }
        return this.agents.entrySet().stream().filter(entry -> info.equals(((AgentIdentity)entry.getKey()).getAllTheCapabilitiesOfTheAgent())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public Agent retrieveAgentByIdentity(AgentIdentity identity) {
        if (identity == null) {
            log.warning("Attempted to retrieve agent with null identity");
            return null;
        }
        return this.agents.get(identity);
    }

    public CommonClientResponse processQuery(String query) {
        if (query == null || query.trim().isEmpty()) {
            log.warning("Empty or null query provided");
            return null;
        }
        String identiy = null;
        String uniqueIdStr = "agentUniqueIDTobeUsedToIdentifyTheAgent";
        try {
            identiy = this.promptTransformer.transformIntoJson(this.jsonUtils.createJson(uniqueIdStr).toString(), " this is user prompt { " + query + "}  I am trying to find which agent can handle it from this info {" + this.getAgentsInfo() + "}");
        }
        catch (AIProcessingException e) {
            log.severe("Error transforming query into JSON: " + e.getMessage());
        }
        log.info("Agent Identity: " + identiy);
        Agent agent = this.retrieveAgentByID(this.jsonUtils.getFieldValue(identiy, uniqueIdStr));
        log.info("Retrieved Agent: " + agent.getType());
        CommonClientResponse response = agent.remoteMethodCall(query);
        return response;
    }

    public Agent retrieveAgentByID(String agentId) {
        try {
            log.info("Retrieving agent by ID: " + agentId);
            return this.agents.entrySet().stream().filter(entry -> agentId.equals(((AgentIdentity)entry.getKey()).getAgentUniqueIDTobeUsedToIdentifyTheAgent())).map(Map.Entry::getValue).findFirst().orElse(null);
        }
        catch (Exception e) {
            log.warning("Error parsing JSON or retrieving agent: " + e.getMessage());
            return null;
        }
    }

    public Map<AgentIdentity, Agent> getAgents() {
        return this.agents;
    }

    public PromptTransformer getPromptTransformer() {
        return this.promptTransformer;
    }

    public JsonUtils getJsonUtils() {
        return this.jsonUtils;
    }

    public void setAgents(Map<AgentIdentity, Agent> agents) {
        this.agents = agents;
    }

    public void setPromptTransformer(PromptTransformer promptTransformer) {
        this.promptTransformer = promptTransformer;
    }

    public void setJsonUtils(JsonUtils jsonUtils) {
        this.jsonUtils = jsonUtils;
    }
}

