/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.tools4ai;

import java.util.logging.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class SecureEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger log = Logger.getLogger(SecureEnvironmentPostProcessor.class.getName());

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        boolean secureMode = this.checkSecureMode();
        log.info("Secure mode enabled found jar on classppath: " + secureMode);
        if (secureMode) {
            environment.getSystemProperties().put("agent.secure.enabled", "true");
        }
    }

    private boolean checkSecureMode() {
        try {
            Class.forName("io.github.vishalmysore.secure.EnableAgentSecurity");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

