/*
 * Decompiled with CFR 0.152.
 */
package com.t4a;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.t4a.annotations.ListType;
import com.t4a.annotations.MapKeyType;
import com.t4a.annotations.MapValueType;
import com.t4a.annotations.Prompt;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final String FIELDTYPE = "fieldType";
    private static final String DATEFORMAT = "dateFormat";
    private static final String FIELDS = "fields";
    private static final String FIELDNAME = "fieldName";
    private static final String FIELDVALUE_JSON = "fieldValue";
    private static final String CLASSNAME_JSON = "className";
    public static final String IF_YOU_FIND_MORE_THAN_1 = "If you find more than 1 ";
    public static final String ADD_IT_AS_ANOTHER_OBJECT_INSIDE_FIELD_VALUE = " add it as another object inside fieldValue";

    public String fetchGroupName(String groupJson) {
        groupJson = this.extractJson(groupJson);
        JSONObject obj = new JSONObject(groupJson);
        return obj.optString("groupName", null);
    }

    public String fetchActionName(@NotNull String groupJson) {
        if (groupJson.trim().isEmpty()) {
            throw new IllegalArgumentException("JSON string cannot be empty");
        }
        JSONObject obj = new JSONObject(groupJson = this.extractJson(groupJson));
        String groupName = obj.optString("actionName", null);
        if (groupName == null) {
            groupName = groupJson;
        }
        return groupName;
    }

    public String extractJson(String jsonString) {
        int startIndex = jsonString.indexOf(123);
        int endIndex = jsonString.lastIndexOf(125);
        if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
            return jsonString.substring(startIndex, endIndex + 1);
        }
        return jsonString;
    }

    public String convertClassObjectToJsonString(Schema<?> classSchema) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        this.processProperties(rootNode, classSchema.getProperties());
        return rootNode.toString();
    }

    public Object populateClassFromJson(String json) throws Exception {
        json = this.extractJson(json);
        JSONObject jsonObject = new JSONObject(json);
        return this.populateObject(jsonObject, null);
    }

    public void buildMapFromJsonArray(JSONArray fieldsArray, Map<String, String> map) {
        for (int i = 0; i < fieldsArray.length(); ++i) {
            JSONObject jsonObject = fieldsArray.getJSONObject(i);
            String name = jsonObject.getString("key");
            String value = jsonObject.getString("value");
            map.put(name, value);
        }
    }

    public void buildListFromJsonArray(JSONArray fieldsArray, List<Object> list) {
        for (int i = 0; i < fieldsArray.length(); ++i) {
            list.add(fieldsArray.getJSONObject(i).get(FIELDVALUE_JSON));
        }
    }

    public Object populateObject(JSONObject jsonObject, JSONObject parentObject) throws Exception {
        String className = jsonObject.optString(CLASSNAME_JSON, null);
        if (className == null && parentObject != null) {
            className = parentObject.optString(CLASSNAME_JSON, null);
        }
        if (className == null) {
            throw new IllegalArgumentException("Class name is missing in the JSON object");
        }
        Class<?> clazz = Class.forName(className);
        return this.populateObject(clazz, jsonObject);
    }

    public Object populateObject(Class<?> clazz, JSONObject jsonObject) {
        Cloneable instance = null;
        try {
            if (clazz.getName().equalsIgnoreCase("java.util.Map")) {
                instance = new HashMap();
                JSONArray fieldsArray = jsonObject.getJSONArray(FIELDS);
                this.buildMapFromJsonArray(fieldsArray, (Map)((Object)instance));
                return instance;
            }
            if (clazz.getName().equalsIgnoreCase("java.util.List")) {
                instance = new ArrayList();
                JSONArray fieldsArray = jsonObject.getJSONArray(FIELDS);
                this.buildListFromJsonArray(fieldsArray, (List)((Object)instance));
                return instance;
            }
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JSONArray fields = jsonObject.getJSONArray(FIELDS);
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject fieldObj = fields.getJSONObject(i);
                String fieldName = fieldObj.getString(FIELDNAME);
                String fieldType = fieldObj.getString(FIELDTYPE);
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                if ("String".equalsIgnoreCase(fieldType)) {
                    field.set(instance, fieldObj.optString(FIELDVALUE_JSON));
                    continue;
                }
                if (fieldType.endsWith("[]")) {
                    Object[] array;
                    JSONArray jsonArray = fieldObj.optJSONArray(FIELDVALUE_JSON);
                    if (jsonArray == null) continue;
                    String componentType = fieldType.substring(0, fieldType.indexOf(91));
                    if ("int".equalsIgnoreCase(componentType)) {
                        array = new int[jsonArray.length()];
                        for (int j = 0; j < jsonArray.length(); ++j) {
                            Array.setInt(array, j, jsonArray.optInt(j));
                        }
                    } else if ("double".equalsIgnoreCase(componentType)) {
                        array = new double[jsonArray.length()];
                        for (int j = 0; j < jsonArray.length(); ++j) {
                            Array.setDouble(array, j, jsonArray.optDouble(j));
                        }
                    } else if ("long".equalsIgnoreCase(componentType)) {
                        array = new long[jsonArray.length()];
                        for (int j = 0; j < jsonArray.length(); ++j) {
                            Array.setLong(array, j, jsonArray.optLong(j));
                        }
                    } else if ("boolean".equalsIgnoreCase(componentType)) {
                        array = new boolean[jsonArray.length()];
                        for (int j = 0; j < jsonArray.length(); ++j) {
                            Array.setBoolean(array, j, jsonArray.optBoolean(j));
                        }
                    } else if ("String".equalsIgnoreCase(componentType)) {
                        array = new String[jsonArray.length()];
                        for (int j = 0; j < jsonArray.length(); ++j) {
                            Array.set(array, j, jsonArray.optString(j));
                        }
                    } else if ("Date".equalsIgnoreCase(componentType)) {
                        array = new Date[jsonArray.length()];
                        for (int j = 0; j < jsonArray.length(); ++j) {
                            String dateFormat = fieldObj.optString(DATEFORMAT);
                            if (dateFormat.trim().isEmpty()) {
                                dateFormat = "yyyy-MM-dd";
                            }
                            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                            Array.set(array, j, format.parse(jsonArray.optString(j)));
                        }
                    } else {
                        array = null;
                    }
                    field.set(instance, array);
                    continue;
                }
                if ("date".equalsIgnoreCase(fieldType)) {
                    String dateStr = null;
                    try {
                        dateStr = fieldObj.getString(FIELDVALUE_JSON);
                        SimpleDateFormat sdf = new SimpleDateFormat(fieldObj.getString(DATEFORMAT));
                        Date d = sdf.parse(dateStr);
                        field.set(instance, d);
                    }
                    catch (ParseException e) {
                        log.error("error parsing " + dateStr + " in format " + fieldObj.getString(DATEFORMAT) + " for " + fieldName + " for " + instance.getClass().getName());
                    }
                    continue;
                }
                if ("Integer".equalsIgnoreCase(fieldType)) {
                    field.set(instance, fieldObj.getInt(FIELDVALUE_JSON));
                    continue;
                }
                if ("Float".equalsIgnoreCase(fieldType)) {
                    field.set(instance, fieldObj.getInt(FIELDVALUE_JSON));
                    continue;
                }
                if ("Long".equalsIgnoreCase(fieldType)) {
                    field.set(instance, fieldObj.getLong(FIELDVALUE_JSON));
                    continue;
                }
                if ("Double".equalsIgnoreCase(fieldType)) {
                    field.set(instance, fieldObj.getDouble(FIELDVALUE_JSON));
                    continue;
                }
                if ("int".equalsIgnoreCase(fieldType)) {
                    field.setInt(instance, fieldObj.getInt(FIELDVALUE_JSON));
                    continue;
                }
                if ("boolean".equalsIgnoreCase(fieldType)) {
                    field.setBoolean(instance, fieldObj.getBoolean(FIELDVALUE_JSON));
                    continue;
                }
                if ("double".equalsIgnoreCase(fieldType)) {
                    if (fieldObj.optString(FIELDVALUE_JSON).isEmpty()) continue;
                    field.setDouble(instance, fieldObj.getDouble(FIELDVALUE_JSON));
                    continue;
                }
                if ("long".equalsIgnoreCase(fieldType)) {
                    if (fieldObj.optString(FIELDVALUE_JSON).isEmpty()) continue;
                    field.setLong(instance, fieldObj.getLong(FIELDVALUE_JSON));
                    continue;
                }
                if ("map".equalsIgnoreCase(fieldType)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    this.buildMapFromJsonArray(fieldObj.getJSONArray(FIELDS), map);
                    field.set(instance, map);
                    continue;
                }
                if ("list".equalsIgnoreCase(fieldType)) {
                    JSONArray listArray = fieldObj.getJSONArray(FIELDVALUE_JSON);
                    String classNameList = fieldObj.getString(CLASSNAME_JSON);
                    Class<?> listClazz = Class.forName(classNameList);
                    ArrayList objList = new ArrayList();
                    for (Object obj : listArray) {
                        if (!(listClazz.isPrimitive() || listClazz.equals(String.class) || listClazz.equals(Date.class) || listClazz.isArray() || List.class.isAssignableFrom(listClazz))) {
                            objList.add(listClazz.cast(this.populateObject((JSONObject)obj, fieldObj)));
                            continue;
                        }
                        objList.add(listClazz.cast(obj));
                    }
                    field.set(instance, objList);
                    continue;
                }
                if (!fieldObj.has(FIELDS)) continue;
                Object nestedInstance = this.populateObject(fieldObj, null);
                field.set(instance, nestedInstance);
            }
            return instance;
        }
        catch (Exception e) {
            log.warn(" could not populate " + jsonObject);
            return instance;
        }
    }

    public String convertClassToJSONString(Class<?> clazz) {
        JSONObject classJson = this.getJsonObject(clazz);
        return classJson.toString(4);
    }

    @NotNull
    public JSONObject getJsonObject(Class<?> clazz) {
        JSONObject classJson = new JSONObject();
        classJson.put(CLASSNAME_JSON, (Object)clazz.getName());
        JSONArray fieldsArray = new JSONArray();
        for (Field field : clazz.getDeclaredFields()) {
            JSONObject fieldJson = this.getObject(field);
            if (fieldJson == null) continue;
            fieldsArray.put((Object)fieldJson);
        }
        classJson.put(FIELDS, (Object)fieldsArray);
        return classJson;
    }

    public JSONObject buildBlankListJsonObject(Field field) {
        JSONObject fieldJson = new JSONObject();
        fieldJson.put(CLASSNAME_JSON, (Object)"java.util.List");
        fieldJson.put("prompt", (Object)"put each value inside fieldValue");
        JSONArray fieldsArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put(FIELDVALUE_JSON, (Object)"");
        fieldsArray.put((Object)object);
        fieldJson.put(FIELDS, (Object)fieldsArray);
        if (field != null) {
            fieldJson.put("type", (Object)field.getType().getName());
            if (field.isAnnotationPresent(MapKeyType.class)) {
                Class<?> keyType = field.getAnnotation(MapKeyType.class).value();
                fieldJson.put("keyType", (Object)keyType.getName());
            } else {
                log.warn("Not able to derive the map Key type for " + field);
            }
            if (field.isAnnotationPresent(MapValueType.class)) {
                Class<?> valueType = field.getAnnotation(MapValueType.class).value();
                fieldJson.put("valueType", (Object)valueType.getName());
            } else {
                log.warn("Not able to derive the map Value type for " + field);
            }
        }
        return fieldJson;
    }

    public JSONObject buildBlankMapJsonObject(Field field) {
        JSONObject fieldJson = new JSONObject();
        fieldJson.put(CLASSNAME_JSON, (Object)"java.util.Map");
        JSONArray fieldsArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("key", (Object)"");
        object.put("value", (Object)"");
        fieldsArray.put((Object)object);
        fieldJson.put(FIELDS, (Object)fieldsArray);
        if (field != null) {
            fieldJson.put("type", (Object)field.getType().getName());
            if (field.isAnnotationPresent(MapKeyType.class)) {
                Class<?> keyType = field.getAnnotation(MapKeyType.class).value();
                fieldJson.put("keyType", (Object)keyType.getName());
            } else {
                log.warn("Not able to derive the map Key type for " + field);
            }
            if (field.isAnnotationPresent(MapValueType.class)) {
                Class<?> valueType = field.getAnnotation(MapValueType.class).value();
                fieldJson.put("valueType", (Object)valueType.getName());
            } else {
                log.warn("Not able to derive the map Value type for " + field);
            }
        }
        return fieldJson;
    }

    public JSONObject getJsonObjectForList(Class<?> clazz, String fieldName) {
        JSONObject classJson = new JSONObject();
        classJson.put(CLASSNAME_JSON, (Object)clazz.getName());
        JSONArray fieldsArray = new JSONArray();
        for (Field field : clazz.getDeclaredFields()) {
            JSONObject fieldJson = this.getObject(field);
            if (fieldJson == null) continue;
            fieldsArray.put((Object)fieldJson);
        }
        classJson.put(FIELDNAME, (Object)fieldName);
        classJson.put(FIELDTYPE, (Object)clazz.getName());
        classJson.put(FIELDS, (Object)fieldsArray);
        return classJson;
    }

    @Nullable
    private JSONObject getObject(Field field) {
        field.setAccessible(true);
        Prompt promptAnnotation = null;
        if (field.isAnnotationPresent(Prompt.class) && (promptAnnotation = field.getAnnotation(Prompt.class)).ignore()) {
            return null;
        }
        JSONObject fieldJson = new JSONObject();
        fieldJson.put(FIELDNAME, (Object)field.getName());
        if (field.getType().equals(Integer.class)) {
            fieldJson.put(FIELDTYPE, (Object)"Integer");
            fieldJson.put(FIELDVALUE_JSON, (Object)"");
        } else if (field.getType().equals(Double.class)) {
            fieldJson.put(FIELDTYPE, (Object)"Double");
            fieldJson.put(FIELDVALUE_JSON, (Object)"");
        } else if (field.getType().equals(Long.class)) {
            fieldJson.put(FIELDTYPE, (Object)"Long");
            fieldJson.put(FIELDVALUE_JSON, (Object)"");
        } else if (field.getType().equals(Float.class)) {
            fieldJson.put(FIELDTYPE, (Object)"Float");
            fieldJson.put(FIELDVALUE_JSON, (Object)"");
        } else if (!(field.getType().isPrimitive() || field.getType().equals(String.class) || field.getType().equals(Date.class) || field.getType().isArray() || List.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType()))) {
            JSONArray innerFieldsDetails = new JSONArray();
            for (Field innerField : field.getType().getDeclaredFields()) {
                Object innerFieldJson = this.getJsonObject(innerField);
                if (innerFieldJson == null) continue;
                innerFieldsDetails.put(innerFieldJson);
            }
            fieldJson.put(FIELDS, (Object)innerFieldsDetails);
            fieldJson.put(FIELDTYPE, (Object)field.getType().getName());
            fieldJson.put(CLASSNAME_JSON, (Object)field.getType().getName());
        } else if (List.class.isAssignableFrom(field.getType())) {
            this.addList(field, fieldJson);
        } else if (field.getType().isArray()) {
            Class<?> componentType = field.getType().getComponentType();
            fieldJson.put("isArray", true);
            fieldJson.put(FIELDTYPE, (Object)(componentType.getSimpleName() + "[]"));
            JSONArray array = new JSONArray();
            if (!(componentType.isPrimitive() || componentType.equals(String.class) || componentType.equals(Date.class) || componentType.isArray() || List.class.isAssignableFrom(componentType))) {
                array.put((Object)this.getJsonObject(componentType));
            } else {
                array.put(componentType);
            }
            fieldJson.put(FIELDVALUE_JSON, (Object)array);
        } else if (Map.class.isAssignableFrom(field.getType())) {
            this.addMap(field, fieldJson);
        } else {
            fieldJson.put(FIELDTYPE, (Object)field.getType().getSimpleName());
            fieldJson.put(FIELDVALUE_JSON, (Object)"");
        }
        if (promptAnnotation != null) {
            if (!promptAnnotation.describe().isEmpty()) {
                fieldJson.put("description", (Object)promptAnnotation.describe());
            }
            if (!promptAnnotation.dateFormat().isEmpty()) {
                fieldJson.put(DATEFORMAT, (Object)promptAnnotation.dateFormat());
            }
        }
        return fieldJson;
    }

    private void addList(Field field, JSONObject fieldJson) {
        fieldJson.put(FIELDTYPE, (Object)"list");
        if (field.isAnnotationPresent(ListType.class)) {
            Class<?> listType = field.getAnnotation(ListType.class).value();
            JSONArray innerFieldsDetails = new JSONArray();
            if (!(listType.isPrimitive() || listType.equals(String.class) || listType.equals(Date.class) || listType.isArray() || List.class.isAssignableFrom(listType))) {
                fieldJson.put(FIELDTYPE, (Object)"list");
                fieldJson.put(CLASSNAME_JSON, (Object)listType.getName());
                fieldJson.put(FIELDNAME, (Object)field.getName());
                fieldJson.put("prompt", (Object)(IF_YOU_FIND_MORE_THAN_1 + listType.getSimpleName() + ADD_IT_AS_ANOTHER_OBJECT_INSIDE_FIELD_VALUE));
                innerFieldsDetails.put((Object)this.getJsonObjectForList(listType, field.getName()));
            } else {
                fieldJson.put(CLASSNAME_JSON, (Object)listType.getName());
                fieldJson.put(FIELDTYPE, (Object)"list");
                fieldJson.put(FIELDNAME, (Object)field.getName());
                fieldJson.put("description", (Object)("there could be multiple " + listType.getSimpleName()));
                innerFieldsDetails.put((Object)listType.getName());
            }
            fieldJson.put(FIELDVALUE_JSON, (Object)innerFieldsDetails);
        } else {
            log.warn("Not able to derive the list type for " + field + " use the ListType annotation ");
        }
    }

    private void addMap(Field field, JSONObject fieldJson) {
        fieldJson.put(FIELDTYPE, (Object)"map");
        fieldJson.put("prompt", (Object)"create the key value pair and put in fields");
        JSONArray array = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("key", (Object)"");
        object.put("value", (Object)"");
        array.put((Object)object);
        fieldJson.put(FIELDS, (Object)array);
        fieldJson.put("type", (Object)field.getType().getName());
        if (field.isAnnotationPresent(MapKeyType.class)) {
            Class<?> keyType = field.getAnnotation(MapKeyType.class).value();
            fieldJson.put("keyType", (Object)keyType.getName());
        } else {
            log.warn("Not able to derive the map Key type for " + field);
        }
        if (field.isAnnotationPresent(MapValueType.class)) {
            Class<?> valueType = field.getAnnotation(MapValueType.class).value();
            fieldJson.put("valueType", (Object)valueType.getName());
        } else {
            log.warn("Not able to derive the map Value type for " + field);
        }
    }

    public void addMap(Parameter field, JSONObject fieldJson) {
        fieldJson.put(FIELDTYPE, (Object)"map");
        fieldJson.put("prompt", (Object)"create the key value pair and put in fields");
        JSONArray array = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("key", (Object)"");
        object.put("value", (Object)"");
        array.put((Object)object);
        fieldJson.put(FIELDS, (Object)array);
        fieldJson.put("type", (Object)field.getType().getName());
        if (field.isAnnotationPresent(MapKeyType.class)) {
            Class<?> keyType = field.getAnnotation(MapKeyType.class).value();
            fieldJson.put("keyType", (Object)keyType.getName());
        } else {
            log.warn("Not able to derive the map Key type for " + field);
        }
        if (field.isAnnotationPresent(MapValueType.class)) {
            Class<?> valueType = field.getAnnotation(MapValueType.class).value();
            fieldJson.put("valueType", (Object)valueType.getName());
        } else {
            log.warn("Not able to derive the map Value type for " + field);
        }
    }

    private void addList(Parameter field, JSONObject fieldJson) {
        fieldJson.put(FIELDTYPE, (Object)"list");
        if (field.isAnnotationPresent(ListType.class)) {
            Class<?> listType = field.getAnnotation(ListType.class).value();
            JSONArray innerFieldsDetails = new JSONArray();
            if (!(listType.isPrimitive() || listType.equals(String.class) || listType.equals(Date.class) || listType.isArray() || List.class.isAssignableFrom(listType))) {
                fieldJson.put(FIELDTYPE, (Object)"list");
                fieldJson.put(CLASSNAME_JSON, (Object)listType.getName());
                fieldJson.put(FIELDNAME, (Object)field.getName());
                fieldJson.put("prompt", (Object)(IF_YOU_FIND_MORE_THAN_1 + listType.getSimpleName() + ADD_IT_AS_ANOTHER_OBJECT_INSIDE_FIELD_VALUE));
                innerFieldsDetails.put((Object)this.getJsonObjectForList(listType, field.getName()));
            } else {
                fieldJson.put(CLASSNAME_JSON, (Object)listType.getName());
                fieldJson.put(FIELDTYPE, (Object)"list");
                fieldJson.put(FIELDNAME, (Object)field.getName());
                fieldJson.put("description", (Object)("there could be multiple " + listType.getSimpleName()));
                innerFieldsDetails.put((Object)listType.getName());
            }
            fieldJson.put(FIELDVALUE_JSON, (Object)innerFieldsDetails);
        } else {
            log.warn("Not able to derive the list type for " + field);
        }
    }

    public String convertMethodTOJsonString(Method method) {
        JSONObject methodJson = new JSONObject();
        methodJson.put("methodName", (Object)method.getName());
        JSONArray parameters = new JSONArray();
        for (Parameter parameter : method.getParameters()) {
            Prompt promptAnnotation = null;
            if (parameter.isAnnotationPresent(Prompt.class) && (promptAnnotation = parameter.getAnnotation(Prompt.class)).ignore()) continue;
            JSONObject paramJson = new JSONObject();
            paramJson.put("name", (Object)parameter.getName());
            if (!(parameter.getType().isPrimitive() || parameter.getType().equals(String.class) || parameter.getType().equals(Date.class) || parameter.getType().isArray() || List.class.isAssignableFrom(parameter.getType()) || Map.class.isAssignableFrom(parameter.getType()))) {
                JSONArray fieldDetails = new JSONArray();
                for (Field field : parameter.getType().getDeclaredFields()) {
                    Object fieldJson = this.getJsonObject(field);
                    if (fieldJson == null) continue;
                    fieldDetails.put(fieldJson);
                }
                paramJson.put(FIELDS, (Object)fieldDetails);
                paramJson.put("type", (Object)parameter.getType().getName());
            } else if (parameter.getType().isArray()) {
                Class<?> componentType = parameter.getType().getComponentType();
                paramJson.put("isArray", true);
                paramJson.put("type", (Object)(componentType.getSimpleName() + "[]"));
                paramJson.put(CLASSNAME_JSON, (Object)componentType.getName());
                JSONArray array = new JSONArray();
                if (!(componentType.isPrimitive() || componentType.equals(String.class) || componentType.equals(Date.class) || componentType.isArray() || List.class.isAssignableFrom(componentType))) {
                    array.put((Object)this.getJsonObject(componentType));
                } else {
                    array.put(componentType);
                }
                paramJson.put(FIELDVALUE_JSON, (Object)array);
                paramJson.put("prompt", (Object)(IF_YOU_FIND_MORE_THAN_1 + componentType.getSimpleName() + ADD_IT_AS_ANOTHER_OBJECT_INSIDE_FIELD_VALUE));
            } else if (List.class.isAssignableFrom(parameter.getType())) {
                this.addList(parameter, paramJson);
            } else if (Map.class.isAssignableFrom(parameter.getType())) {
                this.addMap(parameter, paramJson);
            } else {
                paramJson.put("type", (Object)parameter.getType().getSimpleName());
                paramJson.put(FIELDVALUE_JSON, (Object)"");
            }
            if (promptAnnotation != null) {
                if (!promptAnnotation.describe().isEmpty()) {
                    paramJson.put("fieldDescription", (Object)promptAnnotation.describe());
                }
                if (!promptAnnotation.dateFormat().isEmpty()) {
                    paramJson.put(DATEFORMAT, (Object)promptAnnotation.dateFormat());
                }
            }
            parameters.put((Object)paramJson);
        }
        methodJson.put("parameters", (Object)parameters);
        methodJson.put("returnType", (Object)method.getReturnType().getSimpleName());
        log.info(methodJson.toString(4));
        return methodJson.toString(4);
    }

    private Object getJsonObject(Field field) {
        JSONObject fieldJson = new JSONObject();
        Prompt promptAnnotation = null;
        if (field.isAnnotationPresent(Prompt.class)) {
            promptAnnotation = field.getAnnotation(Prompt.class);
        }
        if (promptAnnotation != null && promptAnnotation.ignore()) {
            return null;
        }
        if (promptAnnotation != null) {
            if (!promptAnnotation.describe().isEmpty()) {
                fieldJson.put("fieldDescription", (Object)promptAnnotation.describe());
            }
            if (!promptAnnotation.dateFormat().isEmpty()) {
                fieldJson.put(DATEFORMAT, (Object)promptAnnotation.dateFormat());
            }
        }
        fieldJson.put(FIELDNAME, (Object)field.getName());
        Class<?> fieldType = field.getType();
        if (!(fieldType.isPrimitive() || fieldType.equals(String.class) || fieldType.equals(Date.class) || fieldType.isArray() || List.class.isAssignableFrom(fieldType))) {
            JSONArray fieldDetails = new JSONArray();
            for (Field childfield : field.getType().getDeclaredFields()) {
                Object childfieldJson = this.getJsonObject(childfield);
                if (childfieldJson == null) continue;
                fieldDetails.put(childfieldJson);
            }
            fieldJson.put(FIELDTYPE, (Object)fieldType.getName());
            fieldJson.put(FIELDS, (Object)fieldDetails);
            return fieldJson;
        }
        if (List.class.isAssignableFrom(fieldType)) {
            this.addList(field, fieldJson);
            return fieldJson;
        }
        if (fieldType.isArray()) {
            Class<?> componentType = fieldType.getComponentType();
            fieldJson.put("isArray", true);
            fieldJson.put("type", (Object)(componentType.getSimpleName() + "[]"));
            fieldJson.put(CLASSNAME_JSON, (Object)componentType.getName());
            JSONArray array = new JSONArray();
            if (!(componentType.isPrimitive() || componentType.equals(String.class) || componentType.equals(Date.class) || componentType.isArray() || List.class.isAssignableFrom(componentType))) {
                array.put((Object)this.getJsonObject(componentType));
            } else {
                array.put(componentType);
            }
            fieldJson.put(FIELDVALUE_JSON, (Object)array);
            fieldJson.put("prompt", (Object)(IF_YOU_FIND_MORE_THAN_1 + componentType.getSimpleName() + ADD_IT_AS_ANOTHER_OBJECT_INSIDE_FIELD_VALUE));
        }
        fieldJson.put(FIELDTYPE, (Object)fieldType.getSimpleName());
        if (!fieldJson.has(FIELDVALUE_JSON)) {
            fieldJson.put(FIELDVALUE_JSON, (Object)"");
        }
        return fieldJson;
    }

    public void processProperties(ObjectNode parentNode, Map<String, Schema> properties) {
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            Schema propertySchema = entry.getValue();
            String value = propertySchema.getDefault() != null ? propertySchema.getDefault().toString() : propertySchema.getType();
            parentNode.put(propertyName, value);
            if (!(propertySchema instanceof ObjectSchema)) continue;
            ObjectNode objectNode = mapper.createObjectNode();
            parentNode.set(propertyName, (JsonNode)objectNode);
            this.processProperties(objectNode, ((ObjectSchema)propertySchema).getProperties());
        }
    }

    public String createJson(String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("At least one key is required");
        }
        JsonObject rootObject = new JsonObject();
        JsonArray array = new JsonArray();
        rootObject.add(FIELDS, (JsonElement)array);
        for (String key : keys) {
            array.add((JsonElement)this.createJson(key));
        }
        return rootObject.toString();
    }

    @NotNull
    public JsonObject createJson(String key) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty(FIELDNAME, key);
        jsonObj.addProperty(FIELDTYPE, "String");
        jsonObj.addProperty(FIELDVALUE_JSON, "");
        return jsonObj;
    }

    public String getFieldValue(String jsonStr, String fieldName) {
        JSONObject obj = new JSONObject(jsonStr = this.extractJson(jsonStr));
        String fieldValue = obj.optString(FIELDVALUE_JSON, null);
        if (fieldValue == null) {
            fieldValue = jsonStr;
        }
        log.debug(fieldName + " is the fieldName");
        return fieldValue;
    }

    public static String convertObjectToJson(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

