/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.action.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.t4a.action.http.HttpMethod;
import com.t4a.action.http.InputParameter;
import com.t4a.api.ActionType;
import com.t4a.api.PredictedAIAction;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpPredictedAction
implements PredictedAIAction {
    private static final Logger log = LoggerFactory.getLogger(HttpPredictedAction.class);
    private Map<String, Object> jsonMap;
    Map<String, String> headers;
    private String actionName;
    private String url;
    private HttpMethod type;
    List<InputParameter> inputObjects;
    private JsonObject outputObject;
    private JsonObject authInterface;
    private String description;
    private HttpClient client = HttpClientBuilder.create().build();
    private String requestBodyJson;
    private boolean hasJson;
    private String group;
    private String groupDescription;
    private final Gson gson = new Gson();

    public HttpPredictedAction(String actionName, String url, HttpMethod type, List<InputParameter> inputObjects, JsonObject outputObject, JsonObject authInterface, String description) {
        this.actionName = actionName;
        this.url = url;
        this.type = type;
        this.inputObjects = inputObjects;
        this.outputObject = outputObject;
        this.authInterface = authInterface;
        this.description = description;
    }

    public String replacePlaceholders(String url, Map<String, Object> placeholderValues) throws UnsupportedEncodingException {
        for (Map.Entry<String, Object> entry : placeholderValues.entrySet()) {
            String placeholder = "{" + entry.getKey() + "}";
            String value = String.valueOf(entry.getValue());
            value = URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
            url = url.replace(placeholder, value);
        }
        return url;
    }

    @Override
    public String getActionGroup() {
        return this.group;
    }

    public String executeHttpGet(Map<String, Object> parameters) throws UnsupportedEncodingException {
        if (this.url.indexOf("{") != -1) {
            this.url = this.replacePlaceholders(this.url, parameters);
        } else {
            StringBuilder queryString = new StringBuilder();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                if (queryString.length() > 0) {
                    queryString.append("&");
                }
                queryString.append(entry.getKey()).append("=").append(entry.getValue());
            }
            if (queryString.length() > 0) {
                this.url = this.url + "?" + queryString.toString();
            }
        }
        try {
            HttpResponse response;
            HttpEntity httpEntity;
            log.debug("sending request to " + this.url);
            HttpGet request = new HttpGet(this.url);
            if (this.headers != null) {
                for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
                    request.addHeader(entry.getKey(), (String)entry.getValue());
                }
            }
            if ((httpEntity = (response = this.client.execute((HttpUriRequest)request)).getEntity()) != null) {
                String jsonResponse = EntityUtils.toString((HttpEntity)httpEntity);
                log.debug("Response: from Url " + this.url + " is " + jsonResponse);
                return jsonResponse;
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
        return null;
    }

    public String executeHttpPost(Map<String, Object> postData) throws IOException {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, Object> entry : postData.entrySet()) {
            json.addProperty(entry.getKey(), (String)entry.getValue());
        }
        String jsonPayload = this.gson.toJson((JsonElement)json);
        HttpPost request = new HttpPost(this.url);
        if (this.headers != null) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                request.addHeader(header.getKey(), header.getValue());
            }
        }
        request.setEntity((HttpEntity)new StringEntity(jsonPayload, ContentType.APPLICATION_JSON));
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        String respStr = EntityUtils.toString((HttpEntity)response.getEntity());
        log.debug("Response from url " + this.url + " is " + respStr);
        return respStr;
    }

    public String executeHttpRequest(Map<String, Object> params) throws IOException {
        for (InputParameter parameter : this.inputObjects) {
            if (!parameter.hasDefaultValue()) continue;
            params.put(parameter.getName(), parameter.getDefaultValue());
        }
        if (HttpMethod.GET == this.getType()) {
            return this.executeHttpGet(params);
        }
        if (HttpMethod.POST == this.getType()) {
            return this.executeHttpPost(params);
        }
        return null;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.HTTP;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "HttpPredictedAction{actionName='" + this.actionName + '\'' + ", url='" + this.url + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + ", inputObjects=" + this.inputObjects + ", outputObject=" + this.outputObject + ", authInterface=" + this.authInterface + ", description='" + this.description + '\'' + ", client=" + this.client + ", gson=" + this.gson + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpPredictedAction that = (HttpPredictedAction)o;
        return Objects.equals(this.actionName, that.actionName);
    }

    public int hashCode() {
        return Objects.hash(this.actionName);
    }

    public Map<String, Object> getJsonMap() {
        return this.jsonMap;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getType() {
        return this.type;
    }

    public List<InputParameter> getInputObjects() {
        return this.inputObjects;
    }

    public JsonObject getOutputObject() {
        return this.outputObject;
    }

    public JsonObject getAuthInterface() {
        return this.authInterface;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public String getRequestBodyJson() {
        return this.requestBodyJson;
    }

    public boolean isHasJson() {
        return this.hasJson;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupDescription() {
        return this.groupDescription;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setJsonMap(Map<String, Object> jsonMap) {
        this.jsonMap = jsonMap;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setType(HttpMethod type) {
        this.type = type;
    }

    public void setInputObjects(List<InputParameter> inputObjects) {
        this.inputObjects = inputObjects;
    }

    public void setOutputObject(JsonObject outputObject) {
        this.outputObject = outputObject;
    }

    public void setAuthInterface(JsonObject authInterface) {
        this.authInterface = authInterface;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRequestBodyJson(String requestBodyJson) {
        this.requestBodyJson = requestBodyJson;
    }

    public void setHasJson(boolean hasJson) {
        this.hasJson = hasJson;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
    }

    public HttpPredictedAction() {
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }
}

